/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import music.cpp.client.LibraryOptions;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeEngine;

public class LibraryOptions
extends JPanel {
    static final String iConnectToServer = MusicClient.STRINGS.get("IDSTR_LO_CONNECT_TO_SERVER");
    static final String iServerTest = MusicClient.STRINGS.get("IDSTR_SERVER_TEST");
    static final String iEnableProxy = MusicClient.STRINGS.get("IDSTR_LO_ENABLE_PROXY");
    static final String iHost = MusicClient.STRINGS.get("IDSTR_LO_HOST");
    static final String iPort = MusicClient.STRINGS.get("IDSTR_LO_PORT");
    static final String iEnableProxyAuth = MusicClient.STRINGS.get("IDSTR_LO_ENABLE_PROXY_AUTH");
    static final String iUsername = MusicClient.STRINGS.get("IDSTR_LO_USERNAME");
    static final String iPassword = MusicClient.STRINGS.get("IDSTR_LO_PASSWORD");
    static final String iNoConnection = MusicClient.STRINGS.get("IDSTR_NO_CONNECTION");
    static final String iOKConnection = MusicClient.STRINGS.get("IDSTR_OK_CONNECTION");
    JCheckBox useServer;
    JButton testConnection;
    JCheckBox useProxy;
    JCheckBox proxyAuth;
    JTextField proxyHost;
    JTextField proxyPort;
    JTextField proxyUser;
    JPasswordField proxyPass;
    JLabel proxyHostLabel;
    JLabel proxyPortLabel;
    JLabel proxyUserLabel;
    JLabel proxyPassLabel;
    MusicClient client;
    boolean oldServer;

    public LibraryOptions(MusicClient musicClient) {
        super(new BorderLayout());
        this.client = musicClient;
        this.client.updateProxy();
        this.oldServer = this.client.getUseServer();
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom += 20;
        this.useServer = new JCheckBox(iConnectToServer, this.client.getUseServer());
        this.useServer.setOpaque(false);
        gridBagLayout.setConstraints(this.useServer, gridBagConstraints);
        jPanel.add(this.useServer);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        this.testConnection = new JButton(iServerTest);
        this.testConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptions.this.apply();
                new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        long l = NativeEngine.checkKey(1.access$000(this.this$1).client.userKey);
                        SwingUtilities.invokeLater(new Runnable(this, l){
                            private final /* synthetic */ long val$resp;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$resp = l;
                            }

                            public void run() {
                                if (this.val$resp > 0L) {
                                    1.access$000(2.access$100(this.this$2)).client.showMessage(iOKConnection);
                                } else {
                                    1.access$000(2.access$100(this.this$2)).client.showMessage(iNoConnection);
                                }
                                if (1.access$000(2.access$100(this.this$2)).client.updateProxy()) {
                                    1.access$000(2.access$100(this.this$2)).useProxy.setSelected(1.access$000(2.access$100(this.this$2)).client.getUseProxy());
                                    1.access$000(2.access$100(this.this$2)).setProxyControlsState();
                                    if (1.access$000(2.access$100(this.this$2)).client.getUseProxy()) {
                                        1.access$000(2.access$100(this.this$2)).proxyHost.setText(1.access$000(2.access$100(this.this$2)).client.getProxyHost());
                                        1.access$000(2.access$100(this.this$2)).proxyPort.setText(String.valueOf(1.access$000(2.access$100(this.this$2)).client.getProxyPort()));
                                    } else {
                                        1.access$000(2.access$100(this.this$2)).proxyHost.setText("");
                                        1.access$000(2.access$100(this.this$2)).proxyPort.setText("");
                                    }
                                }
                            }
                        });
                    }

                    static /* synthetic */ 1 access$100(2 var0) {
                        return var0.this$1;
                    }
                }.start();
            }

            static /* synthetic */ LibraryOptions access$000(1 var0) {
                return var0.LibraryOptions.this;
            }
        });
        gridBagLayout.setConstraints(this.testConnection, gridBagConstraints);
        jPanel.add(this.testConnection);
        gridBagConstraints.insets.bottom -= 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.useProxy = new JCheckBox(iEnableProxy, this.client.getUseProxy());
        this.useProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptions.this.setProxyControlsState();
            }
        });
        gridBagLayout.setConstraints(this.useProxy, gridBagConstraints);
        jPanel.add(this.useProxy);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.proxyHostLabel = new JLabel(iHost);
        gridBagLayout.setConstraints(this.proxyHostLabel, gridBagConstraints);
        jPanel.add(this.proxyHostLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.proxyHost = new JTextField(20){

            public Color getBackground() {
                return this.isEnabled() ? super.getBackground() : SystemColor.control;
            }

            public Color getForeground() {
                return this.isEnabled() ? super.getForeground() : SystemColor.textInactiveText;
            }
        };
        if (this.client.getProxyHost() != null) {
            this.proxyHost.setText(this.client.getProxyHost());
        }
        gridBagLayout.setConstraints(this.proxyHost, gridBagConstraints);
        jPanel.add(this.proxyHost);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.proxyPortLabel = new JLabel(iPort);
        gridBagLayout.setConstraints(this.proxyPortLabel, gridBagConstraints);
        jPanel.add(this.proxyPortLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.proxyPort = new JTextField(6){

            public Color getBackground() {
                return this.isEnabled() ? super.getBackground() : SystemColor.control;
            }

            public Color getForeground() {
                return this.isEnabled() ? super.getForeground() : SystemColor.textInactiveText;
            }
        };
        if (this.client.getProxyPort() != 0) {
            this.proxyPort.setText(String.valueOf(this.client.getProxyPort()));
        }
        gridBagLayout.setConstraints(this.proxyPort, gridBagConstraints);
        jPanel.add(this.proxyPort);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        this.proxyAuth = new JCheckBox(iEnableProxyAuth, this.client.getUseProxyAuth());
        this.proxyAuth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryOptions.this.setProxyControlsState();
            }
        });
        gridBagLayout.setConstraints(this.proxyAuth, gridBagConstraints);
        jPanel.add(this.proxyAuth);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.proxyUserLabel = new JLabel(iUsername);
        gridBagLayout.setConstraints(this.proxyUserLabel, gridBagConstraints);
        jPanel.add(this.proxyUserLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.proxyUser = new JTextField(30){

            public Color getBackground() {
                return this.isEnabled() ? super.getBackground() : SystemColor.control;
            }

            public Color getForeground() {
                return this.isEnabled() ? super.getForeground() : SystemColor.textInactiveText;
            }
        };
        if (this.client.getProxyUser() != null) {
            this.proxyUser.setText(this.client.getProxyUser());
        }
        gridBagLayout.setConstraints(this.proxyUser, gridBagConstraints);
        jPanel.add(this.proxyUser);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.proxyPassLabel = new JLabel(iPassword);
        gridBagLayout.setConstraints(this.proxyPassLabel, gridBagConstraints);
        jPanel.add(this.proxyPassLabel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.proxyPass = new JPasswordField(30){

            public Color getBackground() {
                return this.isEnabled() ? super.getBackground() : SystemColor.control;
            }

            public Color getForeground() {
                return this.isEnabled() ? super.getForeground() : SystemColor.textInactiveText;
            }
        };
        if (this.client.getProxyPass() != null) {
            this.proxyPass.setText(this.client.getProxyPass());
        }
        gridBagLayout.setConstraints(this.proxyPass, gridBagConstraints);
        jPanel.add(this.proxyPass);
        this.add("Center", jPanel);
        this.setProxyControlsState();
    }

    void setProxyControlsState() {
        if (this.useProxy.isSelected()) {
            this.proxyHost.setEnabled(true);
            this.proxyPort.setEnabled(true);
            this.proxyHostLabel.setEnabled(true);
            this.proxyPortLabel.setEnabled(true);
            this.proxyAuth.setEnabled(true);
            if (this.proxyAuth.isSelected()) {
                this.proxyUser.setEnabled(true);
                this.proxyPass.setEnabled(true);
                this.proxyUserLabel.setEnabled(true);
                this.proxyPassLabel.setEnabled(true);
            } else {
                this.proxyUser.setEnabled(false);
                this.proxyPass.setEnabled(false);
                this.proxyUserLabel.setEnabled(false);
                this.proxyPassLabel.setEnabled(false);
            }
        } else {
            this.proxyHost.setEnabled(false);
            this.proxyPort.setEnabled(false);
            this.proxyHostLabel.setEnabled(false);
            this.proxyPortLabel.setEnabled(false);
            this.proxyAuth.setEnabled(false);
            this.proxyUser.setEnabled(false);
            this.proxyPass.setEnabled(false);
            this.proxyUserLabel.setEnabled(false);
            this.proxyPassLabel.setEnabled(false);
        }
    }

    boolean apply() {
        this.client.setUseServer(this.useServer.isSelected());
        if (this.useProxy.isSelected()) {
            try {
                String string = this.proxyHost.getText();
                if (string.startsWith("http://")) {
                    string = string.substring(7);
                    this.proxyHost.setText(string);
                }
                this.client.setProxy(string, Integer.parseInt(this.proxyPort.getText()));
                if (this.proxyAuth.isSelected()) {
                    this.client.setProxyAuth(this.proxyUser.getText(), this.proxyPass.getText());
                }
                this.client.setProxyAuth(null, null);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else {
            this.client.setProxy(null, 0);
            this.client.setProxyAuth(null, null);
        }
        return true;
    }
}

