/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.Skin;
import music.cpp.client.StringUtil;

public class GeneralOptions
extends JPanel {
    static final String iLoadFolderImages = MusicClient.STRINGS.get("IDSTR_LOAD_FOLDER_IMAGES");
    static final String iAddM3Us = MusicClient.STRINGS.get("IDSTR_ADD_M3US");
    static final String iCheckForUpdates = MusicClient.STRINGS.get("IDSTR_CHECK_FOR_UPDATES");
    static final String iCheckTimestamp = MusicClient.STRINGS.get("IDSTR_GO_CHECK_TIMESTAMP");
    static final String iPreserveTimestamp = MusicClient.STRINGS.get("IDSTR_GO_PRESERVE_TIMESTAMP");
    static final String iScanVBR = MusicClient.STRINGS.get("IDSTR_SCAN_VBR");
    static final String iAllowID3V24Tags = MusicClient.STRINGS.get("IDSTR_ALLOW_ID3V24_TAGS");
    static final String iReset = MusicClient.STRINGS.get("IDSTR_LO_RESET");
    static final String iAutoArchive = MusicClient.STRINGS.get("IDSTR_GO_AUTO_ARCHIVE");
    JPanel p1;
    Label2 duplicates;
    JButton reset;
    MusicClient client;
    boolean oldServer;
    JCheckBox addM3Us;
    JCheckBox checkForUpdates;
    JCheckBox checkTimestamp;
    JCheckBox folderImages;
    JCheckBox vbr;
    JCheckBox preserveTimestamp;
    JCheckBox autoArchive;
    JCheckBox id3v24;

    public GeneralOptions(MusicClient musicClient) {
        super(new BorderLayout());
        this.client = musicClient;
        this.oldServer = this.client.getUseServer();
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        this.addM3Us = new JCheckBox(iAddM3Us, this.client.addPlaylistsOnScan);
        gridBagLayout.setConstraints(this.addM3Us, gridBagConstraints);
        jPanel.add(this.addM3Us);
        ++gridBagConstraints.gridy;
        this.checkForUpdates = new JCheckBox(iCheckForUpdates, this.client.checkForSoftwareUpdates);
        gridBagLayout.setConstraints(this.checkForUpdates, gridBagConstraints);
        jPanel.add(this.checkForUpdates);
        ++gridBagConstraints.gridy;
        this.checkTimestamp = new JCheckBox(iCheckTimestamp, this.client.checkTimestampOnRefresh);
        gridBagLayout.setConstraints(this.checkTimestamp, gridBagConstraints);
        jPanel.add(this.checkTimestamp);
        ++gridBagConstraints.gridy;
        this.preserveTimestamp = new JCheckBox(iPreserveTimestamp, this.client.isPreserveTimestamp());
        gridBagLayout.setConstraints(this.preserveTimestamp, gridBagConstraints);
        jPanel.add(this.preserveTimestamp);
        ++gridBagConstraints.gridy;
        this.autoArchive = new JCheckBox(iAutoArchive, this.client.isAutoArchive());
        gridBagLayout.setConstraints(this.autoArchive, gridBagConstraints);
        jPanel.add(this.autoArchive);
        ++gridBagConstraints.gridy;
        this.folderImages = new JCheckBox(iLoadFolderImages, this.client.loadFolderImages);
        gridBagLayout.setConstraints(this.folderImages, gridBagConstraints);
        jPanel.add(this.folderImages);
        ++gridBagConstraints.gridy;
        this.vbr = new JCheckBox(iScanVBR, this.client.getScanVBR());
        gridBagLayout.setConstraints(this.vbr, gridBagConstraints);
        jPanel.add(this.vbr);
        ++gridBagConstraints.gridy;
        this.id3v24 = new JCheckBox(iAllowID3V24Tags, this.client.getID3V24());
        gridBagLayout.setConstraints(this.id3v24, gridBagConstraints);
        jPanel.add(this.id3v24);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top += 10;
        this.p1 = new JPanel(new FlowLayout(0, 0, 5));
        this.duplicates = new Label2();
        this.p1.add(this.duplicates);
        this.p1.add(new JPanel(){

            public boolean isOpaque() {
                return false;
            }

            public Dimension getPreferredSize() {
                int n = (GeneralOptions.this.p1.getWidth() - Skin.getSkin().longbutton.getIconWidth()) / 2 - GeneralOptions.this.duplicates.getWidth();
                return new Dimension(n, 10);
            }
        });
        this.reset = new JButton(iReset);
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptions.this.client.resetDuplicates();
                GeneralOptions.this.setDuplicatesCount();
            }
        });
        this.p1.add(this.reset);
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        jPanel.add(this.p1);
        this.add("Center", jPanel);
        this.setDuplicatesCount();
    }

    void setDuplicatesCount() {
        int n = this.client.countMarkedDuplicates();
        this.duplicates.setText(MusicClient.STRINGS.expand("IDSTR_LO_MARKED_DUPS", new String[]{StringUtil.l2ac(n)}));
        if (n == 0) {
            this.reset.setEnabled(false);
        }
        this.p1.revalidate();
        this.p1.repaint();
    }

    boolean apply() {
        this.client.checkForSoftwareUpdates = this.checkForUpdates.isSelected();
        this.client.loadFolderImages = this.folderImages.isSelected();
        this.client.setCheckTimestampOnRefresh(this.checkTimestamp.isSelected());
        this.client.setAddPlaylistsOnScan(this.addM3Us.isSelected());
        this.client.setScanVBR(this.vbr.isSelected());
        this.client.setID3V24(this.id3v24.isSelected());
        this.client.setPreserveTimestamp(this.preserveTimestamp.isSelected());
        this.client.setAutoArchive(this.autoArchive.isSelected());
        return true;
    }
}

