/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import music.cpp.client.DecoratedTableCellRenderer;
import music.cpp.client.Skin;

public abstract class DecoratedSortableTableHeader
extends JTableHeader {
    protected boolean reversed = false;
    protected int selectedColumn;
    protected JLabel upIcon;
    protected JLabel downIcon;
    protected String prefix = null;

    public DecoratedSortableTableHeader() {
        this.init();
    }

    public DecoratedSortableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.init();
    }

    protected void init() {
        this.selectedColumn = -1;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DecoratedSortableTableHeader.this.doMouseClicked(mouseEvent);
            }
        });
        if (this.columnModel != null) {
            this.setColumnRenderers();
        }
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        this.setColumnRenderers();
    }

    protected void setColumnRenderers() {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.columnModel.getColumn(i);
            tableColumn.setHeaderRenderer(new DecoratedTableCellRenderer(this));
        }
    }

    protected void doMouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && this.getResizingColumn() == null) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            if (this.selectedColumn == n) {
                this.reversed = !this.reversed;
            } else {
                this.selectedColumn = n;
                this.reversed = false;
            }
            if (n >= 0) {
                this.sortBy();
            }
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public void setSelectedColumn(int n) {
        this.selectedColumn = n;
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
    }

    public Component getDecoration() {
        JLabel jLabel = null;
        if (this.reversed) {
            if (this.upIcon == null) {
                this.upIcon = new JLabel(Skin.getSkin().sortUp);
            }
            jLabel = this.upIcon;
        } else {
            if (this.downIcon == null) {
                this.downIcon = new JLabel(Skin.getSkin().sortDown);
            }
            jLabel = this.downIcon;
        }
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 2));
        if (this.prefix != null) {
            JPanel jPanel = new JPanel(new GridLayout(1, 2));
            jPanel.add(new JLabel(this.prefix));
            jPanel.add(jLabel);
            return jPanel;
        }
        return jLabel;
    }

    protected abstract void sortBy();
}

