/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import music.cpp.client.FiltersDialog;
import music.cpp.client.MusicClient;
import music.cpp.client.SongFilter;
import music.cpp.client.SortableVector;
import music.cpp.client.Sorter;

class ConditionPanel
extends JPanel {
    static final String iSeconds = MusicClient.STRINGS.get("IDSTR_SECONDS");
    static final String iBytes = MusicClient.STRINGS.get("IDSTR_BYTES");
    static final String iDateFormat = MusicClient.STRINGS.get("IDSTR_DATE_FORMAT");
    static final String iContains = MusicClient.STRINGS.get("IDSTR_STR_CONTAINS");
    static final String iDoesNotContain = MusicClient.STRINGS.get("IDSTR_STR_DOES_NOT_CONTAIN");
    static final String iIs = MusicClient.STRINGS.get("IDSTR_STR_IS");
    static final String iIsNot = MusicClient.STRINGS.get("IDSTR_STR_IS_NOT");
    static final String iStartsWith = MusicClient.STRINGS.get("IDSTR_STR_STARTS_WITH");
    static final String iEndsWith = MusicClient.STRINGS.get("IDSTR_STR_ENDS_WITH");
    static final String iMissing = MusicClient.STRINGS.get("IDSTR_STR_MISSING");
    static final String iNumIs = MusicClient.STRINGS.get("IDSTR_NUM_IS");
    static final String iNumIsNot = MusicClient.STRINGS.get("IDSTR_NUM_IS_NOT");
    static final String iNumGreater = MusicClient.STRINGS.get("IDSTR_NUM_GREATER");
    static final String iNumLess = MusicClient.STRINGS.get("IDSTR_NUM_LESS");
    static final String iNumInRange = MusicClient.STRINGS.get("IDSTR_NUM_IN_RANGE");
    static final String iNumMissing = MusicClient.STRINGS.get("IDSTR_NUM_MISSING");
    static final String iDateIs = MusicClient.STRINGS.get("IDSTR_DATE_IS");
    static final String iDateIsNot = MusicClient.STRINGS.get("IDSTR_DATE_IS_NOT");
    static final String iDateAfter = MusicClient.STRINGS.get("IDSTR_DATE_AFTER");
    static final String iDateBefore = MusicClient.STRINGS.get("IDSTR_DATE_BEFORE");
    static final String iDateInLast = MusicClient.STRINGS.get("IDSTR_DATE_IN_LAST_DAYS");
    static final String iDateNotInLast = MusicClient.STRINGS.get("IDSTR_DATE_NOT_IN_LAST_DAYS");
    static final String iDateInRange = MusicClient.STRINGS.get("IDSTR_DATE_IN_RANGE");
    static final String iTo = MusicClient.STRINGS.get("IDSTR_F_TO");
    static final String iRemove = MusicClient.STRINGS.get("IDSTR_WF_REMOVE");
    static final String iBoolPresent = MusicClient.STRINGS.get("IDSTR_BOOL_PRESENT");
    static final String iBoolMissing = MusicClient.STRINGS.get("IDSTR_BOOL_MISSING");
    public static String[] fieldUnits = new String[]{"", "", iSeconds, "", "", "", "", iBytes, "", "", iDateFormat, "", "", "", "", "", "", "", "", "", "", "", "", iDateFormat, "", "", "", "", iDateFormat, "", "", ""};
    public static String[] stringTypeConditions = new String[]{iContains, iDoesNotContain, iIs, iIsNot, iStartsWith, iEndsWith, iMissing};
    public static String[] numberTypeConditions = new String[]{iNumIs, iNumIsNot, iNumGreater, iNumLess, iNumInRange, iNumMissing};
    public static String[] dateTypeConditions = new String[]{iDateIs, iDateIsNot, iDateAfter, iDateBefore, iDateInLast, iDateNotInLast, iDateInRange};
    public static String[] filterTypeConditions = new String[]{iIs, iIsNot};
    public static String[] boolTypeConditions = new String[]{iBoolPresent, iBoolMissing};
    public static int[] fieldTypes = new int[]{0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 2, 0, 3, 1, 0, 0, 0, 0, 1, 1, 4, 4, 4, 2, 4, 1, 1, 4, 2, 1, 0, 4};
    JComboBox category;
    JComboBox condition;
    JTextField text1;
    JLabel to;
    JTextField text2;
    JComboBox combo;
    JButton remove;
    JPanel values;
    final int w0 = 200;
    final int w1 = 25;

    ConditionPanel(MusicClient musicClient, final FiltersDialog filtersDialog, int n, int n2, String string, String string2) {
        super(new FlowLayout(0, 1, 1));
        Object object;
        Sorter sorter = new Sorter(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        };
        SortableVector sortableVector = new SortableVector();
        int n3 = 0;
        while (true) {
            if (n3 >= MusicClient.fields.length) break;
            if ((filtersDialog.filter != musicClient.addFilter || n3 == 9 || n3 == 23 || n3 == 7) && n3 != 24 && n3 != 27) {
                object = MusicClient.fields[n3];
                if (fieldUnits[n3].length() > 0) {
                    object = (String)object + " (" + fieldUnits[n3] + ")";
                }
                sortableVector.insert(sorter, object);
            }
            ++n3;
        }
        this.category = new JComboBox(sortableVector){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 200;
                return dimension;
            }
        };
        this.category.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConditionPanel.this.getCategoryIndex();
                String[] stringArray = new String[]{};
                switch (fieldTypes[n]) {
                    case 0: {
                        stringArray = stringTypeConditions;
                        break;
                    }
                    case 1: {
                        stringArray = numberTypeConditions;
                        break;
                    }
                    case 2: {
                        stringArray = dateTypeConditions;
                        break;
                    }
                    case 3: {
                        stringArray = filterTypeConditions;
                        break;
                    }
                    case 4: {
                        stringArray = boolTypeConditions;
                    }
                }
                ConditionPanel.this.condition.removeAllItems();
                for (int i = 0; i < stringArray.length; ++i) {
                    ConditionPanel.this.condition.addItem(stringArray[i]);
                }
                ConditionPanel.this.condition.setSelectedIndex(0);
            }
        });
        Object[] objectArray = new String[]{};
        switch (fieldTypes[n]) {
            case 0: {
                objectArray = stringTypeConditions;
                break;
            }
            case 1: {
                objectArray = numberTypeConditions;
                break;
            }
            case 2: {
                objectArray = dateTypeConditions;
                break;
            }
            case 3: {
                objectArray = filterTypeConditions;
                break;
            }
            case 4: {
                objectArray = boolTypeConditions;
            }
        }
        this.condition = new JComboBox(objectArray){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 200;
                return dimension;
            }
        };
        this.condition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConditionPanel.this.getCategoryIndex();
                int n2 = ConditionPanel.this.condition.getSelectedIndex();
                ConditionPanel.this.values.invalidate();
                ConditionPanel.this.text1.invalidate();
                boolean bl = ConditionPanel.this.disable(n, n2);
                ConditionPanel.this.text1.setEnabled(!bl);
                if (bl) {
                    ConditionPanel.this.text1.setText("");
                }
                ConditionPanel.this.values.removeAll();
                if (fieldTypes[n] == 3) {
                    ConditionPanel.this.values.add(ConditionPanel.this.combo);
                } else {
                    ConditionPanel.this.values.add(ConditionPanel.this.text1);
                    if (ConditionPanel.this.isRange(n, n2)) {
                        ConditionPanel.this.values.add(ConditionPanel.this.to);
                        ConditionPanel.this.values.add(ConditionPanel.this.text2);
                    }
                }
                ConditionPanel.this.values.revalidate();
                ConditionPanel.this.values.repaint();
            }
        });
        this.values = new JPanel(new FlowLayout(0, 1, 1));
        this.text1 = new JTextField(string){

            public Dimension getPreferredSize() {
                int n = ConditionPanel.this.getCategoryIndex();
                int n2 = ConditionPanel.this.condition.getSelectedIndex();
                Dimension dimension = super.getPreferredSize();
                dimension.width = ConditionPanel.this.isRange(n, n2) ? 100 : 227;
                return dimension;
            }

            public Color getBackground() {
                if (this.isEnabled()) {
                    return super.getBackground();
                }
                return SystemColor.control;
            }
        };
        this.to = new JLabel(iTo){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 25;
                return dimension;
            }
        };
        this.to.setHorizontalAlignment(0);
        this.text2 = new JTextField(string2){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 100;
                return dimension;
            }
        };
        object = musicClient.getFilters();
        Iterator iterator = ((Vector)object).iterator();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            vector.add(((SongFilter)iterator.next()).getName());
        }
        this.combo = new JComboBox(vector){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 227;
                return dimension;
            }
        };
        this.remove = new JButton(iRemove);
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                filtersDialog.removeCondition(ConditionPanel.this);
            }
        });
        this.add(this.category);
        this.add(this.condition);
        this.add(this.values);
        this.add(this.remove);
        this.setCategoryIndex(n);
        this.condition.setSelectedIndex(n2);
        if (fieldTypes[n] == 3) {
            this.combo.setSelectedItem(string);
        }
    }

    boolean isRange(int n, int n2) {
        int n3 = fieldTypes[n];
        return n3 == 1 && n2 == 4 || n3 == 2 && n2 == 6;
    }

    boolean disable(int n, int n2) {
        int n3 = fieldTypes[n];
        return n3 == 0 && n2 == 6 || n3 == 1 && n2 == 5 || n3 == 4;
    }

    int getCategoryIndex() {
        String string = (String)this.category.getSelectedItem();
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < MusicClient.fields.length; ++i) {
            if (!string.startsWith(MusicClient.fields[i])) continue;
            return i;
        }
        return -1;
    }

    void setCategoryIndex(int n) {
        boolean bl = false;
        block0: do {
            String string = MusicClient.fields[n];
            for (int i = 0; i < this.category.getItemCount(); ++i) {
                String string2 = (String)this.category.getItemAt(i);
                if (!string2.startsWith(string)) continue;
                this.category.setSelectedIndex(i);
                bl = true;
                continue block0;
            }
        } while (!bl && !bl && ++n < MusicClient.fields.length);
    }
}

