/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.util.Iterator;
import java.util.Vector;
import music.cpp.client.Album;
import music.cpp.client.Artist;
import music.cpp.client.GenreInfo;
import music.cpp.client.ListGenerator;
import music.cpp.client.MusicClient;
import music.cpp.client.Song;
import music.cpp.client.SortableVector;
import music.cpp.client.Sorter;
import music.cpp.client.StringUtil;

public class ByArtist
implements ListGenerator {
    static final String iSongsByMultipleArtists = MusicClient.STRINGS.get("IDSTR_PLAYLIST_BY_ARTISTS");
    Vector artists;
    Vector all;

    ByArtist(Vector vector) {
        this.artists = vector;
        this.all = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.all.add(vector.elementAt(i));
        }
    }

    public Vector getAlbums(MusicClient musicClient) {
        Artist[] artistArray = new Artist[this.artists.size()];
        for (int i = 0; i < artistArray.length; ++i) {
            artistArray[i] = (Artist)this.artists.elementAt(i);
        }
        return musicClient.getAlbums(artistArray, true);
    }

    public Vector getSongs(MusicClient musicClient) {
        SortableVector sortableVector = new SortableVector();
        Sorter sorter = new Sorter(){

            public int compare(Object object, Object object2) {
                Song song = (Song)object;
                Song song2 = (Song)object2;
                int n = StringUtil.compareToIgnorePunctuation(song.name(), song2.name());
                if (n == 0 && song.album() == song2.album()) {
                    return song.track() - song2.track();
                }
                return n;
            }
        };
        for (int i = 0; i < this.artists.size(); ++i) {
            Vector vector = musicClient.getSongs((Artist)this.artists.elementAt(i), true);
            if (vector == null) continue;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Song song = (Song)iterator.next();
                sortableVector.insertUnique(sorter, song);
            }
        }
        return sortableVector;
    }

    public boolean showTracks() {
        return true;
    }

    public String getTitle(MusicClient musicClient) {
        return this.artists.size() == 1 ? MusicClient.STRINGS.expand("IDSTR_PLAYLIST_BY_ARTIST", new String[]{this.artists.elementAt(0).toString()}) : iSongsByMultipleArtists;
    }

    public boolean isFixed() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(MusicClient.STRINGS.expand("IDSTR_PLAYLIST_BY_ARTIST", new String[]{""}));
        for (int i = 0; i < this.artists.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.artists.elementAt(i).toString());
        }
        return stringBuffer.toString();
    }

    public void removeArtist(Artist artist) {
        Iterator iterator = this.artists.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(artist)) continue;
            iterator.remove();
            break;
        }
        iterator = this.all.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(artist)) continue;
            iterator.remove();
            break;
        }
    }

    public void removeGenre(GenreInfo genreInfo) {
    }

    public void removeSong(Song song) {
    }

    public void removeAlbum(Album album) {
    }
}

