/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import music.cpp.client.AutoTagsTableRow;
import music.cpp.client.AutoTagsTableSorter;
import music.cpp.client.DecoratedSortableTableHeader;
import music.cpp.client.Engine;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeEngine;
import music.cpp.client.PlatinumBorder;
import music.cpp.client.Skin;
import music.cpp.client.Song;
import music.cpp.client.SongLoadingProgress;
import music.cpp.client.SortableVector;
import music.cpp.client.StringUtil;
import music.cpp.client.TagEditor;
import music.cpp.client.WebBrowser;

public class AutomaticTagsDialog
extends JDialog {
    static final int FIX_TAGS = 0;
    static final int RENAME_FILES = 1;
    static final String iApplyPattern = MusicClient.STRINGS.get("IDSTR_APPLY_PATTERN");
    static final String iTESelectAll = MusicClient.STRINGS.get("IDSTR_TE_SELECT_ALL");
    static final String iTEClearAll = MusicClient.STRINGS.get("IDSTR_TE_CLEAR_ALL");
    static final String iRenameReorganize = MusicClient.STRINGS.get("IDSTR_J_RENAME_REORGANIZE");
    static final String iPattern = MusicClient.STRINGS.get("IDSTR_PATTERN");
    static final String iSource = MusicClient.STRINGS.get("IDSTR_SOURCE");
    static final String iCopyFiles = MusicClient.STRINGS.get("IDSTR_COPY_FILES");
    static final String iMoveFiles = MusicClient.STRINGS.get("IDSTR_MOVE_FILES");
    static final String iATApply = MusicClient.STRINGS.get("IDSTR_AT_APPLY");
    static final String iATFile = MusicClient.STRINGS.get("IDSTR_AT_FILE");
    static final String iATField = MusicClient.STRINGS.get("IDSTR_AT_FIELD");
    static final String iATOldValue = MusicClient.STRINGS.get("IDSTR_AT_OLD_VALUE");
    static final String iATNewValue = MusicClient.STRINGS.get("IDSTR_AT_NEW_VALUE");
    static final String iATNoChangesRecommended = MusicClient.STRINGS.get("IDSTR_NO_CHANGES_RECOMMENDED");
    static final String iAT1Change1Song = MusicClient.STRINGS.get("IDSTR_AT_1CHANGE1SONG");
    static final String iATOldFile = MusicClient.STRINGS.get("IDSTR_AT_OLD_FILE");
    static final String iATNewFile = MusicClient.STRINGS.get("IDSTR_AT_NEW_FILE");
    static final String iRemoveEmptyDirectories = MusicClient.STRINGS.get("IDSTR_REMOVE_EMPTY_DIRECTORIES");
    static final String iUnableToCopy = MusicClient.STRINGS.get("IDSTR_UNABLE_TO_COPY");
    static final String iUnableToMove = MusicClient.STRINGS.get("IDSTR_UNABLE_TO_MOVE");
    static final String iMsgSpecifyFullPath = MusicClient.STRINGS.get("IDSTR_SPECIFY_FULL_PATH");
    static final String iMsgInvalidPattern = MusicClient.STRINGS.get("IDSTR_INVALID_PATTERN");
    static final String iMsgInvalidSourcePattern = MusicClient.STRINGS.get("IDSTR_INVALID_SOURCE_PATTERN");
    static final String iIgnoreCase = MusicClient.STRINGS.get("IDSTR_IGNORE_CASE");
    static final String iIgnoreWhitespace = MusicClient.STRINGS.get("IDSTR_IGNORE_WHITESPACE");
    static final String iATSameFile = MusicClient.STRINGS.get("IDSTR_AT_SAME_FILE");
    static final String iCopying = MusicClient.STRINGS.get("IDSTR_TE_COPYING");
    static final String iRenaming = MusicClient.STRINGS.get("IDSTR_TE_RENAMING");
    static final String iMoving = MusicClient.STRINGS.get("IDSTR_TE_MOVING");
    static final String iTEHelp = MusicClient.STRINGS.get("IDSTR_TE_HELP");
    static final String iMsgFileTooLong = MusicClient.STRINGS.get("IDSTR_FILE_TOO_LONG");
    static final int maxPatterns = 5;
    static Vector patterns = new Vector();
    static Vector srcPatterns = new Vector();
    static Vector renamePatterns = new Vector();
    static boolean showSrcPattern = false;
    static boolean doCopy = true;
    static boolean doRemoveDirs = true;
    static boolean doIgnoreCase = false;
    static boolean doIgnoreWhitespace = false;
    boolean rename = false;
    Window parent;
    MusicClient client;
    Vector songs;
    int mode;
    JPanel mainPanel;
    JPanel top;
    JComboBox srcPattern;
    JComboBox pattern;
    JCheckBox ignoreCase;
    JCheckBox ignoreWhitespace;
    JLabel status;
    Engine engine;
    JRadioButton copy;
    JRadioButton move;
    JCheckBox removeDirs;
    DefaultTableModel model;
    JTable table;
    DecoratedSortableTableHeader header;
    JScrollPane scrollPane;
    JButton applyPattern;
    JButton selectAll;
    JButton clearAll;
    JButton ok;
    JButton cancel;
    JButton apply;
    SortableVector rows = new SortableVector();
    boolean finishedApply = false;

    public AutomaticTagsDialog(MusicClient musicClient, JFrame jFrame, Engine engine, Vector vector, int n) {
        super(jFrame, n == 0 ? TagEditor.iTEAdvanced : iRenameReorganize, true);
        this.client = musicClient;
        this.parent = jFrame;
        this.engine = engine;
        this.songs = vector;
        this.mode = n;
        this.init();
    }

    public AutomaticTagsDialog(MusicClient musicClient, JDialog jDialog, Engine engine, Vector vector, int n) {
        super(jDialog, n == 0 ? TagEditor.iTEAdvanced : iRenameReorganize, true);
        this.client = musicClient;
        this.parent = jDialog;
        this.engine = engine;
        this.songs = vector;
        this.mode = n;
        this.init();
    }

    private void init() {
        Object object;
        Object[] objectArray;
        this.mainPanel = new JPanel(new BorderLayout());
        this.top = this.topPanel();
        this.mainPanel.add("North", this.top);
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return AutomaticTagsDialog.this.mode == 0 && n2 == 4 || AutomaticTagsDialog.this.mode == 1 && n2 == 1;
            }
        };
        this.table = new JTable(this.model){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = AutomaticTagsDialog.this.scrollPane.getWidth() - AutomaticTagsDialog.this.scrollPane.getVerticalScrollBar().getWidth();
                return dimension;
            }
        };
        this.table.setAutoResizeMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AutomaticTagsDialog.this.setButtons();
            }
        });
        this.table.setRowMargin(1);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popup(mouseEvent);
                } else if (AutomaticTagsDialog.this.mode == 0) {
                    int n = AutomaticTagsDialog.this.table.columnAtPoint(mouseEvent.getPoint());
                    if (n == 0) {
                        JCheckBox jCheckBox;
                        int n2 = AutomaticTagsDialog.this.table.rowAtPoint(mouseEvent.getPoint());
                        jCheckBox.setSelected(!(jCheckBox = ((AutoTagsTableRow)AutomaticTagsDialog.this.rows.elementAt((int)n2)).cb).isSelected());
                    }
                    AutomaticTagsDialog.this.setButtons();
                    AutomaticTagsDialog.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.popup(mouseEvent);
                }
            }

            void popup(MouseEvent mouseEvent) {
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int[] nArray = AutomaticTagsDialog.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        if (AutomaticTagsDialog.this.mode != 0) break;
                        for (int i = 0; i < AutomaticTagsDialog.this.rows.size(); ++i) {
                            JCheckBox jCheckBox;
                            if (!AutomaticTagsDialog.this.table.isRowSelected(i)) continue;
                            jCheckBox.setSelected(!(jCheckBox = ((AutoTagsTableRow)AutomaticTagsDialog.this.rows.elementAt((int)i)).cb).isSelected());
                        }
                        break;
                    }
                    case 127: {
                        for (int i = AutomaticTagsDialog.this.rows.size() - 1; i >= 0; --i) {
                            if (!AutomaticTagsDialog.this.table.isRowSelected(i)) continue;
                            AutomaticTagsDialog.this.rows.removeElementAt(i);
                        }
                        AutomaticTagsDialog.this.model.setRowCount(0);
                        Iterator iterator = AutomaticTagsDialog.this.rows.iterator();
                        while (iterator.hasNext()) {
                            AutoTagsTableRow autoTagsTableRow = (AutoTagsTableRow)iterator.next();
                            AutomaticTagsDialog.this.model.addRow(autoTagsTableRow.getRow(AutomaticTagsDialog.this.mode));
                        }
                        break;
                    }
                }
                AutomaticTagsDialog.this.updateTopPanel();
            }
        });
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n >= 0 && AutomaticTagsDialog.this.mode == 0 && n2 == 0) {
                    JCheckBox jCheckBox = ((AutoTagsTableRow)AutomaticTagsDialog.this.rows.elementAt((int)n)).cb;
                    jCheckBox.setForeground(Skin.getSkin().listTextColor);
                    jCheckBox.setBackground(bl ? Skin.getSkin().listSelColor : Skin.getSkin().listColor);
                    jCheckBox.setOpaque(true);
                    return jCheckBox;
                }
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setText(object == null ? "" : object.toString());
                if (n >= 0) {
                    jLabel.setHorizontalAlignment(2);
                    jLabel.setForeground(Skin.getSkin().listTextColor);
                    jLabel.setBackground(bl ? Skin.getSkin().listSelColor : Skin.getSkin().listColor);
                    jLabel.setOpaque(true);
                    return jLabel;
                }
                jLabel.setForeground(Skin.getSkin().listTextColor);
                jLabel.setHorizontalAlignment(0);
                jLabel.setOpaque(false);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setOpaque(false);
                jPanel.add((Component)jLabel, "Center");
                if (AutomaticTagsDialog.this.header.getSelectedColumn() == n2) {
                    jPanel.add(AutomaticTagsDialog.this.header.getDecoration(), "East");
                }
                jPanel.setBorder(new PlatinumBorder(6));
                return jPanel;
            }
        };
        this.header = new DecoratedSortableTableHeader(){

            protected void sortBy() {
                AutoTagsTableSorter autoTagsTableSorter = new AutoTagsTableSorter(this.selectedColumn, this.reversed, AutomaticTagsDialog.this.mode);
                AutomaticTagsDialog.this.rows.mergesort(autoTagsTableSorter);
                AutomaticTagsDialog.this.model.setRowCount(0);
                Iterator iterator = AutomaticTagsDialog.this.rows.iterator();
                while (iterator.hasNext()) {
                    AutoTagsTableRow autoTagsTableRow = (AutoTagsTableRow)iterator.next();
                    AutomaticTagsDialog.this.model.addRow(autoTagsTableRow.getRow(AutomaticTagsDialog.this.mode));
                }
                this.repaint();
            }
        };
        this.table.setTableHeader(this.header);
        this.header.setColumnModel(this.table.getColumnModel());
        this.header.setReorderingAllowed(false);
        if (this.mode == 0) {
            String[] stringArray = new String[5];
            stringArray[0] = iATApply;
            stringArray[1] = iATFile;
            stringArray[2] = iATField;
            stringArray[3] = iATOldValue;
            objectArray = stringArray;
            stringArray[4] = iATNewValue;
        } else {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = iATOldFile;
            objectArray = objectArray2;
            objectArray2[1] = iATNewFile;
        }
        this.model.setColumnIdentifiers(objectArray);
        if (this.mode == 1) {
            Iterator iterator = this.songs.iterator();
            while (iterator.hasNext()) {
                object = (Song)iterator.next();
                this.rows.add(new AutoTagsTableRow(object.mp3().getAbsolutePath()));
            }
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            object = this.table.getColumnModel().getColumn(i);
            if (i == 0 && this.mode == 0) {
                ((TableColumn)object).setMinWidth(50);
                ((TableColumn)object).setMaxWidth(50);
            }
            ((TableColumn)object).setCellRenderer(defaultTableCellRenderer);
            ((TableColumn)object).setHeaderRenderer(defaultTableCellRenderer);
        }
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            this.model.addRow(((AutoTagsTableRow)iterator.next()).getRow(this.mode));
        }
        this.scrollPane = new JScrollPane(this.table){

            public Dimension getPreferredSize() {
                return new Dimension(800, 300);
            }
        };
        this.mainPanel.add("Center", this.scrollPane);
        object = new JPanel();
        if (this.mode == 0) {
            this.selectAll = new JButton(iTESelectAll);
            this.selectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AutomaticTagsDialog.this.selectAll();
                }
            });
            ((Container)object).add(this.selectAll);
            this.clearAll = new JButton(iTEClearAll);
            this.clearAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AutomaticTagsDialog.this.clearAll();
                }
            });
            ((Container)object).add(this.clearAll);
            ((Container)object).add(new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(100, 1);
                }
            });
        }
        this.ok = new JButton(MusicClient.iOK);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AutomaticTagsDialog.this.apply()) {
                    AutomaticTagsDialog.this.setVisible(false);
                }
            }
        });
        ((Container)object).add(this.ok);
        this.cancel = new JButton(MusicClient.iCancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutomaticTagsDialog.this.setVisible(false);
            }
        });
        ((Container)object).add(this.cancel);
        if (this.mode == 0) {
            this.apply = new JButton(TagEditor.iApply);
            this.apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AutomaticTagsDialog.this.apply();
                }
            });
            ((Container)object).add(this.apply);
        }
        JButton jButton = new JButton(iTEHelp);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "http://mixer.musicip.com/" + (AutomaticTagsDialog.this.mode == 0 ? "tagfixing" : "organize");
                if (!WebBrowser.browse(string)) {
                    MusicClient cfr_ignored_0 = AutomaticTagsDialog.this.client;
                    AutomaticTagsDialog.this.client.showMessage(MusicClient.cannotBrowse(string));
                }
            }
        });
        ((Container)object).add(jButton);
        this.mainPanel.add("South", (Component)object);
        this.setButtons();
        this.getContentPane().add(this.mainPanel);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = AutomaticTagsDialog.this.scrollPane.getWidth() - AutomaticTagsDialog.this.scrollPane.getVerticalScrollBar().getWidth();
                int n2 = AutomaticTagsDialog.this.table.getColumnCount();
                if (AutomaticTagsDialog.this.mode == 0) {
                    for (int i = 1; i < n2; ++i) {
                        AutomaticTagsDialog.this.table.getColumnModel().getColumn(i).setPreferredWidth((n - 50) / (n2 - 1));
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        AutomaticTagsDialog.this.table.getColumnModel().getColumn(i).setPreferredWidth(n / n2);
                    }
                }
                AutomaticTagsDialog.this.table.updateUI();
                if (AutomaticTagsDialog.this.mode == 1 && AutomaticTagsDialog.this.pattern.getItemCount() > 0) {
                    AutomaticTagsDialog.this.applyPattern();
                }
            }
        });
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }

    private JPanel topPanel() {
        JComponent jComponent;
        JComponent jComponent2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (this.mode == 0) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            jComponent2 = new JComponent(){

                public void paint(Graphics graphics) {
                    graphics.setColor(Color.black);
                    if (showSrcPattern) {
                        graphics.fillRect(6, 5, 1, 7);
                        graphics.fillRect(7, 6, 1, 5);
                        graphics.fillRect(8, 7, 1, 3);
                        graphics.fillRect(9, 8, 1, 1);
                    } else {
                        graphics.fillRect(9, 5, 1, 7);
                        graphics.fillRect(8, 6, 1, 5);
                        graphics.fillRect(7, 7, 1, 3);
                        graphics.fillRect(6, 8, 1, 1);
                    }
                }

                public Dimension getPreferredSize() {
                    return new Dimension(16, 17);
                }
            };
            jComponent2.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    showSrcPattern = !showSrcPattern;
                    AutomaticTagsDialog.this.updateTopPanel();
                }
            });
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jPanel.add(jComponent2);
            if (showSrcPattern) {
                ++gridBagConstraints.gridx;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                jComponent = new JLabel(iSource);
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                jPanel.add(jComponent);
                ++gridBagConstraints.gridx;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.srcPattern = new JComboBox(srcPatterns);
                this.srcPattern.setEditable(true);
                gridBagLayout.setConstraints(this.srcPattern, gridBagConstraints);
                jPanel.add(this.srcPattern);
                if (srcPatterns.size() > 0) {
                    this.srcPattern.setSelectedIndex(0);
                }
            }
            ++gridBagConstraints.gridx;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jComponent2 = new JLabel(iPattern);
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = this.mode == 0 ? (showSrcPattern ? 1 : 3) : 4;
        this.pattern = new JComboBox(this.mode == 0 ? patterns : renamePatterns);
        this.pattern.setEditable(true);
        gridBagLayout.setConstraints(this.pattern, gridBagConstraints);
        jPanel.add(this.pattern);
        if (this.pattern.getItemCount() > 0) {
            this.pattern.setSelectedIndex(0);
        }
        gridBagConstraints.gridx = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.applyPattern = new JButton(iApplyPattern);
        gridBagLayout.setConstraints(this.applyPattern, gridBagConstraints);
        this.applyPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutomaticTagsDialog.this.applyPattern();
            }
        });
        gridBagLayout.setConstraints(this.applyPattern, gridBagConstraints);
        jPanel.add(this.applyPattern);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jComponent = new JPanel();
        if (this.mode == 0) {
            this.ignoreCase = new JCheckBox(iIgnoreCase, doIgnoreCase);
            jComponent.add(this.ignoreCase);
            this.ignoreWhitespace = new JCheckBox(iIgnoreWhitespace, doIgnoreWhitespace);
            jComponent.add(this.ignoreWhitespace);
        } else {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.copy = new JRadioButton(iCopyFiles, doCopy);
            jComponent.add(this.copy);
            buttonGroup.add(this.copy);
            this.move = new JRadioButton(iMoveFiles, !doCopy);
            jComponent.add(this.move);
            buttonGroup.add(this.move);
            jComponent.add(new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(50, 1);
                }
            });
            this.removeDirs = new JCheckBox(iRemoveEmptyDirectories, doRemoveDirs);
            jComponent.add(this.removeDirs);
        }
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        ++gridBagConstraints.gridy;
        jComponent = new JPanel();
        this.status = new JLabel("");
        jComponent.add(this.status);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        return jPanel;
    }

    private void updateTopPanel() {
        this.mainPanel.invalidate();
        this.mainPanel.remove(this.top);
        this.top = this.topPanel();
        this.mainPanel.add("North", this.top);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        this.setButtons();
        this.setStatus();
    }

    boolean isReady() {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            AutoTagsTableRow autoTagsTableRow = (AutoTagsTableRow)iterator.next();
            if (autoTagsTableRow.newValue == null || autoTagsTableRow.newValue.length() <= 0) continue;
            return true;
        }
        return false;
    }

    void setButtons() {
        boolean bl = this.isReady();
        if (this.mode == 0) {
            int n = 0;
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                AutoTagsTableRow autoTagsTableRow = (AutoTagsTableRow)iterator.next();
                if (!autoTagsTableRow.cb.isSelected()) continue;
                ++n;
            }
            this.selectAll.setEnabled(this.rows.size() > 0 && n < this.rows.size());
            this.clearAll.setEnabled(this.rows.size() > 0 && n > 0);
            this.apply.setEnabled(bl);
        }
        this.ok.setEnabled(bl);
    }

    void selectAll() {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            JCheckBox jCheckBox = ((AutoTagsTableRow)iterator.next()).cb;
            jCheckBox.setSelected(true);
        }
        this.setButtons();
        this.table.repaint();
    }

    void clearAll() {
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            JCheckBox jCheckBox = ((AutoTagsTableRow)iterator.next()).cb;
            jCheckBox.setSelected(false);
        }
        this.setButtons();
        this.table.repaint();
    }

    String addPattern(JComboBox jComboBox, Vector vector) {
        String string = (String)jComboBox.getSelectedItem();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (vector.contains(string)) {
            vector.remove(string);
        }
        vector.insertElementAt(string, 0);
        if (vector.size() > 5) {
            for (int i = vector.size() - 1; i >= 5; --i) {
                vector.remove(i);
            }
        }
        return string;
    }

    void applyPattern() {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        if (this.songs.size() == 0) {
            this.model.setRowCount(0);
            return;
        }
        String string = this.mode == 0 && showSrcPattern ? this.addPattern(this.srcPattern, srcPatterns) : null;
        String string2 = this.addPattern(this.pattern, this.mode == 0 ? patterns : renamePatterns);
        if (this.mode == 0 && showSrcPattern && string == null || string2 == null) {
            return;
        }
        if (NativeEngine.validatePattern(string2, ((Song)this.songs.elementAt(0)).getID()) < 0) {
            this.client.showMessage(iMsgInvalidPattern);
            return;
        }
        if (string != null && NativeEngine.validatePattern(string, ((Song)this.songs.elementAt(0)).getID()) < 0) {
            this.client.showMessage(iMsgInvalidSourcePattern);
            return;
        }
        if (this.mode == 1) {
            doCopy = this.copy.isSelected();
            doRemoveDirs = this.removeDirs.isSelected();
            if (!(string2.endsWith("%ext") || string2.endsWith("%f") || string2.endsWith("%file"))) {
                string2 = string2 + ".%ext";
            }
            if (MusicClient.isWindows()) {
                if (!string2.substring(1).startsWith(":\\")) {
                    if (string2.indexOf(File.separator) > 2) {
                        this.client.showMessage(iMsgSpecifyFullPath);
                        return;
                    }
                    this.rename = true;
                } else {
                    this.rename = false;
                }
            } else if (!string2.startsWith(File.separator)) {
                if (string2.indexOf(File.separator) >= 0) {
                    this.client.showMessage(iMsgSpecifyFullPath);
                    return;
                }
                this.rename = true;
            } else {
                this.rename = false;
            }
        }
        String string3 = null;
        this.rows.clear();
        if (this.mode == 0) {
            doIgnoreCase = this.ignoreCase.isSelected();
            doIgnoreWhitespace = this.ignoreWhitespace.isSelected();
            iterator = this.songs.iterator();
            while (iterator.hasNext()) {
                object3 = (Song)iterator.next();
                object2 = string == null ? this.client.getAutoFixSuggestionsByFile((Song)object3, string2, doIgnoreCase, doIgnoreWhitespace) : this.client.getAutoFixSuggestionsByPattern((Song)object3, string, string2, doIgnoreCase, doIgnoreWhitespace);
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    this.rows.add(object.next());
                }
            }
        } else {
            iterator = this.songs.iterator();
            while (iterator.hasNext()) {
                AutoTagsTableRow autoTagsTableRow;
                object3 = (Song)iterator.next();
                object2 = object3.mp3().getAbsolutePath();
                object = this.rename ? object3.mp3().getParent() + File.separator + string2 : string2;
                String string4 = ((NativeEngine)this.engine).fillInPattern((String)object, object3.getID(), true);
                if (string4 != null && string4.length() + 1 > NativeEngine.getMaxPath()) {
                    string3 = iMsgFileTooLong;
                    string4 = null;
                }
                if (string4 != null) {
                    autoTagsTableRow = new AutoTagsTableRow((String)object2);
                    autoTagsTableRow.newValue = string4;
                    if (((String)object2).equals(string4)) continue;
                    this.rows.add(autoTagsTableRow);
                    continue;
                }
                autoTagsTableRow = new AutoTagsTableRow((String)object2);
                this.rows.add(autoTagsTableRow);
            }
        }
        this.model.setRowCount(0);
        iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            object3 = (AutoTagsTableRow)iterator.next();
            this.model.addRow(((AutoTagsTableRow)object3).getRow(this.mode));
        }
        this.updateTopPanel();
        if (string3 != null) {
            this.client.showMessage(string3);
        }
    }

    void setStatus() {
        String string = "";
        if (this.mode == 0) {
            string = this.rows.size() == 1 ? (this.songs.size() == 1 ? iAT1Change1Song : MusicClient.STRINGS.expand("IDSTR_AT_1CHANGES1SONG", new String[]{StringUtil.l2ac(this.rows.size())})) : (this.rows.size() > 1 ? (this.songs.size() == 1 ? MusicClient.STRINGS.expand("IDSTR_AT_NCHANGES1SONG", new String[]{StringUtil.l2ac(this.rows.size())}) : MusicClient.STRINGS.expand("IDSTR_AT_NCHANGESNSONGS", new String[]{StringUtil.l2ac(this.rows.size()), StringUtil.l2ac(this.songs.size())})) : iATNoChangesRecommended);
        } else {
            int n = this.songs.size() - this.rows.size();
            if (n == 1) {
                string = iATSameFile;
            } else if (n > 1) {
                string = MusicClient.STRINGS.expand("IDSTR_AT_SAME_FILES", new String[]{StringUtil.l2ac(n)});
            }
        }
        this.status.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean apply() {
        String string;
        Iterator iterator;
        Song[] songArray;
        if (this.client.progress != null) {
            return false;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.finishedApply = false;
        new Thread(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 21 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        String string = 21.access$100(this.this$1).mode == 0 ? TagEditor.iSaving : (doCopy ? iCopying : (21.access$100(this.this$1).rename ? iRenaming : iMoving));
                        21.access$100(this.this$1).client.progress = new SongLoadingProgress(21.access$100(this.this$1).client, string, 0);
                        21.access$100(this.this$1).client.progress.internalTotal = 21.access$100(this.this$1).rows.size();
                        if (21.access$100(this.this$1).finishedApply) {
                            21.access$100(this.this$1).client.progress.close();
                            21.access$100(this.this$1).client.progress = null;
                        } else {
                            21.access$100(this.this$1).client.progressInterrupted = false;
                            21.access$100(this.this$1).client.progress.setVisible(true);
                        }
                    }
                });
            }

            static /* synthetic */ AutomaticTagsDialog access$100(21 var0) {
                return var0.AutomaticTagsDialog.this;
            }
        }.start();
        try {
            vector = this.mode == 0 ? this.client.applyEdits(this.rows, vector2) : this.client.organizeFiles(this.rows, doCopy, doRemoveDirs, vector2);
            this.finishedApply = true;
        }
        catch (Throwable throwable) {
            this.finishedApply = true;
            new Thread(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (23.access$200(this.this$1).client.progress != null) {
                                23.access$200(this.this$1).client.progress.close();
                                23.access$200(this.this$1).client.progress = null;
                            }
                        }
                    });
                }

                static /* synthetic */ AutomaticTagsDialog access$200(23 var0) {
                    return var0.AutomaticTagsDialog.this;
                }
            }.start();
            throw throwable;
        }
        new /* invalid duplicate definition of identical inner class */.start();
        if (vector2.size() > 0) {
            songArray = new StringBuffer();
            iterator = vector2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                songArray.append(string + "\n");
            }
            this.client.showMessage(TagEditor.iTEErrorWriting + "\n" + songArray.toString());
        }
        if (vector != null && vector.size() > 0) {
            songArray = new Song[vector.size()];
            for (int i = 0; i < songArray.length; ++i) {
                songArray[i] = (Song)vector.elementAt(i);
            }
            this.client.refresh(songArray);
            if (this.mode == 0 && this.parent instanceof TagEditor) {
                ((TagEditor)this.parent).refresh(vector);
            }
        }
        if (this.mode == 1 && vector2.size() > 0) {
            songArray = new Vector();
            iterator = vector2.iterator();
            block4: while (iterator.hasNext()) {
                string = (String)iterator.next();
                Iterator iterator2 = this.songs.iterator();
                while (iterator2.hasNext()) {
                    Song song = (Song)iterator2.next();
                    if (!string.equals(song.mp3().getAbsolutePath())) continue;
                    songArray.add(song);
                    continue block4;
                }
            }
            this.songs = songArray;
            this.applyPattern();
            return false;
        }
        if (this.mode == 0) {
            this.applyPattern();
        }
        return true;
    }
}

