/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import music.cpp.client.ClipboardUtil;
import music.cpp.client.DialogUtil;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.Status;
import music.cpp.client.StringUtil;
import music.cpp.client.WebBrowser;

public class AboutDialog
extends JDialog {
    static final String iAbout3 = MusicClient.STRINGS.get("IDSTR_ABOUT3");
    static final String iAbout4 = MusicClient.STRINGS.get("IDSTR_ABOUT4");
    static final String iAbout5 = MusicClient.STRINGS.get("IDSTR_ABOUT5");
    static final String iAbout6 = MusicClient.STRINGS.get("IDSTR_ABOUT6");
    static final String iAbout7 = MusicClient.STRINGS.get("IDSTR_ABOUT7");
    static final String iAbout8 = MusicClient.STRINGS.get("IDSTR_ABOUT8");
    static final String iNeedsVerification = MusicClient.STRINGS.get("IDSTR_NEEDS_VERIFICATION");
    static final String iUnavailable = MusicClient.STRINGS.get("IDSTR_UNAVAILABLE");
    static final String iUnlimited = MusicClient.STRINGS.get("IDSTR_UNLIMITED");
    static final String iInvalid = MusicClient.STRINGS.get("IDSTR_INVALID");
    static final String iBuy = MusicClient.STRINGS.get("IDSTR_BUY");
    static long BUILD_DATE = 1184957685L;
    static final String VERSION = MusicClient.STRINGS.expand("IDSTR_ABOUT1", new String[]{"1.8"}) + MusicClient.STRINGS.expand("IDSTR_BUILD_DATE", new String[]{MusicClient.fmt.format(new Date(1000L * BUILD_DATE))});
    JButton ok;
    JButton buy;
    MusicClient client;
    boolean testKey = false;

    public AboutDialog(MusicClient musicClient) {
        super(musicClient, "", true);
        Object object;
        this.client = musicClient;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.client.enableMenus(true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(30, 0));
        jPanel.add("West", new JPanel(){

            public boolean isOpaque() {
                return false;
            }
        });
        jPanel.add("East", new JPanel(){

            public boolean isOpaque() {
                return false;
            }
        });
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.createLabel(VERSION, true));
        jPanel2.add(this.createLabel(MusicClient.STRINGS.expand("IDSTR_ABOUT2", new String[]{"2005"})));
        jPanel2.add(new Label2(" "));
        jPanel2.add(this.createLabel(new String[]{iAbout3}, "mailto:support@musicip.com", 0, false));
        jPanel2.add(this.createLabel(new String[]{iAbout4}, "http://www.musicip.com/", 0, false));
        jPanel2.add(new Label2(" "));
        Status status = this.client.getStatus();
        jPanel2.add(this.createLabel(iAbout5 + StringUtil.l2ac(status.getTotal())));
        int n = status.getVerify();
        jPanel2.add(this.createLabel(iAbout6 + StringUtil.l2ac(status.getHasData()) + (n == 0 ? "" : (n == 1 ? iNeedsVerification : MusicClient.STRINGS.expand("IDSTR_NEED_VERIFICATION", new String[]{StringUtil.l2ac(n)})))));
        jPanel2.add(this.createLabel(iAbout7 + StringUtil.l2ac(status.getDead())));
        jPanel2.add(new Label2(" "));
        if (this.client.getKey() != null && this.client.getKey().trim().length() > 0) {
            jPanel2.add(this.createLabel(iAbout8 + this.client.getKey(), true));
            object = this.client.expiration > 10L ? (this.client.active ? (this.client.expiration == 100L ? iUnlimited : MusicClient.STRINGS.expand("IDSTR_RANGE", new String[]{MusicClient.fmt.format(new Date(this.client.expiration * 1000L))})) : MusicClient.STRINGS.expand("IDSTR_EXPIRED", new String[]{MusicClient.fmt.format(new Date(this.client.expiration * 1000L))})) : iInvalid;
            jPanel2.add(this.createLabel((String)object));
        }
        jPanel.add("Center", jPanel2);
        object = new JPanel();
        ((JComponent)object).setOpaque(false);
        this.ok = new JButton(MusicClient.iOK);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.client.enableMenus(true);
            }
        });
        ((Container)object).add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.buy = new JButton(iBuy);
        this.buy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer("http://mixer.musicip.com/purchase");
                if (AboutDialog.this.client.getKey() != null) {
                    stringBuffer.append("?reg_key=" + AboutDialog.this.client.getKey());
                }
                if (!WebBrowser.browse(stringBuffer.toString())) {
                    AboutDialog.this.client.showMessage(MusicClient.cannotBrowse(stringBuffer.toString()));
                }
                AboutDialog.this.testKey = true;
            }
        });
        if (this.client.showBuyButton()) {
            ((Container)object).add(this.buy);
        }
        jPanel.add("South", (Component)object);
        this.getContentPane().add(jPanel);
        this.pack();
        DialogUtil.centerDialog(this.client, this);
        this.setResizable(false);
        this.setVisible(true);
    }

    JPanel createLabel(String string) {
        return this.createLabel(new String[]{string}, null, -1, false);
    }

    JPanel createLabel(String string, boolean bl) {
        return this.createLabel(new String[]{string}, null, -1, bl);
    }

    JPanel createLabel(String[] stringArray, final String string, int n, boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 0));
        jPanel.setOpaque(false);
        for (int i = 0; i < stringArray.length; ++i) {
            JComponent jComponent;
            if (bl) {
                jComponent = new JTextField(" " + stringArray[i] + " "){

                    protected void paintComponent(Graphics graphics) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        super.paintComponent(graphics);
                    }
                };
                jComponent.addMouseListener(new MouseAdapter((JTextField)jComponent){
                    private final /* synthetic */ JTextField val$f;
                    {
                        this.val$f = jTextField;
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        this.val$f.setCursor(Cursor.getPredefinedCursor(2));
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        this.val$f.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
                ((JTextComponent)jComponent).setEditable(false);
                jComponent.setOpaque(false);
                jComponent.setBorder(null);
                ClipboardUtil.addMenu((JTextComponent)jComponent);
                jPanel.add(jComponent);
                continue;
            }
            jComponent = new Label2(stringArray[i]);
            if (string != null && i == n) {
                jComponent.setForeground(Color.blue);
                jComponent.addMouseListener(new MouseAdapter((Label2)jComponent){
                    private final /* synthetic */ Label2 val$l;
                    {
                        this.val$l = label2;
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (string.startsWith("mailto:")) {
                            String string2 = AboutDialog.this.client.getKey() == null || AboutDialog.this.client.getKey().trim().length() == 0 ? "Linux Feedback" : "Linux Support for registration " + AboutDialog.this.client.getKey();
                            WebBrowser.mailto(string.substring(7), string2);
                        } else {
                            WebBrowser.browse(string);
                        }
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                        this.val$l.setCursor(Cursor.getPredefinedCursor(12));
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        this.val$l.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
            jPanel.add(jComponent);
        }
        return jPanel;
    }
}

