/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.logicdiagram;

import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagram;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ControlPanel
extends JPanel
implements ActionListener {
    private LogicDiagram logicDiagram;
    private Peripheral[] peripherals;
    private JCheckBox[] peripheralCheckboxes;
    private JButton selectAllButton = new JButton("Select All");
    private JButton deselectAllButton = new JButton("Deselect All");

    ControlPanel(LogicDiagram logicDiagram) {
        GridBagConstraints gbc;
        this.logicDiagram = logicDiagram;
        this.peripherals = logicDiagram.getPeripherals();
        this.peripheralCheckboxes = new JCheckBox[this.peripherals.length];
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 3, 0);
        int i = 0;
        while (i < this.peripheralCheckboxes.length) {
            this.peripheralCheckboxes[i] = new JCheckBox();
            this.peripheralCheckboxes[i].setSelected(true);
            this.peripheralCheckboxes[i].addActionListener(this);
            JPanel checkBoxPanel = new JPanel();
            checkBoxPanel.setBackground(Color.WHITE);
            checkBoxPanel.add(this.peripheralCheckboxes[i]);
            checkBoxPanel.add(this.getCheckBoxPanel(this.peripheralCheckboxes[i], this.peripherals[i].getName()));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i++;
            gbc.insets = insets;
            this.add((Component)checkBoxPanel, gbc);
        }
        this.selectAllButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this.peripherals.length;
        gbc.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.selectAllButton, gbc);
        this.deselectAllButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this.peripherals.length + 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.deselectAllButton, gbc);
    }

    private JPanel getCheckBoxPanel(JCheckBox checkBox, String name) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)checkBox, gbc);
        String[] names = this.splitName(name);
        for (int i = 0; i < names.length; ++i) {
            gbc.gridy = i + 1;
            panel.add((Component)new JLabel(names[i]), gbc);
        }
        return panel;
    }

    private String[] splitName(String name) {
        StringTokenizer st = new StringTokenizer(name, "^");
        String[] ss = new String[st.countTokens()];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = st.nextToken();
        }
        return ss;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.selectAllButton) {
            this.logicDiagram.enableAll(true);
            for (int i = 0; i < this.peripheralCheckboxes.length; ++i) {
                this.peripheralCheckboxes[i].setSelected(true);
            }
        } else if (event.getSource() == this.deselectAllButton) {
            this.logicDiagram.enableAll(false);
            for (int i = 0; i < this.peripheralCheckboxes.length; ++i) {
                this.peripheralCheckboxes[i].setSelected(false);
            }
        } else {
            for (int i = 0; i < this.peripheralCheckboxes.length; ++i) {
                if (event.getSource() != this.peripheralCheckboxes[i]) continue;
                this.logicDiagram.enable(this.peripheralCheckboxes[i].isSelected(), i);
            }
        }
        this.logicDiagram.refresh();
    }
}

