/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.KeypadGraphics;
import edsim51di.Mapping;
import edsim51di.Peripheral;
import edsim51di.UartGraphics;
import edsim51di.logicdiagram.LogicDiagramInterface;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextArea;

class Uart
extends Peripheral {
    private double TX = 3.0;
    private double RX = 3.1;
    private int txPort;
    private int txPin;
    private int rxPort;
    private int rxPin;
    private int baud;
    private int bitRateInMachineCycles;
    private int rxData = 0;
    private boolean receiving = false;
    private int rxLine = 1;
    private int prevRxLine = 1;
    private int rxBit = 0;
    private int rxClock;
    private int txData = 0;
    private int txLine = 1;
    private int txBit = -1;
    private int txClock;
    private String dataToTx = "";
    private Vector hexData = null;
    private int parity;
    private Board board;
    private KeypadGraphics keypad;
    private UartGraphics uartGraphics;
    private JTextArea txDataField;
    private String txDataFieldString = "";
    private JTextArea rxDataField;
    private String rxDataFieldString = "";

    Uart(Board board, Gui gui, KeypadGraphics keypad) {
        super("Uart", false);
        String s;
        this.board = board;
        this.keypad = keypad;
        double[] d = board.getPortMapSetting("uart_tx");
        if (d != null) {
            this.TX = d[0];
        }
        if ((d = board.getPortMapSetting("uart_rx")) != null) {
            this.RX = d[0];
        }
        if ((s = board.getHardwareSetting("uart_baud")) == null) {
            this.setBaudRate(4800);
        } else {
            try {
                this.setBaudRate(Integer.parseInt(s));
            }
            catch (NumberFormatException ex) {
                this.setBaudRate(4800);
            }
        }
        s = board.getHardwareSetting("uart_parity");
        if (s == null) {
            this.parity = 0;
        } else {
            try {
                this.parity = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                this.parity = 0;
            }
        }
        this.txPort = this.getPortNumber(this.TX);
        this.txPin = this.getPinNumber(this.TX);
        this.rxPort = this.getPortNumber(this.RX);
        this.rxPin = this.getPinNumber(this.RX);
        this.uartGraphics = new UartGraphics(board, gui, this);
        this.txDataField = this.uartGraphics.getTxDataField();
        this.rxDataField = this.uartGraphics.getRxDataField();
        this.rxClock = this.bitRateInMachineCycles;
        this.txClock = this.bitRateInMachineCycles;
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[2];
        interfaces[0] = new LogicDiagramInterface();
        interfaces[0].peripheralPin = 12;
        interfaces[0].portNumber = this.rxPort;
        interfaces[0].pinNumber = this.rxPin;
        interfaces[1] = new LogicDiagramInterface();
        interfaces[1].peripheralPin = 30;
        interfaces[1].portNumber = this.txPort;
        interfaces[1].pinNumber = this.txPin;
        return interfaces;
    }

    Mapping getTxMapping() {
        return new Mapping(this.txPort, this.txPin, "Ext. UART Tx");
    }

    Mapping getRxMapping() {
        return new Mapping(this.rxPort, this.rxPin, "Ext. UART Rx");
    }

    UartGraphics getGraphics() {
        return this.uartGraphics;
    }

    void updatePortPins() {
        this.rxLine = this.board.readPortPin(this.rxPort, this.rxPin);
        if (this.txLine == 1) {
            this.board.setPortPin(this.txPort, this.txPin, 500);
            this.keypad.updateBitByExternalHardware(true, this.txPort, this.txPin);
        } else {
            this.board.clearPortPin(this.txPort, this.txPin, 500);
            this.keypad.updateBitByExternalHardware(false, this.txPort, this.txPin);
        }
        for (int i = 0; i < this.board.getInstructionCycles(); ++i) {
            this.pulseClock();
        }
    }

    void updateGraphics() {
        if (!this.txDataField.isEditable() && !this.txDataField.getText().equals(this.txDataFieldString)) {
            this.txDataField.setText(this.txDataFieldString);
        }
        if (!this.rxDataField.getText().equals(this.rxDataFieldString)) {
            this.rxDataField.setText(this.rxDataFieldString);
        }
    }

    void setBaudRate(int baud) {
        this.baud = baud;
        this.setBitRateInMachineCycles();
        this.rxClock = this.bitRateInMachineCycles;
        this.txClock = this.bitRateInMachineCycles;
        this.resetReceiver();
        this.resetTransmitter();
    }

    int getBaudRate() {
        return this.baud;
    }

    void setParity(int parity) {
        this.parity = parity;
    }

    void changeParity() {
        ++this.parity;
        if (this.parity == 3) {
            this.parity = 0;
        }
        this.resetReceiver();
        this.resetTransmitter();
    }

    boolean isEvenParity() {
        return this.parity == 2;
    }

    boolean isOddParity() {
        return this.parity == 1;
    }

    boolean isNoParity() {
        return this.parity == 0;
    }

    int getParity() {
        return this.parity;
    }

    void pulseClock() {
        --this.rxClock;
        if (this.rxClock <= 0) {
            this.rxClock = this.bitRateInMachineCycles;
            if (this.receiving) {
                this.receiveBit();
            } else if (this.prevRxLine == 1 && this.rxLine == 0) {
                this.receiving = true;
            }
            this.prevRxLine = this.rxLine;
        }
        --this.txClock;
        if (this.txClock <= 0) {
            this.txClock = this.bitRateInMachineCycles;
            if (this.dataToTx.length() > 0 || this.hexData != null) {
                this.transmitBit();
            }
        }
    }

    void resetReceiver() {
        this.receiving = false;
        this.rxBit = 0;
        this.rxLine = 1;
        this.prevRxLine = 1;
        this.rxDataFieldString = "";
    }

    void resetTransmitter() {
        this.dataToTx = "";
        this.hexData = null;
        this.txBit = -1;
        this.txLine = 1;
        this.txDataFieldString = "";
    }

    void startTransmission(String data) {
        this.dataToTx = data;
        this.txDataFieldString = data;
        if (this.isEscapedAscii(this.dataToTx)) {
            this.dataToTx = this.dataToTx.substring(1) + "\r";
        } else {
            this.hexData = this.txDataToHex(this.dataToTx);
            this.dataToTx = this.hexData == null ? this.dataToTx + "\r" : "";
        }
    }

    void setBitRateInMachineCycles() {
        this.bitRateInMachineCycles = (int)Math.round(1000000.0 / this.board.getCpuMachineCycleLength() / (double)this.baud);
    }

    private boolean isEscapedAscii(String data) {
        if (data.charAt(0) != '\\') {
            return false;
        }
        String s = data;
        while (s.length() > 0 && s.charAt(0) == '\\') {
            s = s.substring(1);
        }
        if (s.length() == 0) {
            return false;
        }
        Vector v = this.txDataToHex(s);
        return v != null;
    }

    private Vector txDataToHex(String data) {
        if (data.charAt(0) != '{' && data.charAt(data.length() - 1) != '}') {
            return null;
        }
        Vector<Integer> v = new Vector<Integer>();
        data = data.substring(1, data.length() - 1);
        StringTokenizer st = new StringTokenizer(data, ",");
        int count = st.countTokens();
        for (int i = 0; i < count; ++i) {
            try {
                String s = st.nextToken().trim();
                int h = Integer.parseInt(s, 16) & 0xFF;
                v.addElement(new Integer(h));
                continue;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return v;
    }

    private void receiveBit() {
        if (this.rxBit == 8) {
            this.rxBit = 0;
            if (this.isValidByte(this.rxData)) {
                this.rxDataFieldString = this.rxDataFieldString + String.valueOf((char)this.clearMsb(this.rxData));
            }
            this.rxData = 0;
            this.receiving = false;
        } else {
            this.rxData += this.rxLine << this.rxBit;
            ++this.rxBit;
        }
    }

    private void transmitBit() {
        if (this.hexData != null) {
            this.transmitHexBit();
        } else if (this.txBit == -1) {
            this.txLine = 0;
            ++this.txBit;
        } else if (this.txBit == 8) {
            this.txLine = 1;
            this.txBit = -1;
            this.dataToTx = this.dataToTx.length() > 1 ? this.dataToTx.substring(1) : "";
            this.txDataFieldString = this.dataToTx;
        } else {
            this.txData = this.dataToTx.charAt(0);
            this.txData = this.addParityBit(this.txData);
            this.txLine = this.txData >> this.txBit & 1;
            ++this.txBit;
        }
    }

    private void transmitHexBit() {
        if (this.txBit == -1) {
            this.txLine = 0;
            ++this.txBit;
        } else if (this.txBit == 8) {
            this.txLine = 1;
            this.txBit = -1;
            if (this.hexData.size() > 1) {
                this.hexData.removeElementAt(0);
                this.txDataFieldString = this.hexDataToString();
            } else {
                this.hexData = null;
                this.txDataFieldString = "";
            }
        } else {
            this.txData = (Integer)this.hexData.elementAt(0);
            this.txData = this.addParityBit(this.txData);
            this.txLine = this.txData >> this.txBit & 1;
            ++this.txBit;
        }
    }

    private String hexDataToString() {
        String s = "{";
        for (int i = 0; i < this.hexData.size(); ++i) {
            int h = (Integer)this.hexData.elementAt(i);
            s = s + Integer.toHexString(h);
            if (i == this.hexData.size() - 1) continue;
            s = s + ",";
        }
        return s + "}";
    }

    private boolean hasEvenNumberOfOnes(int data) {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            count += data >> i & 1;
        }
        return !(count & true);
    }

    private int addParityBit(int data) {
        if (this.parity == 0) {
            return data;
        }
        if (this.parity == 1) {
            if (this.hasEvenNumberOfOnes(data)) {
                data |= 0x80;
            }
            return data;
        }
        if (!this.hasEvenNumberOfOnes(data)) {
            data |= 0x80;
        }
        return data;
    }

    private boolean isValidByte(int data) {
        if (this.parity == 0) {
            return true;
        }
        if (this.parity == 1) {
            return !this.hasEvenNumberOfOnes(data);
        }
        return this.hasEvenNumberOfOnes(data);
    }

    private int clearMsb(int data) {
        if (this.parity == 0) {
            return data;
        }
        return data & 0xFFFFFF7F;
    }
}

