/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.inc;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.inc.IncA;
import edsim51sh.instructions.inc.IncAddress;
import edsim51sh.instructions.inc.IncAtReg;
import edsim51sh.instructions.inc.IncDptr;
import edsim51sh.instructions.inc.IncReg;

public class Inc
extends Instruction {
    public Inc() {
        this.mneumonic = "INC";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.equals("INC A")) {
            return new IncA();
        }
        if (mneumonic.equals("INC DPTR")) {
            return new IncDptr();
        }
        int registerNumber = mneumonic.charAt(mneumonic.length() - 1) - 48;
        if (mneumonic.startsWith("INC R") && mneumonic.charAt(mneumonic.length() - 1) >= '0' && mneumonic.charAt(mneumonic.length() - 1) <= '7') {
            return new IncReg(registerNumber);
        }
        if (mneumonic.equals("INC @R0") || mneumonic.equals("INC @R1")) {
            return new IncAtReg(registerNumber);
        }
        return new IncAddress();
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

