'''OpenGL extension VERSION.GL_3_2

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_3_2 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_3_2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.VERSION.GL_3_2 import *
from OpenGL.raw.GL.VERSION.GL_3_2 import _EXTENSION_NAME

def glInitGl32VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION
from OpenGL.GL.ARB.draw_elements_base_vertex import *
from OpenGL.GL.ARB.provoking_vertex import *
from OpenGL.GL.ARB.sync import *
from OpenGL.GL.ARB.texture_multisample import *
