'''OpenGL extension ARB.clear_buffer_object

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.clear_buffer_object to provide a more 
Python-friendly API

Overview (from the spec)
	
	Buffer objects are fundamental to the operation of OpenGL. Buffers are used
	as a source of data for vertices and indices, read through buffer textures
	in shaders, used to transfer texture and image data into and out of
	textures and framebuffers, and may be written to by operations such as
	transform feedback. OpenGL contains mechanisms to copy sections of buffers
	from one to another, but it has no mechanism to initialize the content
	of a buffer to a known value. In effect, it has memcpy, but not memset.
	
	This extension adds such a mechanism and has several use cases. Examples
	include clearing a pixel unpack buffer before transferring data to
	a texture or resetting buffer data to a known value before sparse updates
	through shader image stores or transform feedback.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/clear_buffer_object.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.clear_buffer_object import *
from OpenGL.raw.GL.ARB.clear_buffer_object import _EXTENSION_NAME

def glInitClearBufferObjectARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION