/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.ProgressListener;
import com.dropbox.client2.Util;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxPartialFileException;
import com.dropbox.client2.exception.DropboxServerException;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.dropbox.client2.session.WebAuthSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class DropboxAPITest {
    private static DropboxAPI<?> api;
    static DateFormat dateFormat;
    private static final String TESTS_DIR;
    private File foo = new File("testfiles", "foo.txt");
    private File song = new File("testfiles", "dropbox_song.mp3");
    private File frog = new File("testfiles", "Costa Rican Frog.jpg");

    public void assertFile(DropboxAPI.Entry entry, File file, String string) {
        Assert.assertEquals((long)entry.bytes, (long)file.length());
        Assert.assertEquals((Object)entry.isDir, (Object)false);
        Assert.assertEquals((Object)entry.path, (Object)string);
    }

    @Test
    public void accountInfo() throws Exception {
        DropboxAPI.Account account = api.accountInfo();
        assert (account.country != null) : "No country for account";
        assert (account.displayName != null) : "No displayName for account";
        assert (account.quota > 0L) : "0 quota in account";
        assert (account.quotaNormal > 0L) : "0 normal quota in account";
        assert (account.referralLink != null) : "No referral link for account";
        assert (account.uid > 0L) : "No uid for account";
    }

    @Test
    public void getMetadataBad() throws Exception {
        block5: {
            try {
                String string = TESTS_DIR + "iDoNotExist.txt";
                DropboxAPI.Entry entry = api.metadata(string, 1000, null, true, null);
                assert (entry.isDeleted) : "The " + string + " directory should not exist";
            }
            catch (DropboxServerException dropboxServerException) {
                if (dropboxServerException.error != 404) assert (false) : "Unexpected Dropbox Server Error: " + dropboxServerException.toString();
            }
            catch (DropboxException dropboxException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Unexpected Dropbox Error: " + dropboxException.toString()));
            }
        }
    }

    @Test
    public void createFolder() throws Exception {
        String string = TESTS_DIR + "createdFolder";
        DropboxAPI.Entry entry = api.createFolder(string);
        Assert.assertEquals((Object)entry.isDir, (Object)true);
    }

    @Test
    public void createFolderDupe() throws Exception {
        block5: {
            try {
                api.createFolder(TESTS_DIR);
                assert (false) : "Able to create duplicate folder";
            }
            catch (DropboxServerException dropboxServerException) {
                if (dropboxServerException.error != 403) assert (false) : "Unexpected Dropbox Server Error: " + dropboxServerException.toString();
            }
            catch (DropboxException dropboxException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Unexpected Dropbox Error: " + dropboxException.toString()));
            }
        }
    }

    @Test
    public void getMetadata() throws Exception {
        String string = TESTS_DIR + "/metadatasong.mp3";
        this.uploadFile(this.song, string);
        DropboxAPI.Entry entry = api.metadata(string, 1000, null, true, null);
    }

    @Test
    public void getMetadataCached() throws Exception {
        block5: {
            try {
                DropboxAPI.Entry entry = api.metadata(TESTS_DIR, 1000, null, true, null);
                api.metadata(TESTS_DIR, 1000, entry.hash, true, null);
                assert (false) : "Directory should have been cached";
            }
            catch (DropboxServerException dropboxServerException) {
                if (dropboxServerException.error != 304) assert (false) : "Unexpected Dropbox Server Error: " + dropboxServerException.toString();
            }
            catch (DropboxException dropboxException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Unexpected Dropbox Error: " + dropboxException.toString()));
            }
        }
    }

    @Test
    public void putFile() throws Exception {
        this.assertPutFile(this.foo, TESTS_DIR + "/putfoo.txt");
        this.assertPutFile(this.frog, TESTS_DIR + "/putfrog.jpg");
        this.assertPutFile(this.song, TESTS_DIR + "/putsong.mp3");
    }

    public void assertPutFile(File file, String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DropboxAPI.Entry entry = api.putFile(string, fileInputStream, file.length(), null, null);
        Assert.assertEquals((Object)entry.path, (Object)string);
        Assert.assertEquals((long)entry.bytes, (long)file.length());
        Assert.assertEquals((Object)entry.isDir, (Object)false);
    }

    @Test
    public void getFile() throws Exception {
        this.assertGetFile(this.foo, TESTS_DIR + "/getfoo.txt");
        this.assertGetFile(this.song, TESTS_DIR + "/getsong.mp3");
        this.assertGetFile(this.frog, TESTS_DIR + "/getfrog.jpg");
    }

    public void assertGetFile(File file, String string) throws Exception {
        this.uploadFile(file, string);
        byte[] byArray = Util.streamToBytes(api.getFileStream(string, null));
        byte[] byArray2 = Util.streamToBytes(new FileInputStream(file));
        Assert.assertArrayEquals((byte[])byArray, (byte[])byArray2);
    }

    @Test
    public void getThumbnail() throws Exception {
        String string = TESTS_DIR + "/thumbnailfrog.jpg";
        this.uploadFile(this.frog, string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DropboxAPI.DropboxFileInfo dropboxFileInfo = api.getThumbnail(string, byteArrayOutputStream, DropboxAPI.ThumbSize.BESTFIT_480x320, DropboxAPI.ThumbFormat.JPEG, null);
        assert (dropboxFileInfo != null) : "No info returned";
        assert (dropboxFileInfo.getFileSize() > 0L) : "Thumbnail length 0";
        assert (dropboxFileInfo.getMetadata().bytes > 0L) : "Original file size 0";
        assert (dropboxFileInfo.getFileSize() != dropboxFileInfo.getMetadata().bytes) : "Thumbnail equals original file size.";
    }

    @Test
    public void getThumbnailStream() throws Exception {
        String string = TESTS_DIR + "/thumbnailstreamfrog.jpg";
        this.uploadFile(this.frog, string);
        DropboxAPI.DropboxInputStream dropboxInputStream = api.getThumbnailStream(string, DropboxAPI.ThumbSize.BESTFIT_480x320, DropboxAPI.ThumbFormat.JPEG);
        assert (dropboxInputStream != null) : "No info returned";
        assert (dropboxInputStream.getFileInfo().getFileSize() > 0L) : "Thumbnail length 0";
        assert (dropboxInputStream.getFileInfo().getMetadata().bytes > 0L) : "Original file size 0";
    }

    public void uploadFileOverwrite(File file, String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DropboxAPI.Entry entry = api.putFileOverwrite(string, fileInputStream, file.length(), null);
    }

    public void uploadFile(File file, String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DropboxAPI.Entry entry = api.putFile(string, fileInputStream, file.length(), null, null);
    }

    @Test
    public void copy() throws Exception {
        String string = TESTS_DIR + "/copyFrom.jpg";
        String string2 = TESTS_DIR + "/copyTo.jpg";
        this.uploadFile(this.frog, string);
        DropboxAPI.Entry entry = api.copy(string, string2);
        this.assertFile(entry, this.frog, string2);
        entry = api.metadata(string2, 1, null, false, null);
        this.assertFile(entry, this.frog, string2);
    }

    @Test
    public void move() throws Exception {
        String string = TESTS_DIR + "/moveFrom.jpg";
        String string2 = TESTS_DIR + "/moveTo.jpg";
        this.uploadFile(this.frog, string);
        DropboxAPI.Entry entry = api.move(string, string2);
        this.assertFile(entry, this.frog, string2);
        entry = api.metadata(string2, 1, null, false, null);
        this.assertFile(entry, this.frog, string2);
        DropboxAPI.Entry entry2 = api.metadata(string, 1, null, false, null);
        Assert.assertEquals((Object)entry2.isDeleted, (Object)true);
        Assert.assertEquals((long)entry2.bytes, (long)0L);
        assert (entry2.isDeleted);
    }

    @Test
    public void media() throws Exception {
        String string = TESTS_DIR + "/dropbox_song.mp3";
        this.uploadFile(this.song, string);
        DropboxAPI.DropboxLink dropboxLink = api.media(string, true);
        assert (dropboxLink.url != null) : "No url for streamed file";
        dropboxLink = api.media(string, false);
        assert (dropboxLink.url != null) : "No insecure url for streamed file";
    }

    @Test
    public void share() throws Exception {
        String string = TESTS_DIR + "/dropbox_song.mp3";
        this.uploadFile(this.song, string);
        DropboxAPI.DropboxLink dropboxLink = api.share(string);
        assert (dropboxLink.url != null) : "No url for streamed file";
    }

    @Test
    public void search() throws Exception {
        block3: {
            try {
                api.search("/", "", 1000, false);
                assert (false) : "Short (empty) search string did not throw an error.";
            }
            catch (DropboxServerException dropboxServerException) {
                if (dropboxServerException.error == 400 || $assertionsDisabled) break block3;
                throw new AssertionError((Object)("Unexpected Dropbox Error: " + dropboxServerException.toString()));
            }
        }
        String string = TESTS_DIR + "/searchDir/";
        this.uploadFile(this.foo, string + "text.txt");
        this.uploadFile(this.foo, string + "subFolder/text.txt");
        this.uploadFile(this.foo, string + "subFolder/cow.txt");
        this.uploadFile(this.frog, string + "frog.jpg");
        this.uploadFile(this.frog, string + "frog2.jpg");
        this.uploadFile(this.frog, string + "subFolder/frog2.jpg");
        List<DropboxAPI.Entry> list = api.search(string, "sadfasdf", 1000, false);
        Assert.assertEquals((long)list.size(), (long)0L);
        list = api.search(string, "jpg", 1000, false);
        Assert.assertEquals((long)list.size(), (long)3L);
        this.assertFile(list.get(0), this.frog, string + "frog.jpg");
        this.assertFile(list.get(1), this.frog, string + "frog2.jpg");
        this.assertFile(list.get(2), this.frog, string + "subFolder/frog2.jpg");
        list = api.search(string + "subFolder", "jpg", 1000, false);
        Assert.assertEquals((long)list.size(), (long)1L);
        this.assertFile(list.get(0), this.frog, string + "subFolder/frog2.jpg");
    }

    @Test
    public void revisionsAndRestore() throws Exception {
        String string = TESTS_DIR + "/revfoo.txt";
        this.uploadFileOverwrite(this.foo, string);
        this.uploadFileOverwrite(this.frog, string);
        this.uploadFileOverwrite(this.foo, string);
        List<DropboxAPI.Entry> list = api.revisions(string, 1000);
        assert (list.size() == 3) : "Not enough revs for file";
        this.assertFile(list.get(0), this.foo, string);
        this.assertFile(list.get(1), this.frog, string);
        this.assertFile(list.get(2), this.foo, string);
        for (DropboxAPI.Entry entry : list) {
            System.out.println("Revision: " + entry.rev + " modified: " + entry.modified);
        }
        DropboxAPI.Entry entry = api.restore(string, list.get((int)1).rev);
        this.assertFile(entry, this.frog, string);
    }

    @Test
    public void chunkedUploadsPlain() throws Exception {
        this.chunkedUploadsTestBase(false);
    }

    public void chunkedUploadsAbort() throws Exception {
        try {
            this.chunkedUploadsTestBase(true);
            assert (false) : "No exception WTF?";
        }
        catch (DropboxPartialFileException dropboxPartialFileException) {
            // empty catch block
        }
    }

    private void chunkedUploadsTestBase(boolean bl) throws Exception {
        String string = TESTS_DIR + "/chunkedfile.dat";
        Random random = new Random();
        int n = 0xA00000;
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        System.out.println("Uploading");
        final boolean[] blArray = new boolean[]{false};
        final DropboxAPI.ChunkedUploader chunkedUploader = api.getChunkedUploader(new ByteArrayInputStream(byArray), n);
        if (bl) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        System.out.println("KILLING");
                        chunkedUploader.abort();
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)exception);
                    }
                }
            }).start();
        }
        while (!chunkedUploader.isComplete()) {
            try {
                chunkedUploader.upload(3798120, new ProgressListener(){

                    public void onProgress(long l, long l2) {
                        System.out.println("progress: " + l);
                        blArray[0] = true;
                    }
                });
            }
            catch (Exception exception) {
                System.out.println(chunkedUploader.getOffset());
                if (chunkedUploader.getActive()) continue;
                throw exception;
            }
        }
        chunkedUploader.finish(string, null);
        DropboxAPI.DropboxInputStream dropboxInputStream = api.getFileStream(string, null);
        byte[] byArray2 = Util.streamToBytes(dropboxInputStream);
        Assert.assertTrue((boolean)blArray[0]);
        Assert.assertEquals((long)byArray.length, (long)byArray2.length);
        Assert.assertArrayEquals((byte[])byArray2, (byte[])byArray);
    }

    static {
        block2: {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            TESTS_DIR = "/" + dateFormat.format(new Date());
            try {
                AppKeyPair appKeyPair = new AppKeyPair(System.getProperty("app_key"), System.getProperty("app_secret"));
                WebAuthSession webAuthSession = new WebAuthSession(appKeyPair, Session.AccessType.APP_FOLDER);
                webAuthSession.setAccessTokenPair(new AccessTokenPair(System.getProperty("access_key"), System.getProperty("access_secret")));
                api = new DropboxAPI<WebAuthSession>(webAuthSession);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Total failure trying to start WebAuthSession." + throwable));
            }
        }
    }
}

