/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class MainFileInstallerState
extends FileInstallerState {
    private transient File logDir;
    private transient FileLogger newFileLogger = new FileLogger();
    private transient FileLogger oldFileLogger = new FileLogger();
    private transient FileLogger rollbackFileLogger = new FileLogger();
    private transient List cleanupFiles = new ArrayList();
    private transient boolean hasUnrollbackedFiles = false;
    private transient boolean currentRebootRequired = false;

    MainFileInstallerState() {
    }

    public void addCreatedDir(InstallFile installFile) {
        this.newFileLogger.addCreatedDir(installFile, this.currentId);
        this.rollbackFileLogger.addCreatedDir(installFile, this.currentId);
    }

    public void addReplacedFile(BackupPair backupPair) {
        this.newFileLogger.addReplacedFile(backupPair, this.currentId);
        this.rollbackFileLogger.addReplacedFile(backupPair, this.currentId);
    }

    public void setRollbackBarrier() {
        if (!this.hasUnrollbackedFiles) {
            this.hasUnrollbackedFiles = this.rollbackFileLogger.hasFiles();
        }
        this.rollbackFileLogger = new FileLogger();
    }

    public void setLogDir(File file) {
        if (this.logDir == null) {
            this.logDir = file;
            try {
                this.oldFileLogger.read(new File(file, "files.log"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeLog() throws IOException, UserCanceledException {
        final File file = new File(this.logDir, "files.log");
        final File file2 = File.createTempFile("i4jf", ".log");
        this.newFileLogger.write(file2, this.oldFileLogger);
        final String string = System.getProperty("install4j.runtimeAccessMode");
        HelperCommunication.getInstance().executeActionChecked(ContentInstaller.getExecutionContext(), new RunAction(){

            protected void run(Context context) throws IOException {
                FileUtil.copyFile(file2, file);
                if (!file2.delete()) {
                    file2.deleteOnExit();
                }
                if (string != null && !Util.isWindows()) {
                    VersionSpecificHelper.setPosixFilePermissions(file, string);
                }
            }
        });
    }

    public boolean wasPreviouslyCreated(File file) {
        return this.oldFileLogger.containsCreatedFile(file);
    }

    public boolean hasRollbackFiles() {
        return this.rollbackFileLogger.hasFiles();
    }

    public boolean hasUnrollbackedFiles() {
        return this.hasUnrollbackedFiles;
    }

    public void addCreatedFile(InstallFile installFile, boolean bl) {
        this.newFileLogger.addCreatedFile(installFile, this.currentId);
        if (bl) {
            this.rollbackFileLogger.addCreatedFile(installFile, this.currentId);
        }
    }

    public FileLogger getRollbackFileLogger() {
        return this.rollbackFileLogger;
    }

    public List getReplacedFiles() {
        return this.newFileLogger.getReplacedFiles(-1);
    }

    public List getCleanupFiles() {
        return this.cleanupFiles;
    }

    public void registerCleanupFile(File file) {
        this.cleanupFiles.add(file);
    }

    public boolean isCurrentRebootRequired() {
        return this.currentRebootRequired;
    }

    public void setCurrentRebootRequired(boolean bl) {
        this.currentRebootRequired = bl;
    }
}

