/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.CountingInputStream;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.Md5Checker;
import com.install4j.runtime.installer.helper.content.PartialFileInputStream;
import com.install4j.runtime.installer.helper.content.SplittedFileInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ContentCollector {
    private static final String DATA_DIR_NAME = "data";
    private ProgressInterface progressInterface;
    private InstallerContext context;
    private boolean saveDownloadedFiles;

    public ContentCollector(ProgressInterface progressInterface, InstallerContext installerContext, boolean bl) {
        this.progressInterface = progressInterface;
        this.context = installerContext;
        this.saveDownloadedFiles = bl;
    }

    public Map collectContentStreams(String string) throws UserCanceledException, IOException {
        Object object;
        Object object2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ContentStats contentStats = ContentStats.getInstance();
        String string2 = System.getProperty("exe4j.moduleName");
        Map map = this.initUnextractedFiles();
        Set set = contentStats.getSelectedContentNumbers(string);
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            Object object4;
            Object object5;
            object2 = (String)object3.next();
            object = contentStats.getFileName((String)object2);
            UnextractedInfo unextractedInfo = (UnextractedInfo)map.get(object);
            if (unextractedInfo != null) {
                object5 = new PartialFileInputStream(new File(string2), unextractedInfo.position, unextractedInfo.length);
                hashMap.put(object2, object5);
                continue;
            }
            object5 = string2 == null ? new File(".") : new File(string2).getAbsoluteFile().getParentFile();
            File file = this.getContentFile(contentStats, (String)object2, (String)object, (File)object5);
            if (!file.exists() && Util.isMacosInstaller() && (object4 = (String)this.context.getVariable("sys.mediaDir")) != null) {
                file = this.getContentFile(contentStats, (String)object2, (String)object, new File((String)object4));
            }
            if (!file.exists()) {
                object4 = InstallerConfig.getCurrentInstance().getDownloadURL();
                if (((String)object4).trim().length() == 0) {
                    String string3 = Messages.getMessages().getString("ErrorReadingSource") + "\n" + (String)object;
                    Util.showMessage(string3, 0);
                    throw new UserCanceledException();
                }
                arrayList.add(object2);
                continue;
            }
            object4 = new SplittedFileInputStream(file);
            hashMap.put(object2, object4);
        }
        object3 = ContentCollector.downloadContentFiles(arrayList, this.saveDownloadedFiles, this.context);
        object2 = object3.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            hashMap.put(object.getKey(), new FileInputStream((File)object.getValue()));
        }
        return hashMap;
    }

    private File getContentFile(ContentStats contentStats, String string, String string2, File file) {
        File file2 = new File(string2).getAbsoluteFile();
        if (!file2.exists()) {
            file2 = new File(new File(file, contentStats.getDirName()), string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(file, string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, DATA_DIR_NAME), string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, "common_files.dat"), "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, DATA_DIR_NAME), "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(file, "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        return file2;
    }

    private Map initUnextractedFiles() throws IOException {
        HashMap<String, UnextractedInfo> hashMap = new HashMap<String, UnextractedInfo>();
        String string = System.getProperty("exe4j.moduleName");
        if (!Util.isMacosInstaller() && string != null) {
            Object object;
            long l;
            int n = Integer.getInteger("exe4j.unextractedPositionRestart", 0);
            if (n == 0) {
                n = Integer.getInteger("exe4j.unextractedPosition", 0);
            }
            if (n == 0) {
                l = Long.getLong("exe4j.totalDataLength", 0L);
                object = new File(string);
                if (l > 0L && ((File)object).exists()) {
                    n = (int)(((File)object).length() - l);
                }
            }
            if (n > 0) {
                l = 0L;
                object = new CountingInputStream(new BufferedInputStream(new FileInputStream(string)));
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                dataInputStream.skipBytes(n);
                if (dataInputStream.readInt() == -387705899) {
                    UnextractedInfo unextractedInfo;
                    int n2 = dataInputStream.readInt();
                    for (int i = 0; i < n2; ++i) {
                        unextractedInfo = new UnextractedInfo();
                        String string2 = dataInputStream.readUTF();
                        unextractedInfo.length = dataInputStream.readLong();
                        unextractedInfo.position = l;
                        l += unextractedInfo.length;
                        hashMap.put(string2, unextractedInfo);
                    }
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        unextractedInfo = (UnextractedInfo)iterator.next();
                        unextractedInfo.position += ((CountingInputStream)object).getCount();
                    }
                } else {
                    throw new IOException("wrong magic number");
                }
                dataInputStream.close();
            }
        }
        return hashMap;
    }

    private static Map downloadContentFiles(final List list, final boolean bl, Context context) throws IOException, UserCanceledException {
        if (list.size() > 0) {
            context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("Downloading"));
        }
        return (Map)HelperCommunication.getInstance().fetchObjectChecked(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws Exception {
                Object object;
                Downloader downloader = new Downloader(context, context.getProgressInterface(), true);
                ContentStats contentStats = ContentStats.getInstance();
                long l = 0L;
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    l += contentStats.getFileSize((String)object);
                }
                downloader.setTotalSize(l);
                object2 = new HashMap();
                object = list.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    boolean bl2 = true;
                    while (bl2) {
                        try {
                            File file = ContentCollector.downloadSingleFile(string, downloader, context, bl);
                            object2.put(string, file);
                            bl2 = false;
                        }
                        catch (IOException iOException) {
                            downloader.resetLastDownload();
                            Logger.getInstance().info(this, iOException.toString());
                            ContentCollector.askRetry("DownloadContentError");
                        }
                    }
                }
                return object2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadSingleFile(String string, Downloader downloader, Context context, boolean bl) throws IOException, UserCanceledException {
        ContentStats contentStats = ContentStats.getInstance();
        File file = null;
        try {
            boolean bl2;
            String string2 = InstallerConfig.getCurrentInstance().getDownloadURL().trim();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            String string3 = null;
            do {
                String string4;
                String string5 = null;
                do {
                    bl2 = false;
                    string4 = ContentCollector.connect(string, string2, downloader);
                    String string6 = (String)context.getVariable("sys.mediaDir");
                    if (bl && string6 != null) {
                        try {
                            File file2 = File.createTempFile("i4jc", ".tst", new File(string6));
                            if (!file2.delete()) {
                                file2.deleteOnExit();
                            }
                            file = new File(string6, string4);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (file == null) {
                        file = File.createTempFile("i4jc", ".dat");
                    }
                    try {
                        downloader.download(file, contentStats.getFileSize(string), !bl);
                        string5 = Md5Checker.getHexStringFromBytes(downloader.digest());
                    }
                    catch (IOException iOException) {
                        Logger.getInstance().error(class$com$install4j$runtime$installer$helper$content$ContentCollector == null ? ContentCollector.class$("com.install4j.runtime.installer.helper.content.ContentCollector") : class$com$install4j$runtime$installer$helper$content$ContentCollector, "could not download file");
                        Logger.getInstance().log(iOException);
                        ContentCollector.askRetry("DownloadInterrupted");
                        bl2 = true;
                    }
                } while (bl2);
                bl2 = false;
                if (string3 == null) {
                    string3 = Md5Checker.getExpectedMd5(context, true, string2 + "md5sums", string4);
                }
                if ("".equals(string3)) continue;
                Logger.getInstance().info(class$com$install4j$runtime$installer$helper$content$ContentCollector == null ? ContentCollector.class$("com.install4j.runtime.installer.helper.content.ContentCollector") : class$com$install4j$runtime$installer$helper$content$ContentCollector, "expected md5 " + string3 + ", real md5 " + string5);
                if (string3.equals(string5)) continue;
                downloader.resetLastDownload();
                ContentCollector.askRetry("DownloadFileCorrupt");
                bl2 = true;
            } while (bl2);
        }
        finally {
            if (!bl && file != null) {
                file.deleteOnExit();
            }
        }
        return file;
    }

    private static String connect(String string, String string2, Downloader downloader) throws UserCanceledException, IOException {
        ContentStats contentStats = ContentStats.getInstance();
        String string3 = contentStats.getFileName(string);
        String string4 = string2 + string3;
        try {
            Logger.getInstance().info(ContentCollector.class, "Trying to load " + string4);
            downloader.connect(string4);
        }
        catch (IOException iOException) {
            Logger.getInstance().info(ContentCollector.class, iOException.toString());
            string3 = "common_files." + contentStats.getComponentListString(string) + ".dat";
            string4 = string2 + string3;
            Logger.getInstance().info(ContentCollector.class, "Trying to load " + string4);
            downloader.connect(string4);
        }
        Logger.getInstance().info(ContentCollector.class, "connected");
        return string3;
    }

    private static void askRetry(String string) throws UserCanceledException {
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        switch (Util.showOptionDialog(variableResourceBundleWrapper.getString(string), new String[]{variableResourceBundleWrapper.getString("ButtonOK"), variableResourceBundleWrapper.getString("ButtonCancel")}, 2)) {
            case -1: 
            case 1: {
                throw new UserCanceledException();
            }
        }
    }

    private static class UnextractedInfo {
        private long position;
        private long length;

        private UnextractedInfo() {
        }
    }
}

