/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;

public class RequestPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean obtainIfAdminWin = true;
    private boolean obtainIfNormalWin = false;
    private boolean failIfNotObtainedWin = true;
    private boolean obtainIfAdminMac = false;
    private boolean obtainIfNormalMac = false;
    private boolean failIfNotObtainedMac = true;
    private boolean failIfNotRootUnix = false;

    public boolean isObtainIfAdminWin() {
        return this.obtainIfAdminWin;
    }

    public void setObtainIfAdminWin(boolean bl) {
        this.obtainIfAdminWin = bl;
    }

    public boolean isObtainIfNormalWin() {
        return this.obtainIfNormalWin;
    }

    public void setObtainIfNormalWin(boolean bl) {
        this.obtainIfNormalWin = bl;
    }

    public boolean isFailIfNotObtainedWin() {
        return this.failIfNotObtainedWin;
    }

    public void setFailIfNotObtainedWin(boolean bl) {
        this.failIfNotObtainedWin = bl;
    }

    public boolean isObtainIfAdminMac() {
        return this.obtainIfAdminMac;
    }

    public void setObtainIfAdminMac(boolean bl) {
        this.obtainIfAdminMac = bl;
    }

    public boolean isObtainIfNormalMac() {
        return this.obtainIfNormalMac;
    }

    public void setObtainIfNormalMac(boolean bl) {
        this.obtainIfNormalMac = bl;
    }

    public boolean isFailIfNotObtainedMac() {
        return this.failIfNotObtainedMac;
    }

    public void setFailIfNotObtainedMac(boolean bl) {
        this.failIfNotObtainedMac = bl;
    }

    public boolean isFailIfNotRootUnix() {
        return this.failIfNotRootUnix;
    }

    public void setFailIfNotRootUnix(boolean bl) {
        this.failIfNotRootUnix = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (Util.isWindows()) {
            return this.executeOnWindows(context);
        }
        if (Util.isMacOS()) {
            return this.executeOnMac(context);
        }
        if (this.failIfNotRootUnix && !Util.hasFullAdminRights()) {
            this.showFailureMessage(context);
            return false;
        }
        return true;
    }

    private boolean executeOnMac(Context context) throws UserCanceledException {
        boolean bl = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminMac) {
                bl = Util.hasFullAdminRights() || this.startOnMac(context);
            }
        } else if (this.obtainIfNormalMac) {
            bl = this.startOnMac(context);
        }
        if (!bl && this.failIfNotObtainedMac) {
            this.showFailureMessage(context);
        }
        return bl;
    }

    private boolean executeOnWindows(Context context) throws UserCanceledException {
        boolean bl = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminWin) {
                bl = Util.hasFullAdminRights() || this.startOnWindows(context);
            }
        } else if (this.obtainIfNormalWin) {
            bl = this.startOnWindows(context);
        }
        if (!bl && this.failIfNotObtainedWin) {
            this.showFailureMessage(context);
        }
        return bl;
    }

    public boolean isAllRequested() {
        return this.obtainIfAdminWin && this.obtainIfNormalWin && this.obtainIfAdminMac && this.obtainIfNormalMac;
    }

    public void setAllRequested() {
        this.obtainIfAdminWin = true;
        this.obtainIfNormalWin = true;
        this.obtainIfAdminMac = true;
        this.obtainIfNormalMac = true;
        this.failIfNotObtainedWin = true;
        this.failIfNotObtainedMac = true;
        this.failIfNotRootUnix = true;
    }
}

