/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.context;

import com.install4j.api.beans.Anchor;
import java.awt.Color;
import java.io.File;

public class WizardIndex {
    private String[] stepNames;
    private String[] keys;
    private boolean partiallyDefined;
    private int maxWidth = 300;
    private int minWidth = 120;
    private boolean numbered = true;
    private Color background;
    private Color foreground;
    private File backgroundImage;
    private Anchor backgroundImageAnchor = Anchor.SOUTHWEST;
    private String initialKey;

    public WizardIndex(String[] stringArray) {
        this(stringArray, null);
    }

    public WizardIndex(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("step names must have a length > 0");
        }
        this.stepNames = stringArray;
        if (stringArray2 == null) {
            stringArray2 = this.createKeys(stringArray);
        }
        if (stringArray2.length != stringArray.length) {
            throw new IllegalArgumentException("step names and keys must have the same lengths");
        }
        this.keys = stringArray2;
    }

    public String[] getStepNames() {
        return this.stepNames;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public boolean isPartiallyDefined() {
        return this.partiallyDefined;
    }

    public WizardIndex partiallyDefined(boolean bl) {
        this.partiallyDefined = bl;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public WizardIndex maxWidth(int n) {
        this.maxWidth = n;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public WizardIndex minWidth(int n) {
        this.minWidth = n;
        return this;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public WizardIndex numbered(boolean bl) {
        this.numbered = bl;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public WizardIndex background(Color color) {
        this.background = color;
        return this;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public WizardIndex foreground(Color color) {
        this.foreground = color;
        return this;
    }

    public File getBackgroundImage() {
        return this.backgroundImage;
    }

    public WizardIndex backgroundImage(File file) {
        this.backgroundImage = file;
        return this;
    }

    public Anchor getBackgroundImageAnchor() {
        return this.backgroundImageAnchor;
    }

    public WizardIndex backgroundImageAnchor(Anchor anchor) {
        this.backgroundImageAnchor = anchor;
        return this;
    }

    public String getInitialKey() {
        return this.initialKey == null ? this.keys[0] : this.initialKey;
    }

    public WizardIndex initialKey(String string) {
        this.initialKey = string;
        return this;
    }

    private String[] createKeys(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = String.valueOf(i + 1);
        }
        return stringArray2;
    }
}

