/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class SerializableEnum
implements Serializable {
    private static Map identifierToInstance = Collections.synchronizedMap(new HashMap());
    private static Map classNameToLastId = Collections.synchronizedMap(new HashMap());
    private int id;

    protected SerializableEnum() {
        String string = this.getClass().getName();
        MutableInt mutableInt = (MutableInt)classNameToLastId.get(string);
        if (mutableInt == null) {
            mutableInt = new MutableInt();
            classNameToLastId.put(string, mutableInt);
        }
        this.id = ++mutableInt.val;
        identifierToInstance.put(new Identifier(string, this.id), this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.id);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.id = objectInputStream.readInt();
    }

    protected Object readResolve() throws ObjectStreamException {
        Object v = identifierToInstance.get(new Identifier(this.getClass().getName(), this.id));
        if (v == null) {
            throw new InvalidObjectException("unknown id " + this.id + " for class " + this.getClass().getName());
        }
        return v;
    }

    private static class Identifier {
        private String className;
        private int id;

        private Identifier(String string, int n) {
            this.className = string;
            this.id = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Identifier identifier = (Identifier)object;
            if (this.id != identifier.id) {
                return false;
            }
            return this.className.equals(identifier.className);
        }

        public int hashCode() {
            int n = this.className.hashCode();
            n = 31 * n + this.id;
            return n;
        }
    }

    private static class MutableInt {
        int val;

        private MutableInt() {
        }
    }
}

