/** @file cmd_main.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMD_MAIN_H
#define CMD_MAIN_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef MAIN_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define MAIN_CMDLINE_PARSER_PACKAGE "sxreport-server"
#endif

#ifndef MAIN_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define MAIN_CMDLINE_PARSER_PACKAGE_NAME "sxreport-server"
#endif

#ifndef MAIN_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define MAIN_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct main_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  const char *all_help; /**< @brief Print all the information below help description.  */
  int anonymize_flag;	/**< @brief Anonymize IP addresses, URLs, and cluster usernames (default=on).  */
  const char *anonymize_help; /**< @brief Anonymize IP addresses, URLs, and cluster usernames help description.  */
  const char *find_request_id_help; /**< @brief Print all messages corresponding to specified request ID help description.  */
  char * sysconfdir_arg;	/**< @brief Path to /etc.  */
  char * sysconfdir_orig;	/**< @brief Path to /etc original value given at command line.  */
  const char *sysconfdir_help; /**< @brief Path to /etc help description.  */
  char * output_arg;	/**< @brief Save output to given file (default: sxreport-server-<timestamp>.log).  */
  char * output_orig;	/**< @brief Save output to given file (default: sxreport-server-<timestamp>.log) original value given at command line.  */
  const char *output_help; /**< @brief Save output to given file (default: sxreport-server-<timestamp>.log) help description.  */
  char ** append_arg;	/**< @brief Append information from specified file (- is stdin), anonymized only if --anonymize is specified.  */
  char ** append_orig;	/**< @brief Append information from specified file (- is stdin), anonymized only if --anonymize is specified original value given at command line.  */
  unsigned int append_min; /**< @brief Append information from specified file (- is stdin), anonymized only if --anonymize is specified's minimum occurreces */
  unsigned int append_max; /**< @brief Append information from specified file (- is stdin), anonymized only if --anonymize is specified's maximum occurreces */
  const char *append_help; /**< @brief Append information from specified file (- is stdin), anonymized only if --anonymize is specified help description.  */
  const char *get_mem_help; /**< @brief Print total available memory and exit help description.  */
  const char *info_help; /**< @brief Print static configuration only help description.  */
  const char *logs_help; /**< @brief Print error messages from logs only (NOT anonymized) help description.  */
  const char *cluster_help; /**< @brief Print information about cluster's status & health help description.  */
  const char *storage_help; /**< @brief Print information about the node's local storage help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int all_given ;	/**< @brief Whether all was given.  */
  unsigned int anonymize_given ;	/**< @brief Whether anonymize was given.  */
  unsigned int find_request_id_given ;	/**< @brief Whether find-request-id was given.  */
  unsigned int sysconfdir_given ;	/**< @brief Whether sysconfdir was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int append_given ;	/**< @brief Whether append was given.  */
  unsigned int get_mem_given ;	/**< @brief Whether get-mem was given.  */
  unsigned int info_given ;	/**< @brief Whether info was given.  */
  unsigned int logs_given ;	/**< @brief Whether logs was given.  */
  unsigned int cluster_given ;	/**< @brief Whether cluster was given.  */
  unsigned int storage_given ;	/**< @brief Whether storage was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct main_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure main_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure main_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *main_args_info_purpose;
/** @brief the usage string of the program */
extern const char *main_args_info_usage;
/** @brief the description string of the program */
extern const char *main_args_info_description;
/** @brief all the lines making the help output */
extern const char *main_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *main_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int main_cmdline_parser (int argc, char **argv,
  struct main_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use main_cmdline_parser_ext() instead
 */
int main_cmdline_parser2 (int argc, char **argv,
  struct main_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int main_cmdline_parser_ext (int argc, char **argv,
  struct main_args_info *args_info,
  struct main_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int main_cmdline_parser_dump(FILE *outfile,
  struct main_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int main_cmdline_parser_file_save(const char *filename,
  struct main_args_info *args_info);

/**
 * Print the help
 */
void main_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void main_cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void main_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a main_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void main_cmdline_parser_params_init(struct main_cmdline_parser_params *params);

/**
 * Allocates dynamically a main_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized main_cmdline_parser_params structure
 */
struct main_cmdline_parser_params *main_cmdline_parser_params_create(void);

/**
 * Initializes the passed main_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void main_cmdline_parser_init (struct main_args_info *args_info);
/**
 * Deallocates the string fields of the main_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void main_cmdline_parser_free (struct main_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int main_cmdline_parser_required (struct main_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMD_MAIN_H */
