/*
 * Pidgin Toolbar Icons
 * Copyright (C) 2010 Konrad Gräfe
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */

#include "toolbar_shrink.h"

#include "prefs.h"
#include "iconification.h"

#include <debug.h>

enum pref_columns {
        PREF_LIST_COL_LABEL,
        PREF_LIST_COL_VALUE
};

static void combo_changed_cb(GtkWidget *widget, gpointer data) {
        GtkTreeModel *model = NULL;
        GtkTreeIter iter;
        
        gint value;
        gchar *pref;
        
        gtk_combo_box_get_active_iter(GTK_COMBO_BOX(widget), &iter);
        model = gtk_combo_box_get_model(GTK_COMBO_BOX(widget));
        
        gtk_tree_model_get(model, &iter, PREF_LIST_COL_VALUE, &value, -1);
        pref = (gchar *) data;
        
        purple_prefs_set_int(pref, value);

	iconification_uninit();
	iconification_init();
}

static gboolean get_iter_by_shrink_method(GtkTreeModel *model, ShrinkMode mode, GtkTreeIter *iter) {
        gint current_mode;

        if(!gtk_tree_model_get_iter_first(model, iter)) return FALSE;
        while(iter) {
                gtk_tree_model_get(model, iter, PREF_LIST_COL_VALUE, &current_mode, -1);
                if(mode == current_mode) {
                        return TRUE;
                }
                gtk_tree_model_iter_next(model, iter);
        }
        return FALSE;
}

static void add_button_to_table(GtkWidget *table, gchar *caption, gchar *pref, gint row) {
	GtkWidget *label, *combo;
	GtkListStore *model = NULL;
	GtkCellRenderer *renderer = NULL;
	GtkTreeIter iter;

	model = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_INT);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter,
		PREF_LIST_COL_LABEL, _("Normal"),
		PREF_LIST_COL_VALUE, SHRINK_MODE_NONE,
		-1);
		
	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter,
		PREF_LIST_COL_LABEL, _("Shrink"),
		PREF_LIST_COL_VALUE, SHRINK_MODE_SHRINK,
		-1);
		
	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter,
		PREF_LIST_COL_LABEL, _("Hide"),
		PREF_LIST_COL_VALUE, SHRINK_MODE_HIDE,
		-1);

	label = gtk_label_new(caption);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0f, 0.5f);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, row, row + 1);
	combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(model));
	renderer = gtk_cell_renderer_text_new();
	gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo), renderer, FALSE);
	gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT(combo), renderer, "text", PREF_LIST_COL_LABEL, NULL);
	if(get_iter_by_shrink_method(GTK_TREE_MODEL(model), purple_prefs_get_int(pref), &iter)) {
		gtk_combo_box_set_active_iter(GTK_COMBO_BOX(combo), &iter);
	}
	g_signal_connect(G_OBJECT(combo), "changed", G_CALLBACK(combo_changed_cb), pref);
	gtk_table_attach_defaults(GTK_TABLE(table), combo, 1, 2, row, row + 1);
}


GtkWidget *get_config_frame(PurplePlugin *plugin) {
	GtkWidget *ret, *table;

	ret = gtk_vbox_new(FALSE, 18);
	gtk_container_set_border_width(GTK_CONTAINER(ret), 12);

	table = gtk_table_new(3, 2, FALSE);
        gtk_table_set_row_spacings(GTK_TABLE(table), 5);
        gtk_table_set_col_spacings(GTK_TABLE(table), 5);
        gtk_container_add(GTK_CONTAINER(ret), table);
	
		
	add_button_to_table(table, _("Font button:"), PLUGIN_PREFS_PREFIX "/font_button", 0);
	add_button_to_table(table, _("Insert button:"), PLUGIN_PREFS_PREFIX "/insert_button", 1);
	add_button_to_table(table, _("Smile button:"), PLUGIN_PREFS_PREFIX "/smile_button", 2);
	add_button_to_table(table, _("Attention button:"), PLUGIN_PREFS_PREFIX "/attention_button", 3);

	return ret;
}

void import_old_prefs(void) {
	const char *prefs_before_1_1[] = {
		"/plugins/gtk/toolbar_shrink/shrink_font_button",
		"/plugins/gtk/toolbar_shrink/shrink_insert_button",
		"/plugins/gtk/toolbar_shrink/shrink_smile_button",
		"/plugins/gtk/toolbar_shrink/shrink_attention_button",
		NULL
		};
	const char *prefs_since_1_1[] = {
		"/plugins/gtk/toolbar_shrink/font_button",
		"/plugins/gtk/toolbar_shrink/insert_button",
		"/plugins/gtk/toolbar_shrink/smile_button",
		"/plugins/gtk/toolbar_shrink/attention_button",
		NULL
		};
	int i;
	
	/* import prefs from versions before 1.1 */
	for(i=0; prefs_before_1_1[i]; i++) {
		if(purple_prefs_exists(prefs_before_1_1[i])) {
			if(purple_prefs_get_bool(prefs_before_1_1[i])) {
				purple_prefs_set_int(prefs_since_1_1[i], SHRINK_MODE_SHRINK);
			} else {
				purple_prefs_set_int(prefs_since_1_1[i], SHRINK_MODE_NONE);
			}
			purple_prefs_remove(prefs_before_1_1[i]);
		}
	}
}

