#define PURPLE_PLUGINS

#include <glib.h>

#include <gtkplugin.h>
#include <unistd.h>
#include "notify.h"
#include "plugin.h"
#include "version.h"
#include "gtkconv.h"
#include "debug.h"

/* Shaking used from xxx from the gtk-dev list */
static void
shake(GtkWidget *window) {
	int posx, posy;
	double ctr;

	gtk_window_get_position(GTK_WINDOW(window), &posx, &posy);
	purple_debug_info("pidgin-nudge", "Start Pos: %d, %d\n", posx, posy);

	gtk_window_get_position(GTK_WINDOW(window), &posx, &posy);
	for (ctr=0; ctr<2; ctr +=0.17) {
		//printf("sin(ctr:%f): %f\n", ctr, sin((double)ctr));
		gtk_window_move(GTK_WINDOW(window), posx-20+(ctr*10), posy );
	   gtk_window_get_position(GTK_WINDOW(window), &posx, &posy);
		printf("Pos: %d, %d\n", posx, posy);
		usleep(50 * 1000);
	 
	   gtk_window_move(GTK_WINDOW(window), posx+20-(ctr*10), posy );
	   gtk_window_get_position(GTK_WINDOW(window), &posx, &posy);
		printf("Pos: %d, %d\n", posx, posy);
		usleep(50 * 1000);
		while (gtk_events_pending())
	   	gtk_main_iteration();
	}
	gtk_window_get_position(GTK_WINDOW(window), &posx, &posy);
	purple_debug_info("pidgin-nudge", "Finish Pos: %d, %d\n", posx, posy);

}


void attention_cb(PurpleAccount *account, const char *who, PurpleConversation *conv, guint type) {
	shake(GTK_WIDGET(PIDGIN_CONVERSATION(conv)->win->window));
}

static gboolean
plugin_load(PurplePlugin *plugin) {
	purple_signal_connect(purple_conversations_get_handle(), "got-attention", plugin, G_CALLBACK(attention_cb), NULL);
	return TRUE;
}

static gboolean
plugin_unload(PurplePlugin *plugin) {

	//purple_signal_disconnect(
	return TRUE;
}

static PurplePluginInfo info = {
	PURPLE_PLUGIN_MAGIC,
	PURPLE_MAJOR_VERSION,
	PURPLE_MINOR_VERSION,
	PURPLE_PLUGIN_STANDARD,
	PIDGIN_PLUGIN_TYPE, /* NULL if core plugin or PIGDIN_PLUGIN_TYPE*/
	0,
	NULL,
	PURPLE_PRIORITY_DEFAULT,

	"gtk-pidgin-nudge",
	"Pidgin Nudge Plugin",
	"0.1",

	"Shakes the conversation window when you receive a nudge/buzz",
	"Shakes the conversation window when you receive a nudge/buzz",
	"Craig Harding <craigwharding@gmail.com>",
	"http://code.google.com/p/pidgin-nudge/",

	plugin_load,
	plugin_unload, /* plugin_unload */
	NULL, /* Destroying plugin */

	NULL, // &ui_info
	NULL,
	NULL,
	NULL,
	NULL, 
	NULL,
	NULL,
	NULL
};

static void
init_plugin(PurplePlugin *plugin)
{
}

PURPLE_INIT_PLUGIN(hello_world, init_plugin, info);
