/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.files.AbstractModifyFileAction;
import com.install4j.runtime.beans.actions.xml.ApacheXPathNodeListProvider;
import com.install4j.runtime.beans.actions.xml.NodeListProvider;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathReplaceAction
extends AbstractModifyFileAction {
    private String xpathExpression;
    private String regex = ".*";
    private String replacement;
    private boolean replaceAll = false;
    private boolean quoteVariables = true;

    public String getXpathExpression() {
        return XPathReplaceAction.replaceVariables(this.xpathExpression);
    }

    public void setXpathExpression(String string) {
        this.xpathExpression = string;
    }

    public String getRegex() {
        return XPathReplaceAction.replaceVariables(this.regex, this.quoteVariables ? ReplacementMode.REGEXP_MATCH : ReplacementMode.PLAIN);
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public String getReplacement() {
        return XPathReplaceAction.replaceVariables(this.replacement, this.quoteVariables ? ReplacementMode.REGEXP_REPLACEMENT : ReplacementMode.PLAIN);
    }

    public void setReplacement(String string) {
        this.replacement = string;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    public void setReplaceAll(boolean bl) {
        this.replaceAll = bl;
    }

    public boolean isQuoteVariables() {
        return this.quoteVariables;
    }

    public void setQuoteVariables(boolean bl) {
        this.quoteVariables = bl;
    }

    protected boolean modifyFile(File file, Context context) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeListProvider nodeListProvider = this.getNodeListProvider();
            if (nodeListProvider == null) {
                return false;
            }
            NodeList nodeList = nodeListProvider.getNodeList(document, this.getXpathExpression());
            if (nodeList == null) {
                return false;
            }
            if (nodeList.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeValue();
                if (string == null) {
                    return false;
                }
                string = this.isReplaceAll() ? string.replaceAll(this.getRegex(), this.getReplacement()) : string.replaceFirst(this.getRegex(), this.getReplacement());
                node.setNodeValue(string);
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(file));
            return true;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return false;
    }

    private NodeListProvider getNodeListProvider() {
        if (System.getProperty("java.version").startsWith("1.4")) {
            try {
                return new ApacheXPathNodeListProvider();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                noClassDefFoundError.printStackTrace();
                return null;
            }
        }
        try {
            return (NodeListProvider)Class.forName("com.install4j.runtime.beans.actions.xml.JaxpXPathNodeListProvider").newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }
}

