/*
 *  NiceShaper - Dynamic Traffic Management
 *
 *  Copyright 2004 Mariusz Jedwabny <mariusz@jedwabny.net>
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License.  See the file COPYING in the main directory of this archive for
 *  more details.
 */

#include "talk.h"

#include <cstring>
#include <unistd.h>

#include <iostream>
#include <string>

#include "main.h"
#include "log.h"
#include "niceshaper.h"

using std::string;
using std::vector;

Talk::Talk ()
{
    // Nothing
}

Talk::~Talk ()
{
    // Nothing
}

int Talk::sendInitStatusOk(int pipe_write)
{
    char cbuf = PROTO_INIT_ACK;

    write(pipe_write, &cbuf, 1);

    return 1;
}

int Talk::sendInitStatusError(int pipe_write)
{
    char cbuf = PROTO_INIT_NAK;

    write(pipe_write, &cbuf, 1);

    return 1;
}

int Talk::getInitStatus(int pipe_read)
{
    char cbuf;

    if ( read(pipe_read, &cbuf, 1 ) != 1 ) return -1;

    if ( cbuf == PROTO_INIT_ACK)
        return 0;
    else
        return -1;
}

int Talk::sendMsg( int pipe_write, string msg )
{
    vector <string>::iterator msgvi;
    string buf;

    buf = (char)(PROTO_BASE + msg.size());
    buf += msg;
    write( pipe_write, buf.c_str(), buf.size());

    return 0;
}

int Talk::getMsg( int pipe_read, string &msg )
{
    char buf[MAX_MESSAGE_SIZE];
    char cbuf;
    int msg_len, got_msg_len;

    if ( read( pipe_read, &cbuf, 1 ) != 1 ) { log.error(42); return -1; }

    msg_len = cbuf - PROTO_BASE;

    if ( msg_len >= MAX_MESSAGE_SIZE ) { log.error( 42 ); return -1; }
    got_msg_len = 0;
    strcpy(buf, "");
    buf[msg_len]=0;
    while (msg_len)
    {
        if (( got_msg_len=read( pipe_read, buf + got_msg_len, msg_len )) <= 0 ) return -1;
        msg_len -= got_msg_len;
    }

    msg = string(buf);

    return 0;
}

int Talk::sendContinue(int pipe_write)
{
    char cbuf = PROTO_MSG_ACK;

    write( pipe_write, &cbuf, 1 );

    return 0;
}

int Talk::sendFatalError(int pipe_write)
{
    char cbuf = PROTO_MSG_NAK;

    write( pipe_write, &cbuf, 1 );

    return 0;
}

int Talk::waitForContinue(int pipe_read)
{
    char cbuf;

    if ( read( pipe_read, &cbuf , 1 ) == -1 ) return -1;

    if ( cbuf == PROTO_MSG_ACK ) return 0;
    else return -1;
}

int Talk::sendMsgv( int pipe_write, vector <string> &msgv )
{
    vector <string>::iterator msgvi;
    string buf;
    char cbuf;

    msgvi = msgv.begin();
    while ( msgvi != msgv.end()) {
        buf = (char)(PROTO_BASE + (*msgvi).size());
        buf += *msgvi;
        write( pipe_write, buf.c_str(), buf.size());
        msgvi++;
    }

    cbuf = PROTO_MSG_EOT;
    write( pipe_write, &cbuf, 1);

    return 0;
}

int Talk::getMsgv( int pipe_read, vector <string> &msgv )
{
    char buf[MAX_MESSAGE_SIZE];
    char cbuf;
    int msg_len, got_msg_len;

    if ( read( pipe_read, &cbuf , 1 ) != 1 ) { log.error(42); return -1; }

    if ( cbuf == PROTO_MSG_NAK) return -1;
    else if ( cbuf == PROTO_MSG_ACK) return 0;

    msgv.clear();

    do {
        msg_len = cbuf - PROTO_BASE;
        if ( msg_len >= MAX_MESSAGE_SIZE ) { log.error( 42 ); return -1; }
        got_msg_len = 0;
        strcpy(buf, "");
        buf[msg_len]=0;
        while (msg_len)
        {
            if (( got_msg_len=read( pipe_read, buf + got_msg_len, msg_len )) <= 0 ) return -1;
            msg_len -= got_msg_len;
        }
        msgv.push_back( string(buf));
        if ( read( pipe_read, &cbuf , 1 ) != 1 ) { log.error( 42 ); return -1; }          
    } while ( cbuf != PROTO_MSG_EOT);

    return 1;
}


