#ifndef SYS_H
#define SYS_H

#define TIME_UNITS_PER_SEC  1000000
#define PREFIXLEN_SPECIFIED 1

#include <string>

#include "main.h"
#include "libnetlink.h"

typedef struct
{
    __u8 family;
    __u8 bytelen;
    __s16 bitlen;
    __u32 flags;
    __u32 data[8];
} inet_prefix;

struct tcu32sel
{
    struct tc_u32_sel sel;
    struct tc_u32_key keys[128];
};

class Sys 
{
    public:
        Sys();
        ~Sys();
        int TcCoreInit();
        int rtnlOpen();
        int rtnlClose();
        int tcClass(enum TcOperationType, int, unsigned int, unsigned int, 
                    unsigned, unsigned, unsigned, unsigned, unsigned int, unsigned int); // cmd, ifindex, parent_id, class_id, rate, ceil, prio, quantum, burst, cburst
        int tcQdisc(enum TcOperationType, int, unsigned int, unsigned int, enum TcQdiscType, int perturb); // cmd, ifindex, parent_id, handle_id, qdisc_type, perturb
        int tcFilter(enum TcOperationType, int, unsigned int, unsigned int, enum EnumTcFilterType, struct tcu32sel *); // cmd, ifindex, handle_id, flow_id, tc_filter_kind
        // Old fallback method using system();
        int ipt(std::string);
        int tc(std::string);
        void setDebugIpt(bool debug_ipt) { DebugIpt = debug_ipt; }
        void setDebugTc(bool debug_tc) { DebugTc = debug_tc; }
    private:
        int computeTcClassId(__u32 *h, unsigned int, unsigned int);
        int computeTcQdiscHandle(__u32 *h, unsigned int);
        int getHz();
        int tcCalcRtable(struct tc_ratespec *r, __u32 *rtab, int cell_log, unsigned mtu);
        int tcCalcSizeTable(struct tc_sizespec *s, __u16 **stab);
        unsigned tcCalcXmittime(unsigned rate, unsigned size);
        unsigned tcCoreTime2tick(unsigned time);
        unsigned tcAdjustSize(unsigned, unsigned);
        RTNetlink::rtnl_handle *NetlinkHandle;
        double TickInUsec;
        double ClockFactor;
        bool DebugIpt;
        bool DebugTc;
};

#endif
