#ifndef LOG_H
#define LOG_H

#include <string>
#include <iostream>

#include "main.h"

class Log
{
    public:
        Log (); 
        ~Log ();
        std::string getErrorMessage(int);
        std::string getWarningMessage(int);
        std::string getInfoMessage(int);
        void error (int);
        void error (int, std::string);
        void warning (int);
        void warning (int, std::string);
        void info (int);
        void info (int, std::string);
        void dump (std::string, std::string);
        void onTerminal (std::string);
        void toSyslog (std::string);
        void toLogFile (std::string);
        void setLang (LangType lang) { Lang = lang; } 
        void setLogOnTerminal (bool log_on_terminal) { LogOnTerminal = log_on_terminal; }
        void setLogToSyslog (bool log_to_syslog) { LogToSyslog = log_to_syslog; }
        void setDoNotPutNewLineChar(bool do_not_put) { DoNotPutNewLineChar = do_not_put; }
        void setLogFile (std::string);
        void setFatalError (bool fatal_error) { FatalError = fatal_error; }
        bool getFatalError () { return FatalError; };
        void dumpFooter ();
        void dumpHelp ();
    private:
        LangType Lang;
        bool FatalError;
        bool LogOnTerminal;
        bool LogToSyslog;
        bool LogToFile;
        bool DoNotPutNewLineChar;
        bool MissingNewLineChar;
        std::string LogFile;
};

#endif
