/*
 *      NiceShaper - Dynamic Traffic Management
 *
 *      Copyright 2004 Mariusz Jedwabny <mariusz@jedwabny.net>
 *
 *      This file is subject to the terms and conditions of the GNU General Public
 *      License.  See the file COPYING in the main directory of this archive for
 *      more details.
 */

#include "log.h"

#include <syslog.h> 
#include <fcntl.h>
#include <unistd.h>

#include <string> 
#include <iostream> 

#include "main.h"
#include "aux.h"

using std::string;

using namespace aux;

Log::Log ()
{
    Lang = EN;
    FatalError = false;
    LogOnTerminal = true;
    LogToSyslog = true;
    LogToFile = false;
    DoNotPutNewLineChar = false;
    MissingNewLineChar = false;
    LogFile = "";
}

Log::~Log ()
{
    // Nothing
}

std::string Log::getErrorMessage(int mesid)
{
    std::string message = "";

    if      (( mesid == 11 ) && ( Lang == PL_UTF8 )) message = "Nieznana dyrektywa, parametr lub wartość";
    else if (( mesid == 11 ) && ( Lang == EN )) message = "Unknown directive, parameter or value";
    else if (( mesid == 12 ) && ( Lang == PL_UTF8 )) message = "Firewall uszkodzony";
    else if (( mesid == 12 ) && ( Lang == EN )) message = "Firewall crashed";
    else if (( mesid == 13 ) && ( Lang == PL_UTF8 )) message = "Bledny reload. Parametr musi byc z zakresu 0.1s do 600s";
    else if (( mesid == 13 ) && ( Lang == EN )) message = "Wrong reload. Must be in range: (0.1s - 600s)";
    else if (( mesid == 14 ) && ( Lang == PL_UTF8 )) message = "Błędna wartość parametru mode, poprawne to download i upload";
    else if (( mesid == 14 ) && ( Lang == EN )) message = "Wrong mode, use download or upload";
    else if (( mesid == 15 ) && ( Lang == PL_UTF8 )) message = "Brak sekcji do uruchomienia";
    else if (( mesid == 15 ) && ( Lang == EN )) message = "Nothing to run";
    else if (( mesid == 16 ) && ( Lang == PL_UTF8 )) message = "Błędny interfejs";
    else if (( mesid == 16 ) && ( Lang == EN )) message = "Not proper device";
    else if (( mesid == 17 ) && ( Lang == PL_UTF8 )) message = "Nie obsługiwany scheduler";
    else if (( mesid == 17 ) && ( Lang == EN )) message = "Unrecognized scheduler";
    else if (( mesid == 18 ) && ( Lang == PL_UTF8 )) message = "Błędna podsieć";
    else if (( mesid == 18 ) && ( Lang == EN )) message = "Wrong network";
    else if (( mesid == 19 ) && ( Lang == PL_UTF8 )) message = "Section speed jest wymagane";
    else if (( mesid == 19 ) && ( Lang == EN )) message = "Section speed is required";    
    else if (( mesid == 20 ) && ( Lang == PL_UTF8 )) message = "Section shape jest wymagane";
    else if (( mesid == 20 ) && ( Lang == EN )) message = "Section shape is required";
    else if (( mesid == 21 ) && ( Lang == PL_UTF8 )) message = "Mode jest wymagane";
    else if (( mesid == 21 ) && ( Lang == EN )) message = "Mode is required";
    else if (( mesid == 22 ) && ( Lang == PL_UTF8 )) message = "Przynajmniej jeden filtr sekcji jest wymagany";
    else if (( mesid == 22 ) && ( Lang == EN )) message = "At least one section filter is required";
    else if (( mesid == 23 ) && ( Lang == PL_UTF8 )) message = "Przynajmniej jedna klasa jest wymagana";
    else if (( mesid == 23 ) && ( Lang == EN )) message = "At least one class is required";
    else if (( mesid == 24 ) && ( Lang == PL_UTF8 )) message = "Błąd składni";
    else if (( mesid == 24 ) && ( Lang == EN )) message = "Syntax error";
    else if (( mesid == 25 ) && ( Lang == PL_UTF8 )) message = "Zbyt dluga linia konfiguracji";
    else if (( mesid == 25 ) && ( Lang == EN )) message = "Config line is too long";
    else if (( mesid == 26 ) && ( Lang == PL_UTF8 )) message = "Nie mozna czytac z pliku";
    else if (( mesid == 26 ) && ( Lang == EN )) message = "Cannot read file";
    else if (( mesid == 27 ) && ( Lang == PL_UTF8 )) message = "Nie mozna pisac do pliku";
    else if (( mesid == 27 ) && ( Lang == EN )) message = "Cannot write to file";
    else if (( mesid == 28 ) && ( Lang == PL_UTF8 )) message = "Błędne użycie parametru linii poleceń";
    else if (( mesid == 28 ) && ( Lang == EN )) message = "Command line syntax error";
    else if (( mesid == 29 ) && ( Lang == PL_UTF8 )) message = "Błędny adres ip";
    else if (( mesid == 29 ) && ( Lang == EN )) message = "Wrong ip address";
    else if (( mesid == 30 ) && ( Lang == PL_UTF8 )) message = "Nie mozna bylo uruchomic sekcji";
    else if (( mesid == 30 ) && ( Lang == EN )) message = "Cannot start section";
    else if (( mesid == 31 ) && ( Lang == PL_UTF8 )) message = "Błędna jednostka transferu";
    else if (( mesid == 31 ) && ( Lang == EN )) message = "Not proper unit";
    else if (( mesid == 33 ) && ( Lang == PL_UTF8 )) message = "Podany interfejs nie należy do sekcji";
    else if (( mesid == 33 ) && ( Lang == EN )) message = "Given interface is not within section";
    else if (( mesid == 36 ) && ( Lang == PL_UTF8 )) message = "Podany filtr wymaga markowania pakietów na interfejsie";
    else if (( mesid == 36 ) && ( Lang == EN )) message = "Given filter requires mark on iface";
    else if (( mesid == 37 ) && ( Lang == PL_UTF8 )) message = "Filtr u32 wymaga maski sieciowej ciągłej bitowo";
    else if (( mesid == 37 ) && ( Lang == EN )) message = "Use solid netmask with u32 filter";
    else if (( mesid == 38 ) && ( Lang == PL_UTF8 )) message = "Nie odnaleziono otwarcia sekcji";
    else if (( mesid == 38 ) && ( Lang == EN )) message = "Can't find section opening tag";
    else if (( mesid == 39 ) && ( Lang == PL_UTF8 )) message = "Nie odnaleziono konfiguracji sekcji";
    else if (( mesid == 39 ) && ( Lang == EN )) message = "Can't find section configuration";
    else if (( mesid == 40 ) && ( Lang == PL_UTF8 )) message = "Section shape jest większe od section speed";
    else if (( mesid == 40 ) && ( Lang == EN )) message = "Section shape is bigger than section speed";
    else if (( mesid == 42 ) && ( Lang == PL_UTF8 )) message = "Błąd komunikacji między procesami. Odebranie wiadomości nie powiodło się";
    else if (( mesid == 42 ) && ( Lang == EN )) message = "Interprocess communication error. Receive message failed";
    else if (( mesid == 43 ) && ( Lang == PL_UTF8 )) message = "Błąd komunikacji między procesami. Wysłanie wiadomości nie powiodło się";
    else if (( mesid == 43 ) && ( Lang == EN )) message = "Interprocess communication error. Send message failed";
    else if (( mesid == 44 ) && ( Lang == PL_UTF8 )) message = "NiceShaper jest już uruchomiony";
    else if (( mesid == 44 ) && ( Lang == EN )) message = "NiceShaper alredy running";
    else if (( mesid == 45 ) && ( Lang == PL_UTF8 )) message = "NiceShaper nie jest uruchomiony";
    else if (( mesid == 45 ) && ( Lang == EN )) message = "NiceShaper is not running";
    else if (( mesid == 46 ) && ( Lang == PL_UTF8 )) message = "Odczytanie pliku konfiguracyjnego nie powiodlo sie";
    else if (( mesid == 46 ) && ( Lang == EN )) message = "Can't read config file";
    else if (( mesid == 47 ) && ( Lang == PL_UTF8 )) message = "Odczytanie pliku klas nie powiodlo sie";
    else if (( mesid == 47 ) && ( Lang == EN )) message = "Can't read classes file";
    else if (( mesid == 48 ) && ( Lang == PL_UTF8 )) message = "Nie mozna utworzyć pliku";
    else if (( mesid == 48 ) && ( Lang == EN )) message = "Cannot create file";
    else if (( mesid == 49 ) && ( Lang == PL_UTF8 )) message = "Błąd komunikacji między procesami. Nawiązanie połączenia nie powiodło się";
    else if (( mesid == 49 ) && ( Lang == EN )) message = "Interprocess communication error. Connection failed";
    else if (( mesid == 50 ) && ( Lang == PL_UTF8 )) message = "Błędny port ip";
    else if (( mesid == 50 ) && ( Lang == EN )) message = "Wrong ip port";
    else if (( mesid == 51 ) && ( Lang == PL_UTF8 )) message = "Nie udało się użyć adresu lokalnego";
    else if (( mesid == 51 ) && ( Lang == EN )) message = "Cannot assign to address";
    else if (( mesid == 52 ) && ( Lang == PL_UTF8 )) message = "Błąd komunikacji z kernelem poprzez netlink";
    else if (( mesid == 52 ) && ( Lang == EN )) message = "Communication with kernel via netlink error";
    else if (( mesid == 53 ) && ( Lang == PL_UTF8 )) message = "Błąd wewnętrzny";
    else if (( mesid == 53 ) && ( Lang == EN )) message = "Internal error";
    else if (( mesid == 54 ) && ( Lang == PL_UTF8 )) message = "Zbyt dluga nazwa sekcji. Maksymalnie " + int_to_str(MAX_SECTION_NAME_SIZE) +" znaków";
    else if (( mesid == 54 ) && ( Lang == EN )) message = "Section name too long. Maximum " + int_to_str(MAX_SECTION_NAME_SIZE) +" chars";
    else if (( mesid == 55 ) && ( Lang == PL_UTF8 )) message = "Zbyt dluga nazwa klasy. Maksymalnie " + int_to_str(MAX_CLASS_NAME_SIZE) +" znaków";
    else if (( mesid == 55 ) && ( Lang == EN )) message = "Class name too long. Maximum " + int_to_str(MAX_CLASS_NAME_SIZE) +" chars";
    else if (( mesid == 56 ) && ( Lang == PL_UTF8 )) message = "Brak parametru, klasy nie zostaną utworzone";
    else if (( mesid == 56 ) && ( Lang == EN )) message = "Missing parameter, not attempt to generate classess";
    else if (( mesid == 57 ) && ( Lang == PL_UTF8 )) message = "Niepoprawne hasło lub brak hasła";
    else if (( mesid == 57 ) && ( Lang == EN )) message = "Bad or missing password";
    else if (( mesid == 58 ) && ( Lang == PL_UTF8 )) message = "Parametr uruchomieniowy --remote wymaga parametru --password";
    else if (( mesid == 58 ) && ( Lang == EN )) message = "Runtime parameter --remote requires --password";
    // Filter messages
    else if ((mesid == 60) && (Lang == PL_UTF8)) message = "Niepoprawny filtr";
    else if ((mesid == 60) && (Lang == EN)) message = "Bad filter";
    else if ((mesid == 61) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Błędny stan";
    else if ((mesid == 61) && (Lang == EN)) message = "Bad filter. Invalid state";
    else if ((mesid == 62) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Test proto jest wymagany dla portów";
    else if ((mesid == 62) && (Lang == EN)) message = "Bad filter. Proto test is required to use ports";
    else if ((mesid == 63) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Test to-local wymaga in-iface, from-local wymaga out-iface";
    else if ((mesid == 63) && (Lang == EN)) message = "Bad filter. to-local requires in-iface, from-local requires out-iface";
    else if ((mesid == 64) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Test to-local wyklucza dstip";
    else if ((mesid == 64) && (Lang == EN)) message = "Bad filter. to-local squeeze out dstip";
    else if ((mesid == 65) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Test from-local wyklucza srcip";
    else if ((mesid == 65) && (Lang == EN)) message = "Bad filter. from-local squeeze out srcip";
    else if ((mesid == 66) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Zainicjowanie struktury U32 nie powiodło się";
    else if ((mesid == 66) && (Lang == EN)) message = "Bad filter. Prepare U32 failed";
    else if ((mesid == 67) && (Lang == PL_UTF8)) message = "Niepoprawny filtr. Błędny protokół";
    else if ((mesid == 67) && (Lang == EN)) message = "Bad filter. Bad protocol";
    // General configuration messages
    else if ((mesid == 101) && ( Lang == PL_UTF8 )) message = "Nieznany parametr lub wartość";
    else if ((mesid == 101) && ( Lang == EN )) message = "Unknown parameter or value";
    else if ((mesid == 102) && ( Lang == PL_UTF8 )) message = "Niepoprawna wartość parametru";
    else if ((mesid == 102) && ( Lang == EN )) message = "Bad value";
    else if ((mesid == 103) && ( Lang == PL_UTF8 )) message = "Klasy typu do-not-shape oraz wrapper wymagają parametru iface-{iface} speed";
    else if ((mesid == 103) && ( Lang == EN )) message = "Classess do-not-shape and wrapper type requires iface-{iface} speed parameter";
    // Filesystem operations
    else if ((mesid == 201) && ( Lang == PL_UTF8 )) message = "Nie mozna otworzyć pliku";
    else if ((mesid == 201) && ( Lang == EN )) message = "Cannot open file";
    // Inter processess and network communication
    else if ((mesid == 301) && ( Lang == PL_UTF8 )) message = "Przyjęcie połączenia sieciowego zakończone niepowodzeniem";
    else if ((mesid == 301) && ( Lang == EN )) message = "Accepting connection on a socket failed";
    // Iptables and iproute
    else if ((mesid == 701) && (Lang == PL_UTF8)) message = "Niepoprawny iptables hook. Poprawne to PREROUTING i POSTROUTING";
    else if ((mesid == 701) && (Lang == EN)) message = "Bad iptables hook. Must be PREROUTING or POSTROUTING";
    else if ((mesid == 702) && (Lang == PL_UTF8)) message = "Niepoprawny iptables hook-mode. Poprawne to append oraz insert";
    else if ((mesid == 702) && (Lang == EN)) message = "Bad iptables hook-mode. Must be append or insert";
    else if ((mesid == 703) && (Lang == PL_UTF8)) message = "Brak komendy iptables";
    else if ((mesid == 703) && (Lang == EN)) message = "Missing iptables command";
    else if ((mesid == 704) && (Lang == PL_UTF8)) message = "Brak komendy tc";
    else if ((mesid == 704) && (Lang == EN)) message = "Missing tc command";
    else if ((mesid == 705) && (Lang == PL_UTF8)) message = "Wykonanie iptables-restore zakończone niepowodzeniem. Należy spróbować z fallback iptables. W celach diagnostycznych pozostawiono wygenerowany plik batch";
    else if ((mesid == 705) && (Lang == EN)) message = "iptables-restore error occured. Try run again with fallback iptables directive. To diagnose batch file was not removed";
    // Bad values
    else if ((mesid == 801) && (Lang == PL_UTF8)) message = "Niepoprawna wartość alter time-period";
    else if ((mesid == 801) && (Lang == EN)) message = "Bad alter time-period value";
    else if ((mesid == 802) && (Lang == PL_UTF8)) message = "Burst sekcji musi być większe lub równe największemu burst klas podległych";
    else if ((mesid == 802) && (Lang == EN)) message = "Section burst must be equal or bigger than its classes biggest burst value";
    else if ((mesid == 803) && (Lang == PL_UTF8)) message = "Suma wartości parametrów section speed, jest większa lub równa zadeklarowanej szybkości interfejsu";
    else if ((mesid == 803) && (Lang == EN)) message = "Sections speeds sum bigger or equal than declared iface speed";
    else if ((mesid == 804) && (Lang == PL_UTF8)) message = "Suma wartości parametrów section speed oraz fallback-rate, jest większa lub równa zadeklarowanej szybkości interfejsu";
    else if ((mesid == 804) && (Lang == EN)) message = "Sections speeds sum and fallback-rate bigger or equal than declared iface speed";
    else if ((mesid == 805) && (Lang == PL_UTF8)) message = "Błędna wartość parametru stats rewrite. Parametr musi byc z zakresu 1s do 3600s";
    else if ((mesid == 805) && (Lang == EN)) message = "Wrong stats rewrite value. Must be in range of 1s to 3600s";
    else if ((mesid == 806) && (Lang == PL_UTF8)) message = "Wartość nie może być wyższa od " + int_to_str(unit_convert(MAX_RATE, MBITS)) + unit_to_str(MBITS, 0) + " ani niższa od " + int_to_str(unit_convert(MIN_RATE, BITS)) + unit_to_str(BITS, 0);
    else if ((mesid == 806) && (Lang == EN)) message = "Value cannot be bigger than " + int_to_str(unit_convert(MAX_RATE, MBITS)) + unit_to_str(MBITS, 0) + " or less than " + int_to_str(unit_convert(MIN_RATE, BITS)) + unit_to_str(BITS, 0);
    else if ((mesid == 807) && (Lang == PL_UTF8)) message = "Strict musi się mieścić w przedziale 0%-100%";
    else if ((mesid == 807) && (Lang == EN)) message = "Strict must be between 0% to 100%";
    // Triggers
    // Unknown error
    else if ( Lang == PL_UTF8 ) message = "Nieznany błąd";
    else message = "Unknown error";
    
    return message;
}

std::string Log::getWarningMessage (int mesid) 
{
    std::string message = "";

    if (( mesid == 1 ) && ( Lang == PL_UTF8 )) message = "Podana opcja jest przestarzała";
    else if (( mesid == 1 ) && ( Lang == EN )) message = "Given option is deprecated";
//    else if (( mesid == 2 ) && ( Lang == PL_UTF8 )) message = "Uzyto niestandardowego łańcucha iptables";
//    else if (( mesid == 2 ) && ( Lang == EN )) message = "Probably wrong iptables hook";
    else if (( mesid == 3 ) && ( Lang == PL_UTF8 )) message = "Brak parametru download-section, użyto wartości domyślnej";
    else if (( mesid == 3 ) && ( Lang == EN )) message = "Missing download-section parameter, using default";
    else if (( mesid == 4 ) && ( Lang == PL_UTF8 )) message = "Brak parametru upload-section, użyto wartości domyślnej";
    else if (( mesid == 4 ) && ( Lang == EN )) message = "Missing upload-section parameter, using default";
    else if (( mesid == 5 ) && ( Lang == PL_UTF8 )) message = "Brak parametru, użyto wartości domyślnej";
    else if (( mesid == 5 ) && ( Lang == EN )) message = "Missing parameter, using default";
    else if (( mesid == 6 ) && ( Lang == PL_UTF8 )) message = "Brak parametru, klasy nie zostaną utworzone";
    else if (( mesid == 6 ) && ( Lang == EN )) message = "Missing parameter, not attempt to generate classess";
//    else if (( mesid == 7 ) && ( Lang == PL_UTF8 )) message = "Podana opcja jest przestarzała, użyj iptables hook";
//    else if (( mesid == 7 ) && ( Lang == EN )) message = "Given option is deprecated, use iptables hook instead";
    else if (( mesid == 8 ) && ( Lang == PL_UTF8 )) message = "Podana opcja jest przestarzała, użyj imq autoredirect [true|false]";
    else if (( mesid == 8 ) && ( Lang == EN )) message = "Given option is deprecated, use imq autoredirect [true|false]";
    else if (( mesid == 9 ) && ( Lang == PL_UTF8 )) message = "Wartości \'none\' oraz \'false\' są przestarzałe, użyj \'no\'";
    else if (( mesid == 9 ) && ( Lang == EN )) message = "Values \'none\' and \'false\' are deprecated, use \'no\' instead";
    else if (( mesid == 10 ) && ( Lang == PL_UTF8 )) message = "Wartość \'true\' jest przestarzała, użyj \'yes\'";
    else if (( mesid == 10 ) && ( Lang == EN )) message = "Value \'true\' is deprecated, use \'yes\' instead";
    else if (( mesid == 11 ) && ( Lang == PL_UTF8 )) message = "Aliasy interfejsów nie są rozróżniane";
    else if (( mesid == 11 ) && ( Lang == EN )) message = "Interface alias is useless, only physical part is needed";
    else if (( mesid == 12 ) && ( Lang == PL_UTF8 )) message = "Błędna jednostka przepustowości, zostanie użyte b/s";
    else if (( mesid == 12 ) && ( Lang == EN )) message = "Wrong unit, using b/s instead";
    else if (( mesid == 13 ) && ( Lang == PL_UTF8 )) message = "Błędna jednostka quoty, zostanie użyte MB";
    else if (( mesid == 13 ) && ( Lang == EN )) message = "Wrong quota unit, using MB instead";
    else if (( mesid == 14 ) && (Lang == PL_UTF8)) message = "Liczniki wyzwalacza quota nie będą zapisane! Brakujący katalog";
    else if (( mesid == 14 ) && (Lang == EN)) message = "Quota counters will be lost after restart! Missing directory";
    else if (( mesid == 15 ) && (Lang == PL_UTF8)) message = "iptables-restore nie zostanie użyty! Nie można utworzyc pliku";
    else if (( mesid == 15 ) && (Lang == EN)) message = "iptables-restore will not be used! Cannot create file";
    else if (( mesid == 16 ) && (Lang == PL_UTF8)) message = "Tryb szybkiego startu nie zostanie uzyty! Brak wymaganego pliku binarnego iptables-save";
    else if (( mesid == 16 ) && (Lang == EN)) message = "Fallback to slow start! Missing required iptables-save executable";
    else if (( mesid == 17 ) && (Lang == PL_UTF8)) message = "Tryb szybkiego startu nie zostanie uzyty! Brak wymaganego pliku binarnego iptables-restore";
    else if (( mesid == 17 ) && (Lang == EN)) message = "Fallback to slow start! Missing required iptables-restore executable";
    else if ( Lang == PL_UTF8 ) message = "Nieznane ostrzeżenie";
    else message = "Unknown warning";

    return message;
}

std::string Log::getInfoMessage (int mesid) 
{
    std::string message = "";

    if (( mesid == 1 ) && ( Lang == PL_UTF8 )) message = "Start";
    else if (( mesid == 1 ) && ( Lang == EN )) message = "Start";
    else if (( mesid == 2 ) && ( Lang == PL_UTF8 )) message = "Stop";
    else if (( mesid == 2 ) && ( Lang == EN )) message = "Stop";
    else if (( mesid == 3 ) && ( Lang == PL_UTF8 )) message = "Uruchamianie sekcji...";
    else if (( mesid == 3 ) && ( Lang == EN )) message = "Starting section...";
    else if (( mesid == 4 ) && ( Lang == PL_UTF8 )) message = "Zatrzymywanie sekcji...";
    else if (( mesid == 4 ) && ( Lang == EN )) message = "Stopping section...";
    else if (( mesid == 5 ) && ( Lang == PL_UTF8 )) message = "Uruchamianie NiceShapera...";
    else if (( mesid == 5 ) && ( Lang == EN )) message = "Starting NiceShaper...";
    else if (( mesid == 6 ) && ( Lang == PL_UTF8 )) message = "Zatrzymywanie NiceShapera...";
    else if (( mesid == 6 ) && ( Lang == EN )) message = "Stopping NiceShaper...";
    else if (( mesid == 7 ) && ( Lang == PL_UTF8 )) message = "System";
    else if (( mesid == 7 ) && ( Lang == EN )) message = "System";
    else if (( mesid == 8 ) && ( Lang == PL_UTF8 )) message = "Timer";
    else if (( mesid == 8 ) && ( Lang == EN )) message = "Timer";
    else if ( Lang == PL_UTF8 ) message = "Nieznany komunikat";
    else message = "Unknown information";
    
    return message;
}

void Log::error (int message_id)
{
    error (message_id, "");
}

void Log::error (int message_id, string explanation)
{
    FatalError = true;

    dump (getErrorMessage(message_id), explanation);
}

void Log::warning (int message_id)
{
    warning(message_id, "");
}

void Log::warning (int message_id, string explanation)
{
    dump(getWarningMessage(message_id), explanation);
}

void Log::info (int message_id)
{
    info(message_id, "");
}

void Log::info (int message_id, string explanation)
{
    dump (getInfoMessage(message_id), explanation);
}
void Log::dump (string message, string explanation)
{
    std::string result;
    
    result = g_section_name + ": " + message;

    if (explanation.size()) result += ": " + explanation;
    else result += ".";

    if (LogOnTerminal) onTerminal( result );
    if (LogToSyslog) toSyslog( result );
    if (LogToFile) toLogFile( result );
}

void Log::setLogFile (string log_file) 
{ 
    LogFile = log_file;     
    
    if ( log_file == "" ) LogToFile = false;     
    else LogToFile = true;    
}

void Log::onTerminal (string message)
{
    if ( !DoNotPutNewLineChar ) {
        if (MissingNewLineChar) 
        {   
            std::cout << std::endl;
            MissingNewLineChar = false;
        }    
        if (message.size()) 
        {
            std::cout << message << std::endl;
        }
    }
    else {
        std::cout << message << std::flush;
        DoNotPutNewLineChar = false;
        MissingNewLineChar = true;
    }   
}

void Log::toSyslog (string message)
{
    setlogmask (LOG_UPTO (LOG_NOTICE));
    openlog ("niceshaper", LOG_PID | LOG_NDELAY, LOG_LOCAL1);
    syslog (LOG_NOTICE, message.c_str(), getuid ());
    closelog();
}

void Log::toLogFile (string message)
{
    int fd;

    fd = open(LogFile.c_str(), O_CREAT | O_WRONLY | O_APPEND);
    write( fd, message.c_str(), message.size());
    write( fd, "\n", 1 );
    close(fd);
}

void Log::dumpFooter() 
{
    std::string message = "";

    onTerminal (" ");
    onTerminal ("  NiceShaper version: " + VERSION );
    onTerminal ("  http://niceshaper.jedwabny.net");
    onTerminal (" ");
}

void Log::dumpHelp()
{
    dumpFooter();

    onTerminal ( "  Usage: niceshaper {start|stop|restart|convert|stats} [options]");
    onTerminal ( " ");
    onTerminal ( "  start/restart command options:");
    onTerminal ( "  --confdir path-to-dir    - Overwrite config directory location");
    onTerminal ( "  --conffile path-to-file  - Overwrite main config file default path");
    onTerminal ( "  --classfile path-to-file - Overwrite main class file default path");
    onTerminal ( "  --usersfile path-to-file - Overwrite optional users file default path");
    onTerminal ( "  --no-daemon              - Do not act as a background process");
    onTerminal ( " ");
    onTerminal ( "  stats command options:");
    onTerminal ( "  --unit unit              - Overwrite configured stats unit");
    onTerminal ( "  --remote ip[:port]       - Get stats from remote NiceShaper");
    onTerminal ( "                             If configured with stats listen");
    onTerminal ( "  --password password      - Password to get stats from remote NiceShaper");
    onTerminal ( "                             If configured with stats password");
    onTerminal ( "  --watch 1-60             - Monitor stats with 1-60 seconds interwal");
    onTerminal ( " ");
}

