#ifndef FILTER_H
#define FILTER_H

#include <asm/types.h>
#include <linux/pkt_sched.h>
#include <linux/pkt_cls.h>

#include <string>
#include <vector>

#include "main.h"
#include "sys.h"

class TcFilter {
    public:
        TcFilter(std::string, std::string, std::string, std::string);
        ~TcFilter();
        int store(std::string);
        int prepareIptFilter();
        int prepareIptRules(bool, std::vector <std::string> &);
        int prepareTcFilter();
        unsigned int add(); 
        unsigned int del();
        unsigned int check(std::vector  <std::string> &);
    private:
        int parseIpAddr(struct tc_u32_sel *, int, const char *, std::string);
        int getU32(__u32 *val, const char *arg, int base);
        int parseU16(struct tc_u32_sel *sel, int off, int offmask, const char *, const char *);
        int parseU8(struct tc_u32_sel *sel, int off, int offmask, const char *, const char *);
        int packKey(struct tc_u32_sel *, __u32, __u32, int, int);
        int packKey16(struct tc_u32_sel *sel, __u32 key, __u32 mask, int off, int offmask);
        int packKey8(struct tc_u32_sel *sel, __u32 key, __u32 mask, int off, int offmask);
        int getAddr1(inet_prefix *addr, const char *name);
        int getAddrIpv4(__u8 *ap, const char *cp);
        struct tcu32sel TcU32Selector;
        std::string Dev;
        std::string TcFilterAdd;
        std::string TcFilterDel;
        std::string Match;
        std::string IptMatch;
        std::string IptMyChain;
        std::string IptSectionHook;
        std::string IptRule1, IptRule2, IptRule3, IptRule4;
        unsigned int DevId;
        unsigned int FilterId;
        unsigned int HandleFw;
        unsigned int FlowId;
        unsigned int Chains;
        bool ImqAutoRedirect;
        bool DestMark;
        bool FromLocal;
        bool ToLocal;
        bool UseTcFilter;
        bool UseForFw;
        bool IptApplied;
        EnumTcFilterType TcFilterType;
        IptTargetType IptTarget; 
};

#endif
