/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: user.h 112 2009-03-15 17:30:28Z loos-br $
 */

#ifndef USER_H
#define USER_H

#include <sys/types.h>
#include <sys/socket.h>

#include <time.h>

#include "tree.h"
#include "command.h"
#include "ns-data.h"
#include "sb-data.h"
#include "check-cmd.h"
#include "contacts-data.h"

struct user_ {
    struct contacts	contacts;		/* contacts rb list */
    RB_ENTRY(user_)	user__;			/* RB list user data */
    struct ns__		ns;			/* ns connection */
    struct sbs		sbs;			/* sb connections list */

    __uint32_t		id;
    __uint32_t		state;			/* connection state */
    __uint32_t		version;		/* client version */
    __uint32_t		commands;		/* blocked commands */
    __uint32_t		msnp8_syn_bug;		/* windows messenger SYN bug workaround */
    __uint32_t		contact_delete;		/* remove unchanged contacts */

    string		dn;			/* display name */
    string		addr;			/* client ip */
    string		email;			/* msn user */
    string		status;			/* client status */

    CMDS_		*cmds;			/* allowed commands */
    SBCMDS_		*sbcmds;		/* allowed sb commands */
};

struct users_ {
    struct user_	*rbh_root;		/* root of the tree */
};

void		users__RB_INSERT_COLOR(struct users_ *head, struct user_ *elm);
void		users__RB_REMOVE_COLOR(struct users_ *head, struct user_ *parent, struct user_ *elm);
struct user_	*users__RB_REMOVE(struct users_ *head, struct user_ *elm);
struct user_	*users__RB_INSERT(struct users_ *head, struct user_ *elm);
struct user_	*users__RB_FIND(struct users_ *head, struct user_ *elm);
struct user_	*users__RB_NEXT(struct user_ *elm);
struct user_	*users__RB_MINMAX(struct users_ *head, int val);
void		user_rb_init(void);
int		msn_url(struct user_ *user, command *cmd, int args);
int		msn_ubx(struct user_ *user, command *cmd, int args);
struct user_	*user_alloc(struct sockaddr *sa, socklen_t sa_len);
void		user_disconnect(struct user_ *user);
int		msnp12_update_dn(struct user_ *user, command *cmd, int args);
int		msn_update_status(struct user_ *user, command *cmd, int args);
void	free_users_tree(void);

extern struct users_ users;
extern unsigned int user_max;
extern unsigned int user_inuse;

#endif

