/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: msg.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef MSG_H
#define MSG_H

#include "sb.h"
#include "command.h"

typedef struct header__ {
    string		header;
    string		value;
   struct  header__	*next;
} header_;

typedef struct {

    header_		*header;
    header_		*header_last;
    int			header_len;

    string		body;
} msg_;

void	msg_zero(msg_ *msg);
void	msg_add_header(msg_ *msg, header_ *header);
int	msg_header_find(msg_ *msg, const char *header, string *value);
int	msn_msg_type(msg_ *msg);
void	msg_free(msg_ *msg);
header_	*header_alloc(void);
int	msn_msg_header_decode(msg_ *msg, string *payload);
int	msn_msg_decode(struct sb_ *sb, command *cmd, int type);
int	msg_decode_utf8(struct sb_ *sb, command *cmd, msg_ *msg, int type);
int	msn_sb_server_msg(struct sb_ *sb, command *cmd, int args);
int	msn_sb_client_msg(struct sb_ *sb, command *cmd, int args);

#endif
