// Generated by IcedCoffeeScript 1.7.1-f
(function() {
  var Base, Posix, Win32, XdgPosix, lst, pathmod, sym, uc1, _eng, _i, _klass, _len, _ref,
    __slice = [].slice,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  pathmod = require('path');

  Base = (function() {
    function Base(args) {
      if (args == null) {
        args = {};
      }
      this.hooks = args.hooks, this.name = args.name;
    }

    Base.prototype.unsplit = function(v) {
      if (v.length && v[0].length === 0) {
        v = v.slice(0);
        v[0] = pathmod.sep;
      }
      return pathmod.join.apply(pathmod, v);
    };

    Base.prototype.join = function() {
      var v;
      v = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return pathmod.join.apply(pathmod, v);
    };

    Base.prototype.fallback_to_v1 = function() {
      return this;
    };

    Base.prototype.get_name = function(name) {
      return name || this.name;
    };

    Base.prototype.cache_dir = function(name) {
      if (name == null) {
        name = null;
      }
      return this.config_dir(name);
    };

    Base.prototype.data_dir = function(name) {
      if (name == null) {
        name = null;
      }
      return this.config_dir(name);
    };

    return Base;

  })();

  Posix = (function(_super) {
    __extends(Posix, _super);

    function Posix() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      Posix.__super__.constructor.apply(this, args);
      this.sep = pathmod.sep;
    }

    Posix.prototype.split = function(x) {
      return x.split(this.sep);
    };

    Posix.prototype.home = function(opts) {
      var f, ret, _ref;
      if (opts == null) {
        opts = {};
      }
      ret = (f = (_ref = this.hooks) != null ? _ref.get_home : void 0) != null ? f(opts) : null;
      if ((ret == null) && !opts.null_ok) {
        ret = process.env.HOME;
      }
      if (opts.array && (ret != null)) {
        return this.split(ret);
      } else {
        return ret;
      }
    };

    Posix.prototype.normalize = function(p) {
      return p;
    };

    Posix.prototype.config_dir_v1 = function(name) {
      var dirs;
      if (name == null) {
        name = null;
      }
      dirs = this.home({
        array: true
      });
      if ((name = this.get_name(name)) != null) {
        dirs.push("." + name);
      }
      return this.unsplit(dirs);
    };

    Posix.prototype.config_dir = function(name) {
      return this.config_dir_v1(name);
    };

    return Posix;

  })(Base);

  XdgPosix = (function(_super) {
    __extends(XdgPosix, _super);

    function XdgPosix() {
      return XdgPosix.__super__.constructor.apply(this, arguments);
    }

    XdgPosix.prototype.fallback_to_v1 = function() {
      return new Posix({
        hooks: this.hooks,
        name: this.name
      });
    };

    XdgPosix.prototype.config_dir = function(name) {
      var prfx;
      if (name == null) {
        name = null;
      }
      prfx = process.env.XDG_CONFIG_HOME || this.join(this.home(), ".config");
      name = this.get_name(name);
      if (name != null) {
        return this.join(prfx, name);
      } else {
        return prfx;
      }
    };

    XdgPosix.prototype.cache_dir = function(name) {
      var prfx;
      if (name == null) {
        name = null;
      }
      prfx = process.env.XDG_CACHE_HOME || this.join(this.home(), ".cache");
      name = this.get_name(name);
      if (name != null) {
        return this.join(prfx, name);
      } else {
        return prfx;
      }
    };

    XdgPosix.prototype.data_dir = function(name) {
      var prfx;
      if (name == null) {
        name = null;
      }
      prfx = process.env.XDG_DATA_HOME || this.join(this.home(), ".local", "share");
      name = this.get_name(name);
      if (name != null) {
        return this.join(prfx, name);
      } else {
        return prfx;
      }
    };

    return XdgPosix;

  })(Posix);

  uc1 = function(p) {
    return p[0].toUpperCase() + p.slice(1);
  };

  lst = function(v) {
    return v.slice(-1)[0];
  };

  Win32 = (function(_super) {
    __extends(Win32, _super);

    function Win32() {
      return Win32.__super__.constructor.apply(this, arguments);
    }

    Win32.prototype.split = function(x) {
      return x.split(/[/\\]/);
    };

    Win32.prototype.normalize = function(p) {
      return this.join(this.unsplit(p));
    };

    Win32.prototype.config_dir = function(name) {
      if (name == null) {
        name = null;
      }
      return this.config_dir_v1(name);
    };

    Win32.prototype.config_dir_v1 = function(name) {
      var home;
      if (name == null) {
        name = null;
      }
      home = this.home();
      name || (name = this.name);
      if (name != null) {
        return this.join(home, name);
      } else {
        return home;
      }
    };

    Win32.prototype.home = function(opts) {
      var e, err, f, p, ret;
      if (opts == null) {
        opts = {};
      }
      ret = err = null;
      if ((f = typeof hooks !== "undefined" && hooks !== null ? hooks.get_home : void 0) != null) {
        ret = f(opts);
      }
      if (ret != null) {
        ret = (opts.array ? this.split(ret) : ret);
      } else if (!opts.null_ok) {
        err = (e = process.env.TEMP) == null ? new Error("No env.TEMP variable found") : (p = this.split(e)).length === 0 ? new Error("Malformed env.TEMP variable") : !(p.pop().match(/^te?mp$/i)) ? new Error("TEMP didn't end in \\Temp") : (lst(p).toLowerCase() === "local" && !opts.local ? (p.pop(), p.push("Roaming")) : void 0, ret = opts.array ? p : this.unsplit(p), null);
        if (err != null) {
          throw err;
        }
      }
      return ret;
    };

    return Win32;

  })(Base);

  _klass = (function() {
    switch (process.platform) {
      case 'win32':
        return Win32;
      case 'linux':
        return XdgPosix;
      case 'darwin':
        return XdgPosix;
      default:
        return Posix;
    }
  })();

  _eng = new _klass();

  exports.new_eng = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return (function(func, args, ctor) {
      ctor.prototype = func.prototype;
      var child = new ctor, result = func.apply(child, args);
      return Object(result) === result ? result : child;
    })(_klass, args, function(){});
  };

  _ref = ['split', 'unsplit', 'home', 'normalize', 'join', 'config_dir', 'data_dir', 'cache_dir'];
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    sym = _ref[_i];
    exports[sym] = _eng[sym].bind(_eng);
  }

}).call(this);
