// Generated by IcedCoffeeScript 1.7.1-e
(function() {
  var BufferInStream, BufferOutStream, FnOutStream, NullInStream, NullOutStream, stream,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  stream = require('stream');

  exports.NullInStream = NullInStream = (function(_super) {
    __extends(NullInStream, _super);

    function NullInStream() {
      return NullInStream.__super__.constructor.apply(this, arguments);
    }

    NullInStream.prototype._read = function(sz) {
      this.push(null);
      return true;
    };

    NullInStream.prototype.is_readable = function() {
      return true;
    };

    NullInStream.prototype.is_writable = function() {
      return false;
    };

    return NullInStream;

  })(stream.Readable);

  exports.NullOutStream = NullOutStream = (function(_super) {
    __extends(NullOutStream, _super);

    function NullOutStream() {
      return NullOutStream.__super__.constructor.apply(this, arguments);
    }

    NullOutStream.prototype._write = function(dat, encoding, cb) {
      return cb();
    };

    NullOutStream.prototype.is_readable = function() {
      return false;
    };

    NullOutStream.prototype.is_writable = function() {
      return true;
    };

    return NullOutStream;

  })(stream.Writable);

  exports.BufferInStream = BufferInStream = (function(_super) {
    __extends(BufferInStream, _super);

    function BufferInStream(buf, options) {
      this.buf = buf;
      BufferInStream.__super__.constructor.call(this, options);
    }

    BufferInStream.prototype._read = function(sz) {
      var n, push_me;
      push_me = null;
      if (this.buf.length > 0) {
        n = Math.min(sz, this.buf.length);
        push_me = this.buf.slice(0, n);
        this.buf = this.buf.slice(n);
      }
      this.push(push_me);
      return true;
    };

    BufferInStream.prototype.is_readable = function() {
      return true;
    };

    BufferInStream.prototype.is_writable = function() {
      return false;
    };

    return BufferInStream;

  })(stream.Readable);

  exports.BufferOutStream = BufferOutStream = (function(_super) {
    __extends(BufferOutStream, _super);

    function BufferOutStream(options) {
      this._v = [];
      BufferOutStream.__super__.constructor.call(this, options);
    }

    BufferOutStream.prototype._write = function(dat, encoding, cb) {
      this._v.push(dat);
      return cb();
    };

    BufferOutStream.prototype.data = function() {
      return Buffer.concat(this._v);
    };

    BufferOutStream.prototype.is_readable = function() {
      return false;
    };

    BufferOutStream.prototype.is_writable = function() {
      return true;
    };

    return BufferOutStream;

  })(stream.Writable);

  exports.FnOutStream = FnOutStream = (function(_super) {
    __extends(FnOutStream, _super);

    function FnOutStream(fn, options) {
      this.fn = fn;
      FnOutStream.__super__.constructor.call(this, options);
    }

    FnOutStream.prototype._write = function(dat, encoding, cb) {
      this.fn(dat);
      return cb();
    };

    FnOutStream.prototype.is_readable = function() {
      return false;
    };

    FnOutStream.prototype.is_writable = function() {
      return true;
    };

    return FnOutStream;

  })(stream.Writable);

  exports.grep = function(_arg) {
    var buffer, line, lines, out, pattern;
    pattern = _arg.pattern, buffer = _arg.buffer;
    lines = buffer.toString('utf8').split('\n');
    out = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = lines.length; _i < _len; _i++) {
        line = lines[_i];
        if (line.match(pattern)) {
          _results.push(line);
        }
      }
      return _results;
    })();
    return out;
  };

}).call(this);
