// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var SlicerBuffer;

  SlicerBuffer = (function() {
    function SlicerBuffer(buf, start) {
      this.buf = buf;
      this.start = start != null ? start : 0;
      if (!Buffer.isBuffer(this.buf)) {
        throw new Error('need a Buffer!');
      }
      this.i = this.start;
      this._end = null;
    }

    SlicerBuffer.prototype.clamp = function(len) {
      var ret;
      ret = this._end;
      this._end = this.i + len;
      return ret;
    };

    SlicerBuffer.prototype.unclamp = function(e) {
      this.start = this.i;
      return this._end = e;
    };

    SlicerBuffer.prototype.len = function() {
      return this.buf.length - this.start;
    };

    SlicerBuffer.prototype.rem = function() {
      return this.buf.length - this.i;
    };

    SlicerBuffer.prototype.offset = function() {
      return this.i - this.start;
    };

    SlicerBuffer.prototype.check = function() {
      if ((this._end && this.i > this._end) || (this.i > this.buf.length)) {
        throw new Error("read off the end of the packet @" + this.i + "/" + this.buf.length + "/" + this._end);
      }
    };

    SlicerBuffer.prototype.read_uint8 = function() {
      var ret;
      ret = this.buf.readUInt8(this.i++);
      this.check();
      return ret;
    };

    SlicerBuffer.prototype.read_uint16 = function() {
      var ret;
      ret = this.buf.readUInt16BE(this.i);
      this.i += 2;
      this.check();
      return ret;
    };

    SlicerBuffer.prototype.read_uint32 = function() {
      var ret;
      ret = this.buf.readUInt32BE(this.i);
      this.i += 4;
      this.check();
      return ret;
    };

    SlicerBuffer.prototype.read_buffer_at_most = function(l) {
      return this.read_buffer(Math.min(l, this.rem()));
    };

    SlicerBuffer.prototype.read_buffer = function(l) {
      var ret;
      ret = this.buf.slice(this.i, this.i + l);
      this.i += l;
      this.check();
      return ret;
    };

    SlicerBuffer.prototype.end = function() {
      return this._end || this.buf.length;
    };

    SlicerBuffer.prototype.peek_rest_to_buffer = function() {
      return this.buf.slice(this.i, this.end());
    };

    SlicerBuffer.prototype.consume_rest_to_buffer = function() {
      var ret;
      ret = this.peek_rest_to_buffer();
      this.i = this.end();
      return ret;
    };

    SlicerBuffer.prototype.advance = function(i) {
      if (i == null) {
        i = 1;
      }
      return this.i += i;
    };

    SlicerBuffer.prototype.peek_to_buffer = function(len) {
      return this.buf.slice(this.i, this.i + len);
    };

    SlicerBuffer.prototype.peek_uint8 = function() {
      return this.buf.readUInt8(this.i);
    };

    SlicerBuffer.prototype.peek_uint16 = function() {
      return this.buf.readUInt16BE(this.i);
    };

    SlicerBuffer.prototype.read_string = function() {
      return this.read_buffer(this.read_uint8());
    };

    SlicerBuffer.prototype.read_v4_length = function() {
      var five_byte, len, p;
      p = this.peek_uint8();
      five_byte = false;
      len = p < 192 ? (this.advance(1), p) : p < 224 ? this.read_uint16() - (192 << 8) + 192 : p < 0xff ? (this.advance(1), 1 << (p & 0x1f)) : (this.advance(1), five_byte = true, this.read_uint32());
      return [len, five_byte];
    };

    return SlicerBuffer;

  })();

  exports.SlicerBuffer = SlicerBuffer;

}).call(this);
