// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var AnnouncementSigGen, BaseSigGen, CoinbaseProofGen, CryptocurrencySigGen, DnsProofGen, E, GenericWebSiteProofGen, GithubProofGen, HackerNewsProofGen, KeybaseProofGen, KeybasePushProofGen, RedditProofGen, RevokeProofSigGen, SignatureEngine, SocialNetworkProofGen, TrackerProofGen, TwitterProofGen, UntrackerProofGen, colors, constants, decode, env, iced, log, make_esc, master_ring, proofs, req, scrapers, session, strip_at, url_reencode, urlmod, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  proofs = require('keybase-proofs');

  make_esc = require('iced-error').make_esc;

  req = require('./req');

  constants = require('./constants').constants;

  session = require('./session');

  env = require('./env').env;

  log = require('./log');

  master_ring = require('./keyring').master_ring;

  decode = require('pgp-utils').armor.decode;

  colors = require('./colors');

  E = require('./err').E;

  req = require('./req');

  urlmod = require('url');

  scrapers = require('./scrapers');

  url_reencode = function(url) {
    var pad2;
    pad2 = function(x) {
      if (x.length === 1) {
        return "0" + x;
      } else {
        return x;
      }
    };
    return url.replace(/%20/g, '+').replace(/[()']/g, function(c) {
      return "%" + pad2(c.charCodeAt(0).toString(16));
    });
  };

  BaseSigGen = (function() {
    function BaseSigGen(_arg) {
      this.km = _arg.km, this.eldest_kid = _arg.eldest_kid, this.client = _arg.client, this.supersede = _arg.supersede, this.merkle_root = _arg.merkle_root, this.revoke_sig_ids = _arg.revoke_sig_ids;
    }

    BaseSigGen.prototype._get_seqno_type = function() {
      return "PUBLIC";
    };

    BaseSigGen.prototype._get_announce_number = function(cb) {
      var body, err, type, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      type = this._get_seqno_type();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "BaseSigGen._get_announce_number"
          });
          req.get({
            endpoint: "sig/next_seqno",
            args: {
              type: type
            }
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 40
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this.seqno = body.seqno;
            _this.prev = body.prev;
          }
          return cb(err);
        };
      })(this));
    };

    BaseSigGen.prototype._get_binding_eng = function() {
      var arg, sig_ids;
      arg = {
        sig_eng: new SignatureEngine({
          km: this.km
        }),
        seqno: this.seqno,
        prev: this.prev,
        host: constants.canonical_host,
        user: {
          local: {
            uid: session.get_uid(),
            username: env().get_username()
          }
        },
        client: this.client,
        merkle_root: this.merkle_root,
        eldest_kid: this.eldest_kid
      };
      if ((sig_ids = this.revoke_sig_ids) != null) {
        arg.revoke = {
          sig_ids: sig_ids
        };
      }
      return this._make_binding_eng(arg);
    };

    BaseSigGen.prototype._do_signature = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      this.eng = this._get_binding_eng();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "BaseSigGen._do_signature"
          });
          _this.eng.generate(__iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.sig = arguments[1];
              };
            })(_this),
            lineno: 70
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    BaseSigGen.prototype._v_modify_store_arg = function(arg) {};

    BaseSigGen.prototype._get_api_endpoint = function() {
      return "sig/post";
    };

    BaseSigGen.prototype.expect_proof_text = function() {
      return false;
    };

    BaseSigGen.prototype._store_signature = function(cb) {
      var args, body, endpoint, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = {
        sig: this.sig.pgp,
        sig_id_base: this.sig.id,
        sig_id_short: this.sig.short_id,
        is_remote_proof: true,
        supersede: this.supersede
      };
      this._v_modify_store_arg(args);
      endpoint = this._get_api_endpoint();
      log.debug("+ storing signature:");
      log.debug("| writing to " + endpoint);
      log.debug("| with args " + (JSON.stringify(args)));
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "BaseSigGen._store_signature"
          });
          req.post({
            need_cookie: true,
            endpoint: endpoint,
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 97
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this.proof_text = body.proof_text, _this.proof_id = body.proof_id, _this.sig_id = body.sig_id, _this.proof_metadata = body.proof_metadata;
            log.debug("| reply with value: " + (JSON.stringify(body)));
          }
          (function(__iced_k) {
            if (!(typeof err !== "undefined" && err !== null) && _this.expect_proof_text()) {
              (function(__iced_k) {
                if (_this.proof_text == null) {
                  return __iced_k(err = new Error("Server didn't reply with proof text"));
                } else {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/sigs.iced",
                      funcname: "BaseSigGen._store_signature"
                    });
                    _this.eng.sanity_check_proof_text({
                      args: args,
                      proof_text: _this.proof_text
                    }, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          return err = arguments[0];
                        };
                      })(),
                      lineno: 107
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    return __iced_k(err != null ? log.warn("Server replied with a suspect proof text") : void 0);
                  });
                }
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            log.debug("- stored signature (err = " + (typeof err !== "undefined" && err !== null ? err.message : void 0) + ")");
            return cb(err);
          });
        };
      })(this));
    };

    BaseSigGen.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "BaseSigGen::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "BaseSigGen.run"
          });
          _this._get_announce_number(esc(__iced_deferrals.defer({
            lineno: 118
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/jacko/node-client/src/sigs.iced",
              funcname: "BaseSigGen.run"
            });
            _this._do_signature(esc(__iced_deferrals.defer({
              lineno: 119
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/sigs.iced",
                funcname: "BaseSigGen.run"
              });
              _this._store_signature(esc(__iced_deferrals.defer({
                lineno: 120
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null, _this.sig);
            });
          });
        };
      })(this));
    };

    BaseSigGen.prototype.normalize_name = function(n, cb) {
      var klass, ret;
      klass = this._binding_klass();
      ret = klass.normalize_name(n);
      return cb(null, ret);
    };

    BaseSigGen.prototype.show_proof_text = function() {
      return this.proof_text;
    };

    BaseSigGen.prototype.check_name = function(s) {
      return this._binding_klass().check_name(s);
    };

    BaseSigGen.prototype.check_name_input = function(s) {
      return this.check_name(s);
    };

    BaseSigGen.prototype.single_occupancy = function() {
      return this._binding_klass().single_occupancy();
    };

    BaseSigGen.prototype.get_warnings = function(_arg) {
      _arg;
      return [];
    };

    BaseSigGen.prototype.do_recheck = function(i) {
      return true;
    };

    BaseSigGen.prototype.do_precheck = function(_arg, cb) {
      var remote_name_normalized;
      remote_name_normalized = _arg.remote_name_normalized;
      return cb(null);
    };

    BaseSigGen.prototype.make_retry_msg = function(code) {
      return "Didn't find the posted proof.";
    };

    return BaseSigGen;

  })();

  exports.KeybaseProofGen = KeybaseProofGen = (function(_super) {
    __extends(KeybaseProofGen, _super);

    function KeybaseProofGen() {
      return KeybaseProofGen.__super__.constructor.apply(this, arguments);
    }

    KeybaseProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.type = "web_service_binding.keybase";
      return arg.is_remote_proof = false;
    };

    KeybaseProofGen.prototype._make_binding_eng = function(arg) {
      return new proofs.KeybaseBinding(arg);
    };

    return KeybaseProofGen;

  })(BaseSigGen);

  exports.KeybasePushProofGen = KeybasePushProofGen = (function(_super) {
    __extends(KeybasePushProofGen, _super);

    function KeybasePushProofGen() {
      return KeybasePushProofGen.__super__.constructor.apply(this, arguments);
    }

    KeybasePushProofGen.prototype._store_signature = function(cb) {
      return cb(null);
    };

    KeybasePushProofGen.prototype._make_binding_eng = function(arg) {
      return new proofs.KeybaseBinding(arg);
    };

    return KeybasePushProofGen;

  })(BaseSigGen);

  exports.CryptocurrencySigGen = CryptocurrencySigGen = (function(_super) {
    __extends(CryptocurrencySigGen, _super);

    function CryptocurrencySigGen(args) {
      this.cryptocurrency = args.cryptocurrency;
      CryptocurrencySigGen.__super__.constructor.call(this, args);
    }

    CryptocurrencySigGen.prototype._make_binding_eng = function(arg) {
      arg.cryptocurrency = this.cryptocurrency;
      return new proofs.Cryptocurrency(arg);
    };

    CryptocurrencySigGen.prototype._v_modify_store_arg = function(arg) {
      arg.type = "cryptocurrency";
      return arg.is_remote_proof = false;
    };

    return CryptocurrencySigGen;

  })(BaseSigGen);

  exports.AnnouncementSigGen = AnnouncementSigGen = (function(_super) {
    __extends(AnnouncementSigGen, _super);

    function AnnouncementSigGen(args) {
      this.announcement = args.announcement;
      AnnouncementSigGen.__super__.constructor.call(this, args);
    }

    AnnouncementSigGen.prototype._make_binding_eng = function(arg) {
      arg.announcement = this.announcement;
      return new proofs.Announcement(arg);
    };

    AnnouncementSigGen.prototype._v_modify_store_arg = function(arg) {
      arg.type = "announcement";
      return arg.is_remote_proof = false;
    };

    return AnnouncementSigGen;

  })(BaseSigGen);

  exports.TrackerProofGen = TrackerProofGen = (function(_super) {
    __extends(TrackerProofGen, _super);

    function TrackerProofGen(args) {
      this.prev = args.prev, this.seqno = args.seqno, this.uid = args.uid, this.track = args.track;
      TrackerProofGen.__super__.constructor.call(this, args);
    }

    TrackerProofGen.prototype._get_announce_number = function(cb) {
      return cb(null);
    };

    TrackerProofGen.prototype._make_binding_eng = function(arg) {
      arg.track = this.track;
      return new proofs.Track(arg);
    };

    TrackerProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.uid = this.uid;
      return arg.type = "track";
    };

    TrackerProofGen.prototype._get_api_endpoint = function() {
      return "follow";
    };

    return TrackerProofGen;

  })(BaseSigGen);

  exports.UntrackerProofGen = UntrackerProofGen = (function(_super) {
    __extends(UntrackerProofGen, _super);

    function UntrackerProofGen(args) {
      this.uid = args.uid, this.untrack = args.untrack, this.seqno = args.seqno, this.prev = args.prev;
      UntrackerProofGen.__super__.constructor.call(this, args);
    }

    UntrackerProofGen.prototype._get_announce_number = function(cb) {
      return cb(null);
    };

    UntrackerProofGen.prototype._make_binding_eng = function(arg) {
      arg.untrack = this.untrack;
      return new proofs.Untrack(arg);
    };

    UntrackerProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.uid = this.uid;
      return arg.type = "untrack";
    };

    UntrackerProofGen.prototype._get_api_endpoint = function() {
      return "follow";
    };

    return UntrackerProofGen;

  })(BaseSigGen);

  strip_at = function(x) {
    if ((x != null) && x.length && x[0] === '@') {
      return x.slice(1);
    } else {
      return x;
    }
  };

  SocialNetworkProofGen = (function(_super) {
    __extends(SocialNetworkProofGen, _super);

    function SocialNetworkProofGen(args) {
      this.remote_username = args.remote_name_normalized;
      SocialNetworkProofGen.__super__.constructor.call(this, args);
    }

    SocialNetworkProofGen.prototype._make_binding_eng = function(args) {
      var klass;
      args.user.remote = this.remote_username;
      klass = this._binding_klass();
      return new klass(args);
    };

    SocialNetworkProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.remote_username = this.remote_username;
      return arg.type = "web_service_binding." + this._remote_service_name();
    };

    SocialNetworkProofGen.prototype.get_prompt = function() {
      return "Your username on " + (this.display_name());
    };

    SocialNetworkProofGen.prototype.prompter = function() {
      var klass, ret;
      klass = this._binding_klass();
      ret = {
        prompt: this.get_prompt(),
        checker: {
          f: klass.check_name,
          hint: klass.name_hint(),
          normalize: klass.normalize_name
        }
      };
      return ret;
    };

    SocialNetworkProofGen.prototype.expect_proof_text = function() {
      return true;
    };

    return SocialNetworkProofGen;

  })(BaseSigGen);

  exports.RevokeProofSigGen = RevokeProofSigGen = (function(_super) {
    __extends(RevokeProofSigGen, _super);

    function RevokeProofSigGen(args) {
      this.revoke_sig_id = args.sig_id;
      RevokeProofSigGen.__super__.constructor.call(this, args);
    }

    RevokeProofSigGen.prototype._make_binding_eng = function(args) {
      args.revoke = {
        sig_id: this.revoke_sig_id
      };
      return new proofs.Revoke(args);
    };

    RevokeProofSigGen.prototype._v_modify_store_arg = function(arg) {
      return arg.revoke_sig_id = this.revoke_sig_id;
    };

    RevokeProofSigGen.prototype._get_api_endpoint = function() {
      return "sig/revoke";
    };

    return RevokeProofSigGen;

  })(BaseSigGen);

  exports.DnsProofGen = DnsProofGen = (function(_super) {
    __extends(DnsProofGen, _super);

    DnsProofGen.prototype._binding_klass = function() {
      return proofs.DnsBinding;
    };

    function DnsProofGen(args) {
      this.remote_host = args.remote_name_normalized;
      DnsProofGen.__super__.constructor.call(this, args);
    }

    DnsProofGen.prototype._make_binding_eng = function(args) {
      var klass;
      args.remote_host = this.remote_host;
      klass = this._binding_klass();
      return new klass(args);
    };

    DnsProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.remote_host = this.remote_host;
      return arg.type = "web_service_binding.dns";
    };

    DnsProofGen.prototype.instructions = function() {
      var h, hosts, search;
      search = [this.remote_host, ["_keybase", this.remote_host].join(".")];
      hosts = ((function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = search.length; _i < _len; _i++) {
          h = search[_i];
          _results.push(colors.bold(h));
        }
        return _results;
      })()).join(" OR ");
      return "Please save the following as a DNS TXT entry for " + hosts;
    };

    DnsProofGen.prototype.display_name = function() {
      return this.remote_host;
    };

    DnsProofGen.prototype.prompter = function() {
      var klass;
      klass = this._binding_klass();
      return {
        prompt: "DNS Domain to check",
        checker: {
          f: (function(_this) {
            return function(i) {
              return _this.check_name_input(i);
            };
          })(this),
          hint: klass.name_hint()
        }
      };
    };

    DnsProofGen.prototype.check_name_input = function(i) {
      return this._binding_klass().check_name(i);
    };

    DnsProofGen.prototype.normalize_name = function(i, cb) {
      var err, u;
      u = this._binding_klass().parse(i);
      if (u == null) {
        err = new E.ArgsError("Failed to parse " + i + " as a DNS domain");
      }
      return cb(err, u);
    };

    DnsProofGen.prototype.do_recheck = function(i) {
      log.info("We couldn't find a DNS proof for " + this.remote_host + "....." + (colors.bold('yet')));
      log.info("DNS propagation can be slow; we'll keep trying and email you the result.");
      return false;
    };

    return DnsProofGen;

  })(BaseSigGen);

  exports.GenericWebSiteProofGen = GenericWebSiteProofGen = (function(_super) {
    __extends(GenericWebSiteProofGen, _super);

    GenericWebSiteProofGen.prototype._binding_klass = function() {
      return proofs.GenericWebSiteBinding;
    };

    function GenericWebSiteProofGen(args) {
      this.remote_host = args.remote_name_normalized;
      GenericWebSiteProofGen.__super__.constructor.call(this, args);
    }

    GenericWebSiteProofGen.prototype._make_binding_eng = function(args) {
      var klass;
      args.remote_host = this.remote_host;
      klass = this._binding_klass();
      return new klass(args);
    };

    GenericWebSiteProofGen.prototype._v_modify_store_arg = function(arg) {
      arg.remote_host = this.remote_host;
      return arg.type = "web_service_binding.generic";
    };

    GenericWebSiteProofGen.prototype.styled_filenames = function(h) {
      var f, files;
      files = this.filenames(h);
      return ((function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = files.length; _i < _len; _i++) {
          f = files[_i];
          _results.push(colors.bold(f));
        }
        return _results;
      })()).join("\n  or ");
    };

    GenericWebSiteProofGen.prototype.instructions = function() {
      return "Please save the following file as " + (this.styled_filenames());
    };

    GenericWebSiteProofGen.prototype.display_name = function() {
      return this.filenames().join(' OR ');
    };

    GenericWebSiteProofGen.prototype.filenames = function(h) {
      var f, files, _i, _len, _results;
      files = proofs.GenericWebSiteScraper.FILES;
      _results = [];
      for (_i = 0, _len = files.length; _i < _len; _i++) {
        f = files[_i];
        _results.push((h || this.remote_host) + "/" + f);
      }
      return _results;
    };

    GenericWebSiteProofGen.prototype.prompter = function() {
      var klass;
      klass = this._binding_klass();
      return {
        prompt: "Hostname to check",
        checker: {
          f: (function(_this) {
            return function(i) {
              return _this.check_name_input(i);
            };
          })(this),
          hint: klass.name_hint()
        }
      };
    };

    GenericWebSiteProofGen.prototype.rewrite_hostname = function(i) {
      if (!i.match(/^https?:\/\//)) {
        i = "https://" + i;
      }
      return i;
    };

    GenericWebSiteProofGen.prototype.check_name_input = function(i) {
      return this._binding_klass().check_name(this.rewrite_hostname(i));
    };

    GenericWebSiteProofGen.prototype.get_warnings = function(_arg) {
      var remote_name_normalized;
      remote_name_normalized = _arg.remote_name_normalized;
      return ["You'll be asked to post a file available at", "     " + this.styled_filenames(remote_name_normalized)];
    };

    GenericWebSiteProofGen.prototype.normalize_name = function(i, cb) {
      var args, err, hostname, n, protocol, res, ret, u, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      n = this.rewrite_hostname(i);
      u = this._binding_klass().parse(n);
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          if (u == null) {
            return __iced_k(err = new E.ArgsError("Failed to parse " + i + " is a valid internet host"));
          } else {
            hostname = u.hostname;
            args = {
              endpoint: "remotes/check",
              args: {
                hostname: hostname
              }
            };
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/sigs.iced",
                funcname: "GenericWebSiteProofGen.normalize_name"
              });
              req.get(args, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return res = arguments[1];
                  };
                })(),
                lineno: 414
              }));
              __iced_deferrals._fulfill();
            })(function() {
              var _ref;
              return __iced_k(err != null ? void 0 : (protocol = typeof res !== "undefined" && res !== null ? (_ref = res.results) != null ? _ref.first : void 0 : void 0) == null ? err = new E.HostError("Host " + n + " is down; tried 'http' and 'https' protocols") : i.match(/^https:\/\//) && (protocol !== 'https:') ? err = new E.SecurityError("You specified HTTPS for " + i + " but only HTTP is available") : ret = urlmod.format({
                protocol: protocol,
                hostname: hostname
              }));
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, ret);
        };
      })(this));
    };

    GenericWebSiteProofGen.prototype.expect_proof_text = function() {
      return true;
    };

    return GenericWebSiteProofGen;

  })(BaseSigGen);

  exports.TwitterProofGen = TwitterProofGen = (function(_super) {
    __extends(TwitterProofGen, _super);

    function TwitterProofGen() {
      return TwitterProofGen.__super__.constructor.apply(this, arguments);
    }

    TwitterProofGen.prototype._binding_klass = function() {
      return proofs.TwitterBinding;
    };

    TwitterProofGen.prototype._remote_service_name = function() {
      return "twitter";
    };

    TwitterProofGen.prototype.imperative_verb = function() {
      return "tweet";
    };

    TwitterProofGen.prototype.display_name = function() {
      return "Twitter";
    };

    TwitterProofGen.prototype.instructions = function() {
      return "Please " + (colors.bold('publicly')) + " tweet the following:";
    };

    TwitterProofGen.prototype.make_retry_msg = function(status) {
      switch (status) {
        case proofs.constants.v_codes.PERMISSION_DENIED:
          return "Permission denied! We can't support private feeds.";
        default:
          return TwitterProofGen.__super__.make_retry_msg.call(this);
      }
    };

    return TwitterProofGen;

  })(SocialNetworkProofGen);

  exports.RedditProofGen = RedditProofGen = (function(_super) {
    __extends(RedditProofGen, _super);

    function RedditProofGen() {
      return RedditProofGen.__super__.constructor.apply(this, arguments);
    }

    RedditProofGen.prototype._binding_klass = function() {
      return proofs.RedditBinding;
    };

    RedditProofGen.prototype._remote_service_name = function() {
      return "reddit";
    };

    RedditProofGen.prototype.imperative_verb = function() {
      return "post";
    };

    RedditProofGen.prototype.display_name = function() {
      return "Reddit";
    };

    RedditProofGen.prototype.instructions = function() {
      return "Please click on the following link to post to Reddit:";
    };

    RedditProofGen.prototype.show_proof_text = function() {
      var body, title;
      body = this.proof_text;
      title = this.proof_metadata.title;
      return url_reencode(urlmod.format({
        protocol: "https",
        host: "www.reddit.com",
        pathname: "/r/KeybaseProofs/submit",
        query: {
          title: this.proof_metadata.title,
          text: this.proof_text
        }
      }));
    };

    return RedditProofGen;

  })(SocialNetworkProofGen);

  exports.GithubProofGen = GithubProofGen = (function(_super) {
    __extends(GithubProofGen, _super);

    function GithubProofGen() {
      return GithubProofGen.__super__.constructor.apply(this, arguments);
    }

    GithubProofGen.prototype._binding_klass = function() {
      return proofs.GithubBinding;
    };

    GithubProofGen.prototype._remote_service_name = function() {
      return "github";
    };

    GithubProofGen.prototype.imperative_verb = function() {
      return "post a Gist with";
    };

    GithubProofGen.prototype.display_name = function() {
      return "GitHub";
    };

    GithubProofGen.prototype.instructions = function() {
      return "Please " + (colors.bold('publicly')) + " post the following Gist, and name it " + (colors.bold(colors.red('keybase.md'))) + ":";
    };

    GithubProofGen.prototype.make_retry_msg = function(status) {
      switch (status) {
        case proofs.constants.v_codes.PERMISSION_DENIED:
          return "Permission denied! Make sure your Gist is public";
        default:
          return GithubProofGen.__super__.make_retry_msg.call(this);
      }
    };

    return GithubProofGen;

  })(SocialNetworkProofGen);

  exports.HackerNewsProofGen = HackerNewsProofGen = (function(_super) {
    __extends(HackerNewsProofGen, _super);

    function HackerNewsProofGen() {
      return HackerNewsProofGen.__super__.constructor.apply(this, arguments);
    }

    HackerNewsProofGen.prototype._binding_klass = function() {
      return proofs.HackerNewsBinding;
    };

    HackerNewsProofGen.prototype._remote_service_name = function() {
      return "hackernews";
    };

    HackerNewsProofGen.prototype.imperative_verb = function() {
      return "update your profile with";
    };

    HackerNewsProofGen.prototype.display_name = function() {
      return "HackerNews";
    };

    HackerNewsProofGen.prototype.instructions = function() {
      return "Please edit your HackerNews profile to contain the following text. Click here: https://news.ycombinator.com/user?id=" + this.remote_username;
    };

    HackerNewsProofGen.prototype.do_recheck = function(i) {
      log.info("We couldn't find a posted proof for " + this.remote_username + "....." + (colors.bold('yet')));
      if (i < 3) {
        log.info("HackerNews's API is slow to update, so be patient...try again?");
        return true;
      } else {
        log.info("We'll keep trying and let you know!");
        return false;
      }
    };

    HackerNewsProofGen.prototype.get_warnings = function(_arg) {
      var remote_name_normalized;
      remote_name_normalized = _arg.remote_name_normalized;
      return [];
    };

    HackerNewsProofGen.prototype.do_precheck = function(_arg, cb) {
      var err, json, remote_name_normalized, scraper, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      remote_name_normalized = _arg.remote_name_normalized;
      scraper = (new scrapers.HackerNews).make_scraper();
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "HackerNewsProofGen.do_precheck"
          });
          scraper.get_karma(remote_name_normalized, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return json = arguments[1];
              };
            })(),
            lineno: 504
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {

          } else if (!(typeof json !== "undefined" && json !== null)) {
            log.warn("" + (colors.bold("ATTENTION")) + ": HackerNews only publishes users to their API with " + (colors.bold("karma > 1")) + ".");
            log.warn("Your account " + (colors.bold(remote_name_normalized)) + " doesn't qualify, or doesn't exist!");
            err = new E.KarmaError("Insufficient HackerNews karma (>= 2 needed) or bad username (case sensitive!)");
          }
          return cb(err);
        };
      })(this));
    };

    HackerNewsProofGen.prototype.get_prompt = function() {
      return "Your username on " + (this.display_name()) + " (**case sensitive**)";
    };

    return HackerNewsProofGen;

  })(SocialNetworkProofGen);

  exports.CoinbaseProofGen = CoinbaseProofGen = (function(_super) {
    __extends(CoinbaseProofGen, _super);

    function CoinbaseProofGen() {
      return CoinbaseProofGen.__super__.constructor.apply(this, arguments);
    }

    CoinbaseProofGen.prototype._binding_klass = function() {
      return proofs.CoinbaseBinding;
    };

    CoinbaseProofGen.prototype._remote_service_name = function() {
      return "coinbase";
    };

    CoinbaseProofGen.prototype.imperative_verb = function() {
      return "update your Coinbase profile with";
    };

    CoinbaseProofGen.prototype.display_name = function() {
      return "coinbase";
    };

    CoinbaseProofGen.prototype.instructions = function() {
      return "Please update your Coinbase profile to show this proof. Click here: https://coinbase.com/" + this.remote_username + "/public-key";
    };

    return CoinbaseProofGen;

  })(SocialNetworkProofGen);

  exports.SignatureEngine = SignatureEngine = (function() {
    function SignatureEngine(_arg) {
      this.km = _arg.km;
    }

    SignatureEngine.prototype.get_km = function() {
      return this.km;
    };

    SignatureEngine.prototype.box = function(msg, cb) {
      var arg, err, out, pgp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      out = {};
      arg = {
        stdin: new Buffer(msg, 'utf8'),
        args: ["-u", this.km.get_pgp_key_id(), "--sign", "-a", "--keyid-format", "long"],
        quiet: true
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/sigs.iced",
            funcname: "SignatureEngine.box"
          });
          master_ring().gpg(arg, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return pgp = arguments[1];
              };
            })(),
            lineno: 544
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          var _ref;
          if (typeof err === "undefined" || err === null) {
            out.pgp = pgp = pgp.toString('utf8');
            _ref = decode(pgp), err = _ref[0], msg = _ref[1];
            if (err == null) {
              out.raw = msg.body;
            }
          }
          return cb(err, out);
        };
      })(this));
    };

    return SignatureEngine;

  })();

}).call(this);
