// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, E, PackageJson, a_json_parse, add_option_dict, convert, env, gpg, iced, log, urlmod, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  gpg = require('gpg-wrapper').gpg;

  E = require('../err').E;

  env = require('../env').env;

  a_json_parse = require('iced-utils').util.a_json_parse;

  urlmod = require('url');

  convert = function(s) {
    var i;
    if (s == null) {
      return null;
    } else if (s === 'true') {
      return true;
    } else if (s === 'false') {
      return false;
    } else if (s.match(/^[0-9]+$/) && !(isNaN(i = parseInt(s, 10)))) {
      return i;
    } else {
      return s;
    }
  };

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      get: {
        help: "Read the given configuration option"
      },
      j: {
        alias: 'json',
        help: 'interpret the value as JSON',
        action: 'storeTrue'
      },
      pretty: {
        help: "pretty-print JSON",
        action: 'storeTrue'
      },
      s: {
        alias: "server",
        help: "specify which server to use"
      },
      S: {
        alias: "reset-server",
        help: "reset the server to default",
        action: 'storeTrue'
      }
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: [],
        help: "make an initial configuration file"
      };
      name = "config";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      sub.addArgument(["kvs"], {
        nargs: "*"
      });
      return opts.aliases.concat([name]);
    };

    Command.prototype.config_opts = function() {
      return {
        quiet: true
      };
    };

    Command.prototype.use_gpg = function() {
      return false;
    };

    Command.prototype.run = function(cb) {
      var c, err, h, k, msg, p, pjs, s, url, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      c = env().config;
      (function(_this) {
        return (function(__iced_k) {
          if ((k = _this.argv.get) != null) {
            return __iced_k(console.log(JSON.stringify(c.get(k), null, (_this.argv.pretty ? "    " : null))));
          } else {
            (function(__iced_k) {
              if ((s = _this.argv.server) != null) {
                return __iced_k((url = urlmod.parse(s)) != null ? (url.protocol === "http:" ? c.set("server.no_tls", true) : void 0, (p = url.port) != null ? c.set("server.port", parseInt(p, 10)) : void 0, (h = url.hostname) != null ? c.set("server.host", h) : void 0) : (msg = "Couldn't parse server URL " + url, log.error(msg), err = new E.ArgsError(msg)));
              } else {
                (function(__iced_k) {
                  if (_this.argv.reset_server) {
                    return __iced_k(c.set("server", null));
                  } else {
                    (function(__iced_k) {
                      if (_this.argv.kvs.length > 2) {
                        msg = "Need either 0,1 or 2 arguments for setting values in config";
                        log.error("Usage: " + msg);
                        return __iced_k(err = new E.ArgsError(msg));
                      } else {
                        (function(__iced_k) {
                          if (_this.argv.kvs.length > 0) {
                            k = _this.argv.kvs[0];
                            (function(__iced_k) {
                              if (_this.argv.json && (_this.argv.kvs.length === 2)) {
                                (function(__iced_k) {
                                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/max/src/keybase/node-client/src/command/config.iced",
                                    funcname: "Command.run"
                                  });
                                  a_json_parse(_this.argv.kvs[1], __iced_deferrals.defer({
                                    assign_fn: (function() {
                                      return function() {
                                        err = arguments[0];
                                        return v = arguments[1];
                                      };
                                    })(),
                                    lineno: 86
                                  }));
                                  __iced_deferrals._fulfill();
                                })(__iced_k);
                              } else {
                                return __iced_k(v = convert(_this.argv.kvs.length === 2 ? _this.argv.kvs[1] : null));
                              }
                            })(function() {
                              return __iced_k(err == null ? c.set(k, v) : void 0);
                            });
                          } else {
                            return __iced_k(c.is_empty() ? (pjs = new PackageJson(), c.set("generated", {
                              by: "keybase v" + (pjs.version()),
                              on: (new Date()).toString()
                            })) : log.warn("keybase has already been initialized; see '" + c.filename + "'"));
                          }
                        })(__iced_k);
                      }
                    })(__iced_k);
                  }
                })(__iced_k);
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (!err && c.is_dirty()) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/config.iced",
                  funcname: "Command.run"
                });
                c.write(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 99
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err);
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
