/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.Parser;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.FunctionCall;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class JavaFunction
extends Expression
implements FunctionCall {
    private FunctionAlias functionAlias;
    private FunctionAlias.JavaMethod javaMethod;
    private Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] expressionArray) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(expressionArray);
        this.args = expressionArray;
    }

    public Value getValue(Session session) {
        return this.javaMethod.getValue(session, this.args, false);
    }

    public int getType() {
        return this.javaMethod.getDataType();
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.args) {
            expression.mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) {
        boolean bl = this.isDeterministic();
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            Expression expression;
            this.args[i] = expression = this.args[i].optimize(session);
            bl &= expression.isConstant();
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    public int getScale() {
        return DataType.getDataType((int)this.getType()).defaultScale;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        if (this.functionAlias.getDatabase().getSettings().functionsInSchema || !this.functionAlias.getSchema().getName().equals("PUBLIC")) {
            statementBuilder.append(Parser.quoteIdentifier(this.functionAlias.getSchema().getName())).append('.');
        }
        statementBuilder.append(Parser.quoteIdentifier(this.functionAlias.getName())).append('(');
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public void updateAggregate(Session session) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public String getName() {
        return this.functionAlias.getName();
    }

    public int getParameterCount() {
        return this.javaMethod.getParameterCount();
    }

    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        Value value = this.javaMethod.getValue(session, expressionArray, true);
        return value == ValueNull.INSTANCE ? null : (ValueResultSet)value;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                if (this.isDeterministic()) break;
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.functionAlias);
                break;
            }
        }
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public int getCost() {
        int n = this.javaMethod.hasConnectionParam() ? 25 : 5;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        return n;
    }

    public boolean isDeterministic() {
        return this.functionAlias.isDeterministic();
    }

    public Expression[] getExpressionColumns(Session session) {
        switch (this.getType()) {
            case 18: {
                ValueResultSet valueResultSet = this.getValueForColumnList(session, this.getArgs());
                return JavaFunction.getExpressionColumns(session, valueResultSet.getResultSet());
            }
            case 17: {
                return JavaFunction.getExpressionColumns(session, (ValueArray)this.getValue(session));
            }
        }
        return super.getExpressionColumns(session);
    }
}

