/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public abstract class AbstractStripedLockContainer
implements LockContainer {
    private static final Log log = LogFactory.getLog(AbstractStripedLockContainer.class);
    private int lockSegmentMask;
    private int lockSegmentShift;

    final int calculateNumberOfSegments(int concurrencyLevel) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrencyLevel; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        return numLocks;
    }

    final int hashToIndex(Object object) {
        return this.hash(object) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    final int hash(Object object) {
        int h = object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    protected abstract void initLocks(int var1);

    @Override
    public Lock acquireLock(Object key, long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.getLock(key);
        boolean locked = false;
        try {
            locked = lock.tryLock(timeout, unit);
        }
        catch (InterruptedException ie) {
            Util.safeRelease(lock);
            throw ie;
        }
        catch (Throwable th) {
            Util.safeRelease(lock);
            locked = false;
        }
        return locked ? lock : null;
    }

    @Override
    public void releaseLock(Object key) {
        Lock lock = this.getLock(key);
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException imse) {
            log.debug("Attempted to unlock a lock we didn't own - swallowing an IllegalMonitorStateException");
        }
    }

    @Override
    public int getLockId(Object key) {
        return this.hashToIndex(key);
    }
}

