/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Random;
import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareDldGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareGlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.util.ClusterIdGenerator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionFactory {
    private static final Log log = LogFactory.getLog(TransactionFactory.class);
    private TxFactoryEnum txFactoryEnum;
    private EmbeddedCacheManager cm;
    private Configuration configuration;
    private ClusterIdGenerator clusterIdGenerator;
    private boolean isClustered;
    private RpcManager rpcManager;

    public GlobalTransaction newGlobalTransaction() {
        return this.txFactoryEnum.newGlobalTransaction();
    }

    public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
        return this.txFactoryEnum.newGlobalTransaction(addr, remote, this.clusterIdGenerator, this.isClustered);
    }

    public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
        return this.txFactoryEnum.newLocalTransaction(tx, gtx);
    }

    public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        return this.txFactoryEnum.newRemoteTransaction(modifications, tx);
    }

    public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
        return this.txFactoryEnum.newRemoteTransaction(tx);
    }

    @Inject
    public void init(Configuration configuration, EmbeddedCacheManager cm, RpcManager rpcManager) {
        this.cm = cm;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
    }

    @Start
    public void start() {
        boolean dldEnabled = this.configuration.isDeadlockDetectionEnabled();
        boolean xa = !this.configuration.isUseSynchronizationForTransactions();
        boolean recoveryEnabled = this.configuration.isTransactionRecoveryEnabled();
        this.init(dldEnabled, recoveryEnabled, xa);
        this.isClustered = this.configuration.getCacheMode().isClustered();
        if (recoveryEnabled) {
            this.clusterIdGenerator = new ClusterIdGenerator(this.cm, this.rpcManager);
        }
    }

    public void init(boolean dldEnabled, boolean recoveryEnabled, boolean xa) {
        if (dldEnabled && recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_RECOVERY_XA;
        } else if (dldEnabled && !recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_NORECOVERY_XA;
        } else if (dldEnabled && !recoveryEnabled && !xa) {
            this.txFactoryEnum = TxFactoryEnum.DLD_NORECOVERY_NOXA;
        } else if (!dldEnabled && recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_RECOVERY_XA;
        } else if (!dldEnabled && !recoveryEnabled && xa) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_NORECOVERY_XA;
        } else if (!(dldEnabled || recoveryEnabled || xa)) {
            this.txFactoryEnum = TxFactoryEnum.NODLD_NORECOVERY_NOXA;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Setting factory enum to %s", (Object)this.txFactoryEnum);
        }
        if (this.txFactoryEnum == null) {
            log.unsupportedTransactionConfiguration(dldEnabled, recoveryEnabled, xa);
            throw new IllegalStateException(String.format("Unsupported combination (dldEnabled, recoveryEnabled, xa) = (%s, %s, %s)", dldEnabled, recoveryEnabled, xa));
        }
    }

    public static enum TxFactoryEnum {
        DLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new RecoveryAwareLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                RecoveryAwareDldGlobalTransaction dldGlobalTransaction = new RecoveryAwareDldGlobalTransaction(addr, remote);
                dldGlobalTransaction.setInternalId(clusterIdGenerator.newVersion(clustered));
                return this.addCoinToss(dldGlobalTransaction);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareDldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(tx);
            }
        }
        ,
        DLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new LocalXaTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return this.addCoinToss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        DLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new SyncLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return this.addCoinToss(new DldGlobalTransaction(addr, remote));
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new DldGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        NODLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new RecoveryAwareLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                RecoveryAwareGlobalTransaction recoveryAwareGlobalTransaction = new RecoveryAwareGlobalTransaction(addr, remote);
                recoveryAwareGlobalTransaction.setInternalId(clusterIdGenerator.newVersion(clustered));
                return recoveryAwareGlobalTransaction;
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new RecoveryAwareGlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RecoveryAwareRemoteTransaction(tx);
            }
        }
        ,
        NODLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new LocalXaTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        }
        ,
        NODLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx) {
                return new SyncLocalTransaction(tx, gtx);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, ClusterIdGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public GlobalTransaction newGlobalTransaction() {
                return new GlobalTransaction();
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
                return new RemoteTransaction(modifications, tx);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx) {
                return new RemoteTransaction(tx);
            }
        };

        private final Random rnd = new Random();

        public abstract LocalTransaction newLocalTransaction(Transaction var1, GlobalTransaction var2);

        public abstract GlobalTransaction newGlobalTransaction(Address var1, boolean var2, ClusterIdGenerator var3, boolean var4);

        public abstract GlobalTransaction newGlobalTransaction();

        protected long generateRandomId() {
            return this.rnd.nextLong();
        }

        protected GlobalTransaction addCoinToss(DldGlobalTransaction dldGlobalTransaction) {
            dldGlobalTransaction.setCoinToss(this.generateRandomId());
            return dldGlobalTransaction;
        }

        public abstract RemoteTransaction newRemoteTransaction(WriteCommand[] var1, GlobalTransaction var2);

        public abstract RemoteTransaction newRemoteTransaction(GlobalTransaction var1);
    }
}

