/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.Arrays;
import java.util.Random;
import javax.transaction.xa.Xid;
import org.infinispan.util.Util;

public class DummyXid
implements Xid {
    private byte[] globalTransactionId = new byte[64];
    private byte[] branchQualifier = new byte[64];

    @Override
    public int getFormatId() {
        return 1;
    }

    public DummyXid() {
        this.initialize();
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    private void initialize() {
        Random rnd = new Random();
        rnd.nextBytes(this.globalTransactionId);
        rnd.nextBytes(this.branchQualifier);
    }

    public String toString() {
        return "DummyXid{, globalTransactionId = " + Util.printArray(this.globalTransactionId, false) + ", branchQualifier = " + Util.printArray(this.branchQualifier, false) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        if (((Xid)o).getFormatId() != this.getFormatId()) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, other.getBranchQualifier())) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId());
    }

    public int hashCode() {
        int result = this.globalTransactionId != null ? Arrays.hashCode(this.globalTransactionId) : 0;
        result = 31 * result + (this.branchQualifier != null ? Arrays.hashCode(this.branchQualifier) : 0);
        return result;
    }
}

