/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EagerLocking;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaultsService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.FileCacheStoreConfig;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.LocalDescriptions;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class CacheContainerAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache").set(source.require("default-cache"));
        if (source.hasDefined("jndi-name")) {
            target.get("jndi-name").set(source.get("jndi-name"));
        }
        if (source.hasDefined("listener-executor")) {
            target.get("listener-executor").set(source.get("listener-executor"));
        }
        if (source.hasDefined("eviction-executor")) {
            target.get("eviction-executor").set(source.get("eviction-executor"));
        }
        if (source.hasDefined("replication-queue-executor")) {
            target.get("replication-queue-executor").set(source.get("replication-queue-executor"));
        }
        if (source.hasDefined("alias")) {
            ModelNode aliases = target.get("alias");
            for (ModelNode alias : source.get("alias").asList()) {
                aliases.add(alias);
            }
        }
        if (source.hasDefined("transport")) {
            target.get("transport").set(source.get("transport"));
        }
        ModelNode caches = target.get("cache");
        for (ModelNode cache : source.require("cache").asList()) {
            caches.add(cache);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String defaultCache = operation.require("default-cache").asString();
        EmbeddedCacheManager config = new EmbeddedCacheManager(name, defaultCache);
        ServiceName[] aliases = null;
        if (operation.hasDefined("alias")) {
            List list = operation.get("alias").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ServiceTarget target = context.getServiceTarget();
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName(name);
        ServiceBuilder builder = target.addService(serviceName, (Service)new EmbeddedCacheManagerService(config)).addDependency(EmbeddedCacheManagerDefaultsService.SERVICE_NAME, EmbeddedCacheManagerDefaults.class, config.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, config.getTransactionManagerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, config.getTransactionSynchronizationRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, config.getXAResourceRecoveryRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, config.getMBeanServerInjector()).addAliases(aliases).setInitialMode(ServiceController.Mode.ON_DEMAND);
        String jndiName = (operation.hasDefined("jndi-name") ? CacheContainerAdd.toJndiName(operation.get("jndi-name").asString()) : JndiName.of((String)"java:jboss").append("infinispan").append(name)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        newControllers.add(target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(serviceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), NamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        boolean requiresTransport = false;
        Map<String, Configuration> configurations = config.getConfigurations();
        for (ModelNode cache : operation.require("cache").asList()) {
            Indexing indexing;
            String cacheName = cache.require("name").asString();
            Configuration configuration = new Configuration();
            FluentConfiguration fluent = configuration.fluent();
            Configuration.CacheMode mode = Configuration.CacheMode.valueOf((String)cache.require("mode").asString());
            requiresTransport |= mode.isClustered();
            fluent.mode(mode);
            if (cache.hasDefined("batching") && cache.get("batching").asBoolean()) {
                fluent.invocationBatching();
            }
            if (cache.hasDefined("indexing") && (indexing = Indexing.valueOf(cache.get("indexing").asString())).isEnabled()) {
                fluent.indexing().indexLocalOnly(Boolean.valueOf(indexing.isLocalOnly()));
            }
            if (cache.hasDefined("queue-size")) {
                fluent.async().replQueueMaxElements(Integer.valueOf(cache.get("queue-size").asInt()));
            }
            if (cache.hasDefined("queue-flush-interval")) {
                fluent.async().replQueueInterval(Long.valueOf(cache.get("queue-flush-interval").asLong()));
            }
            if (cache.hasDefined("remote-timeout")) {
                fluent.sync().replTimeout(Long.valueOf(cache.get("remote-timeout").asLong()));
            }
            if (cache.hasDefined("owners")) {
                fluent.hash().numOwners(Integer.valueOf(cache.get("owners").asInt()));
            }
            if (cache.hasDefined("virtual-nodes")) {
                fluent.hash().numVirtualNodes(Integer.valueOf(cache.get("virtual-nodes").asInt()));
            }
            if (cache.hasDefined("l1-lifespan")) {
                long lifespan = cache.get("l1-lifespan").asLong();
                if (lifespan > 0L) {
                    fluent.l1().lifespan(Long.valueOf(lifespan));
                } else {
                    fluent.l1().disable();
                }
            }
            if (cache.hasDefined("locking")) {
                ModelNode locking = cache.get("locking");
                FluentConfiguration.LockingConfig fluentLocking = fluent.locking();
                if (locking.hasDefined("isolation")) {
                    fluentLocking.isolationLevel(IsolationLevel.valueOf((String)locking.get("isolation").asString()));
                }
                if (locking.hasDefined("striping")) {
                    fluentLocking.useLockStriping(Boolean.valueOf(locking.get("striping").asBoolean()));
                }
                if (locking.hasDefined("acquire-timeout")) {
                    fluentLocking.lockAcquisitionTimeout(Long.valueOf(locking.get("acquire-timeout").asLong()));
                }
                if (locking.hasDefined("concurrency-level")) {
                    fluentLocking.concurrencyLevel(Integer.valueOf(locking.get("concurrency-level").asInt()));
                }
            }
            FluentConfiguration.TransactionConfig fluentTx = fluent.transaction();
            TransactionMode txMode = TransactionMode.NON_XA;
            if (cache.hasDefined("transaction")) {
                ModelNode transaction = cache.get("transaction");
                if (transaction.hasDefined("stop-timeout")) {
                    fluentTx.cacheStopTimeout(Integer.valueOf(transaction.get("stop-timeout").asInt()));
                }
                if (transaction.hasDefined("mode")) {
                    txMode = TransactionMode.valueOf(transaction.get("mode").asString());
                }
                if (transaction.hasDefined("eager-locking")) {
                    EagerLocking eager = EagerLocking.valueOf(transaction.get("eager-locking").asString());
                    fluentTx.useEagerLocking(Boolean.valueOf(eager.isEnabled())).eagerLockSingleNode(Boolean.valueOf(eager.isSingleOwner()));
                }
            }
            FluentConfiguration.RecoveryConfig recovery = fluentTx.useSynchronization(Boolean.valueOf(!txMode.isXAEnabled())).recovery();
            if (txMode.isRecoveryEnabled()) {
                recovery.syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true));
            } else {
                recovery.disable();
            }
            if (cache.hasDefined("eviction")) {
                ModelNode eviction = cache.get("eviction");
                FluentConfiguration.EvictionConfig fluentEviction = fluent.eviction();
                if (eviction.hasDefined("strategy")) {
                    fluentEviction.strategy(EvictionStrategy.valueOf((String)eviction.get("strategy").asString()));
                }
                if (eviction.hasDefined("max-entries")) {
                    fluentEviction.maxEntries(Integer.valueOf(eviction.get("max-entries").asInt()));
                }
            }
            if (cache.hasDefined("expiration")) {
                ModelNode expiration = cache.get("expiration");
                FluentConfiguration.ExpirationConfig fluentExpiration = fluent.expiration();
                if (expiration.hasDefined("max-idle")) {
                    fluentExpiration.maxIdle(Long.valueOf(expiration.get("max-idle").asLong()));
                }
                if (expiration.hasDefined("lifespan")) {
                    fluentExpiration.lifespan(Long.valueOf(expiration.get("lifespan").asLong()));
                }
                if (expiration.hasDefined("interval")) {
                    fluentExpiration.wakeUpInterval(Long.valueOf(expiration.get("interval").asLong()));
                }
            }
            if (cache.hasDefined("state-transfer")) {
                ModelNode stateTransfer = cache.get("state-transfer");
                FluentConfiguration.StateRetrievalConfig fluentStateTransfer = fluent.stateRetrieval();
                if (stateTransfer.hasDefined("enabled")) {
                    fluentStateTransfer.fetchInMemoryState(Boolean.valueOf(stateTransfer.get("enabled").asBoolean()));
                }
                if (stateTransfer.hasDefined("timeout")) {
                    fluentStateTransfer.timeout(Long.valueOf(stateTransfer.get("timeout").asLong()));
                }
                if (stateTransfer.hasDefined("flush-timeout")) {
                    fluentStateTransfer.logFlushTimeout(Long.valueOf(stateTransfer.get("flush-timeout").asLong()));
                }
            }
            if (cache.hasDefined("rehashing")) {
                ModelNode rehashing = cache.get("rehashing");
                FluentConfiguration.HashConfig fluentHash = fluent.hash();
                if (rehashing.hasDefined("enabled")) {
                    fluentHash.rehashEnabled(Boolean.valueOf(rehashing.get("enabled").asBoolean()));
                }
                if (rehashing.hasDefined("timeout")) {
                    fluentHash.rehashRpcTimeout(Long.valueOf(rehashing.get("timeout").asLong()));
                }
            }
            if (cache.hasDefined("store")) {
                ModelNode store = cache.get("store");
                FluentConfiguration.LoadersConfig fluentStores = fluent.loaders();
                fluentStores.shared(Boolean.valueOf(store.hasDefined("shared") ? store.get("shared").asBoolean() : false));
                fluentStores.preload(Boolean.valueOf(store.hasDefined("preload") ? store.get("preload").asBoolean() : false));
                fluentStores.passivation(Boolean.valueOf(store.hasDefined("passivation") ? store.get("passivation").asBoolean() : true));
                CacheStoreConfig storeConfig = this.buildCacheStore(name, (ServiceBuilder<CacheContainer>)builder, store);
                storeConfig.singletonStore().enabled(Boolean.valueOf(store.hasDefined("singleton") ? store.get("singleton").asBoolean() : false));
                storeConfig.fetchPersistentState(Boolean.valueOf(store.hasDefined("fetch-state") ? store.get("fetch-state").asBoolean() : true));
                storeConfig.purgeOnStartup(Boolean.valueOf(store.hasDefined("purge") ? store.get("purge").asBoolean() : true));
                if (store.hasDefined("property") && storeConfig instanceof AbstractCacheStoreConfig) {
                    Properties properties = new Properties();
                    for (Property property : store.get("property").asPropertyList()) {
                        properties.setProperty(property.getName(), property.getValue().asString());
                    }
                    ((AbstractCacheStoreConfig)storeConfig).setProperties(properties);
                }
                fluentStores.addCacheLoader(new CacheLoaderConfig[]{storeConfig});
            }
            configurations.put(cacheName, configuration);
            StartMode startMode = cache.hasDefined("start") ? StartMode.valueOf(cache.get("start").asString()) : StartMode.LAZY;
            ServiceBuilder cacheBuilder = new CacheService(cacheName).build(target, serviceName).addDependency(bindInfo.getBinderServiceName()).setInitialMode(startMode.getMode());
            if (cacheName.equals(defaultCache)) {
                cacheBuilder.addAliases(new ServiceName[]{CacheService.getServiceName(name, null)});
            }
            if (startMode.getMode() == ServiceController.Mode.ACTIVE) {
                cacheBuilder.addListener((ServiceListener)verificationHandler);
            }
            newControllers.add(cacheBuilder.install());
        }
        if (!configurations.containsKey(defaultCache)) {
            throw new IllegalArgumentException(String.format("%s is not a valid default cache. The %s cache container does not contain a cache with that name", defaultCache, name));
        }
        if (requiresTransport) {
            Transport transportConfig = new Transport();
            String stack = null;
            if (operation.hasDefined("transport")) {
                ModelNode transport = operation.get("transport");
                if (transport.hasDefined("stack")) {
                    stack = transport.get("stack").asString();
                }
                this.addExecutorDependency((ServiceBuilder<CacheContainer>)builder, transport, "executor", transportConfig.getExecutorInjector());
                if (transport.hasDefined("lock-timeout")) {
                    transportConfig.setLockTimeout(transport.get("lock-timeout").asLong());
                }
                if (transport.hasDefined("site")) {
                    transportConfig.setSite(transport.get("site").asString());
                }
                if (transport.hasDefined("rack")) {
                    transportConfig.setRack(transport.get("rack").asString());
                }
                if (transport.hasDefined("machine")) {
                    transportConfig.setMachine(transport.get("machine").asString());
                }
            }
            builder.addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, transportConfig.getChannelFactoryInjector());
            builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, transportConfig.getEnvironmentInjector());
            config.setTransport(transportConfig);
        }
        this.addExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "listener-executor", config.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "eviction-executor", config.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "replication-queue-executor", config.getReplicationQueueExecutorInjector());
        newControllers.add(builder.install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getCacheContainerAddDescription(locale);
    }

    private void addExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<Executor> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<ScheduledExecutorService> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), ScheduledExecutorService.class, injector);
        }
    }

    private CacheStoreConfig buildCacheStore(String name, ServiceBuilder<CacheContainer> builder, ModelNode store) {
        if (store.hasDefined("class")) {
            String className = store.get("class").asString();
            try {
                CacheStore cacheStore = Class.forName(className).asSubclass(CacheStore.class).newInstance();
                return cacheStore.getConfigurationClass().asSubclass(CacheStoreConfig.class).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
            }
        }
        FileCacheStoreConfig storeConfig = new FileCacheStoreConfig();
        String relativeTo = store.hasDefined("relative-to") ? store.get("relative-to").asString() : "jboss.server.data.dir";
        builder.addDependency(AbstractPathService.pathNameOf((String)relativeTo), String.class, storeConfig.getRelativeToInjector());
        storeConfig.setPath(store.hasDefined("path") ? store.get("path").asString() : name);
        return storeConfig;
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)"java:jboss").append(value.startsWith("/") ? value.substring(1) : value);
    }

    static class Transport
    implements TransportConfiguration {
        private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
        private Long lockTimeout;
        private String site;
        private String rack;
        private String machine;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setSite(String site) {
            this.site = site;
        }

        void setRack(String rack) {
            this.rack = rack;
        }

        void setMachine(String machine) {
            this.machine = machine;
        }

        Injector<ChannelFactory> getChannelFactoryInjector() {
            return this.channelFactory;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        Injector<ServerEnvironment> getEnvironmentInjector() {
            return this.environment;
        }

        @Override
        public ServerEnvironment getEnvironment() {
            return (ServerEnvironment)this.environment.getValue();
        }

        @Override
        public ChannelFactory getChannelFactory() {
            return (ChannelFactory)this.channelFactory.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }

        @Override
        public String getSite() {
            return this.site;
        }

        @Override
        public String getRack() {
            return this.rack;
        }

        @Override
        public String getMachine() {
            return this.machine;
        }
    }

    static class EmbeddedCacheManager
    implements EmbeddedCacheManagerConfiguration {
        private final InjectedValue<EmbeddedCacheManagerDefaults> defaults = new InjectedValue();
        private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final String name;
        private final String defaultCache;
        private final Map<String, Configuration> configurations = new HashMap<String, Configuration>();
        private Transport transport;

        EmbeddedCacheManager(String name, String defaultCache) {
            this.name = name;
            this.defaultCache = defaultCache;
        }

        Injector<EmbeddedCacheManagerDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.transactionManager;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.transactionSynchronizationRegistry;
        }

        Injector<XAResourceRecoveryRegistry> getXAResourceRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        void setTransport(Transport transport) {
            this.transport = transport;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDefaultCache() {
            return this.defaultCache;
        }

        @Override
        public Map<String, Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public EmbeddedCacheManagerDefaults getDefaults() {
            return (EmbeddedCacheManagerDefaults)this.defaults.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.transactionManager.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getOptionalValue();
        }

        @Override
        public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }
    }
}

