/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryAwareService;

public class BasicServiceRegistryImpl
extends AbstractServiceRegistryImpl
implements BasicServiceRegistry {
    private final Map configurationValues;

    public BasicServiceRegistryImpl(List<BasicServiceInitiator> serviceInitiators, List<ProvidedService> providedServices, Map configurationValues) {
        this.configurationValues = configurationValues;
        for (BasicServiceInitiator initiator : serviceInitiators) {
            this.createServiceBinding(initiator);
        }
        for (ProvidedService providedService : providedServices) {
            this.createServiceBinding(providedService);
        }
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        return ((BasicServiceInitiator)serviceInitiator).initiateService(this.configurationValues, this);
    }

    @Override
    protected <T extends Service> void configureService(T service) {
        this.applyInjections(service);
        if (ServiceRegistryAwareService.class.isInstance(service)) {
            ((ServiceRegistryAwareService)((Object)service)).injectServices(this);
        }
        if (Configurable.class.isInstance(service)) {
            ((Configurable)((Object)service)).configure(this.configurationValues);
        }
    }
}

