/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.metamodel.source.binder.SubclassEntityContainer;
import org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.metamodel.source.hbm.RootEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.SubclassEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.EntityElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.SubEntityElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLHibernateMapping;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLJoinedSubclassElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLSubclassElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLUnionSubclassElement;

public class HierarchyBuilder {
    private final List<EntityHierarchyImpl> entityHierarchies = new ArrayList<EntityHierarchyImpl>();
    private final Map<String, SubclassEntityContainer> subEntityContainerMap = new HashMap<String, SubclassEntityContainer>();
    private final List<ExtendsQueueEntry> extendsQueue = new ArrayList<ExtendsQueueEntry>();
    private MappingDocument currentMappingDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMappingDocument(MappingDocument mappingDocument) {
        this.currentMappingDocument = mappingDocument;
        try {
            this.processCurrentMappingDocument();
        }
        finally {
            this.currentMappingDocument = null;
        }
    }

    private void processCurrentMappingDocument() {
        for (Object entityElementO : this.currentMappingDocument.getMappingRoot().getClazzOrSubclassOrJoinedSubclass()) {
            EntityElement entityElement = (EntityElement)entityElementO;
            if (XMLHibernateMapping.XMLClass.class.isInstance(entityElement)) {
                XMLHibernateMapping.XMLClass xmlClass = (XMLHibernateMapping.XMLClass)entityElement;
                RootEntitySourceImpl rootEntitySource = new RootEntitySourceImpl(this.currentMappingDocument, xmlClass);
                EntityHierarchyImpl hierarchy = new EntityHierarchyImpl(rootEntitySource);
                this.entityHierarchies.add(hierarchy);
                this.subEntityContainerMap.put(rootEntitySource.getEntityName(), rootEntitySource);
                this.processSubElements(entityElement, rootEntitySource);
                continue;
            }
            SubclassEntitySourceImpl subClassEntitySource = new SubclassEntitySourceImpl(this.currentMappingDocument, entityElement);
            String entityName = subClassEntitySource.getEntityName();
            this.subEntityContainerMap.put(entityName, subClassEntitySource);
            String entityItExtends = this.currentMappingDocument.getMappingLocalBindingContext().qualifyClassName(((SubEntityElement)entityElement).getExtends());
            this.processSubElements(entityElement, subClassEntitySource);
            SubclassEntityContainer container = this.subEntityContainerMap.get(entityItExtends);
            if (container != null) {
                container.add(subClassEntitySource);
                continue;
            }
            this.extendsQueue.add(new ExtendsQueueEntry(subClassEntitySource, entityItExtends));
        }
    }

    public List<EntityHierarchyImpl> groupEntityHierarchies() {
        while (!this.extendsQueue.isEmpty()) {
            int numberOfMappingsProcessed = 0;
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.iterator();
            while (iterator.hasNext()) {
                ExtendsQueueEntry entry = iterator.next();
                SubclassEntityContainer container = this.subEntityContainerMap.get(entry.entityItExtends);
                if (container == null) continue;
                container.add(entry.subClassEntitySource);
                iterator.remove();
                ++numberOfMappingsProcessed;
            }
            if (numberOfMappingsProcessed != 0) continue;
            throw new MappingException("Unable to process extends dependencies in hbm files");
        }
        return this.entityHierarchies;
    }

    private void processSubElements(EntityElement entityElement, SubclassEntityContainer container) {
        if (XMLHibernateMapping.XMLClass.class.isInstance(entityElement)) {
            XMLHibernateMapping.XMLClass xmlClass = (XMLHibernateMapping.XMLClass)entityElement;
            this.processElements(xmlClass.getJoinedSubclass(), container);
            this.processElements(xmlClass.getSubclass(), container);
            this.processElements(xmlClass.getUnionSubclass(), container);
        } else if (XMLSubclassElement.class.isInstance(entityElement)) {
            XMLSubclassElement xmlSubclass = (XMLSubclassElement)entityElement;
            this.processElements(xmlSubclass.getSubclass(), container);
        } else if (XMLJoinedSubclassElement.class.isInstance(entityElement)) {
            XMLJoinedSubclassElement xmlJoinedSubclass = (XMLJoinedSubclassElement)entityElement;
            this.processElements(xmlJoinedSubclass.getJoinedSubclass(), container);
        } else if (XMLUnionSubclassElement.class.isInstance(entityElement)) {
            XMLUnionSubclassElement xmlUnionSubclass = (XMLUnionSubclassElement)entityElement;
            this.processElements(xmlUnionSubclass.getUnionSubclass(), container);
        }
    }

    private void processElements(List subElements, SubclassEntityContainer container) {
        for (Object subElementO : subElements) {
            SubEntityElement subElement = (SubEntityElement)subElementO;
            SubclassEntitySourceImpl subclassEntitySource = new SubclassEntitySourceImpl(this.currentMappingDocument, subElement);
            container.add(subclassEntitySource);
            String subEntityName = subclassEntitySource.getEntityName();
            this.subEntityContainerMap.put(subEntityName, subclassEntitySource);
        }
    }

    private static class ExtendsQueueEntry {
        private final SubclassEntitySource subClassEntitySource;
        private final String entityItExtends;

        private ExtendsQueueEntry(SubclassEntitySource subClassEntitySource, String entityItExtends) {
            this.subClassEntitySource = subClassEntitySource;
            this.entityItExtends = entityItExtends;
        }
    }
}

