/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.annotation.jaxb.XMLAttributes;
import org.hibernate.metamodel.source.annotation.jaxb.XMLEntity;
import org.hibernate.metamodel.source.annotation.jaxb.XMLEntityMappings;
import org.hibernate.metamodel.source.annotation.jaxb.XMLId;
import org.hibernate.metamodel.source.annotation.jaxb.XMLNamedNativeQuery;
import org.hibernate.metamodel.source.annotation.jaxb.XMLNamedQuery;
import org.hibernate.metamodel.source.annotation.jaxb.XMLSequenceGenerator;
import org.hibernate.metamodel.source.annotation.jaxb.XMLSqlResultSetMapping;
import org.hibernate.metamodel.source.annotation.jaxb.XMLTableGenerator;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class GlobalAnnotations
implements JPADotNames {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)GlobalAnnotations.class.getName());
    private Map<String, XMLSequenceGenerator> sequenceGeneratorMap = new HashMap<String, XMLSequenceGenerator>();
    private Map<String, XMLTableGenerator> tableGeneratorMap = new HashMap<String, XMLTableGenerator>();
    private Map<String, XMLNamedQuery> namedQueryMap = new HashMap<String, XMLNamedQuery>();
    private Map<String, XMLNamedNativeQuery> namedNativeQueryMap = new HashMap<String, XMLNamedNativeQuery>();
    private Map<String, XMLSqlResultSetMapping> sqlResultSetMappingMap = new HashMap<String, XMLSqlResultSetMapping>();
    private Map<DotName, List<AnnotationInstance>> annotationInstanceMap = new HashMap<DotName, List<AnnotationInstance>>();
    private List<AnnotationInstance> indexedAnnotationInstanceList = new ArrayList<AnnotationInstance>();
    private Set<String> defaultNamedNativeQueryNames = new HashSet<String>();
    private Set<String> defaultNamedQueryNames = new HashSet<String>();
    private Set<String> defaultNamedGenerators = new HashSet<String>();
    private Set<String> defaultSqlResultSetMappingNames = new HashSet<String>();

    GlobalAnnotations() {
    }

    Map<DotName, List<AnnotationInstance>> getAnnotationInstanceMap() {
        return this.annotationInstanceMap;
    }

    AnnotationInstance push(DotName name, AnnotationInstance annotationInstance) {
        if (name == null || annotationInstance == null) {
            return null;
        }
        List<AnnotationInstance> list = this.annotationInstanceMap.get(name);
        if (list == null) {
            list = new ArrayList<AnnotationInstance>();
            this.annotationInstanceMap.put(name, list);
        }
        list.add(annotationInstance);
        return annotationInstance;
    }

    void addIndexedAnnotationInstance(List<AnnotationInstance> annotationInstanceList) {
        if (MockHelper.isNotEmpty(annotationInstanceList)) {
            this.indexedAnnotationInstanceList.addAll(annotationInstanceList);
        }
    }

    boolean hasGlobalConfiguration() {
        return !this.namedQueryMap.isEmpty() || !this.namedNativeQueryMap.isEmpty() || !this.sequenceGeneratorMap.isEmpty() || !this.tableGeneratorMap.isEmpty() || !this.sqlResultSetMappingMap.isEmpty();
    }

    Map<String, XMLNamedNativeQuery> getNamedNativeQueryMap() {
        return this.namedNativeQueryMap;
    }

    Map<String, XMLNamedQuery> getNamedQueryMap() {
        return this.namedQueryMap;
    }

    Map<String, XMLSequenceGenerator> getSequenceGeneratorMap() {
        return this.sequenceGeneratorMap;
    }

    Map<String, XMLSqlResultSetMapping> getSqlResultSetMappingMap() {
        return this.sqlResultSetMappingMap;
    }

    Map<String, XMLTableGenerator> getTableGeneratorMap() {
        return this.tableGeneratorMap;
    }

    public void filterIndexedAnnotations() {
        for (AnnotationInstance annotationInstance : this.indexedAnnotationInstanceList) {
            this.pushIfNotExist(annotationInstance);
        }
    }

    private void pushIfNotExist(AnnotationInstance annotationInstance) {
        DotName annName = annotationInstance.name();
        boolean isNotExist = false;
        if (annName.equals((Object)SQL_RESULT_SET_MAPPINGS)) {
            AnnotationInstance[] annotationInstances;
            for (AnnotationInstance ai : annotationInstances = annotationInstance.value().asNestedArray()) {
                this.pushIfNotExist(ai);
            }
        } else {
            AnnotationValue value = annotationInstance.value("name");
            String name = value.asString();
            boolean bl = isNotExist = annName.equals((Object)TABLE_GENERATOR) && !this.tableGeneratorMap.containsKey(name) || annName.equals((Object)SEQUENCE_GENERATOR) && !this.sequenceGeneratorMap.containsKey(name) || annName.equals((Object)NAMED_QUERY) && !this.namedQueryMap.containsKey(name) || annName.equals((Object)NAMED_NATIVE_QUERY) && !this.namedNativeQueryMap.containsKey(name) || annName.equals((Object)SQL_RESULT_SET_MAPPING) && !this.sqlResultSetMappingMap.containsKey(name);
        }
        if (isNotExist) {
            this.push(annName, annotationInstance);
        }
    }

    void collectGlobalMappings(XMLEntityMappings entityMappings, EntityMappingsMocker.Default defaults) {
        for (XMLSequenceGenerator xMLSequenceGenerator : entityMappings.getSequenceGenerator()) {
            this.put(xMLSequenceGenerator, defaults);
            this.defaultNamedGenerators.add(xMLSequenceGenerator.getName());
        }
        for (XMLTableGenerator xMLTableGenerator : entityMappings.getTableGenerator()) {
            this.put(xMLTableGenerator, defaults);
            this.defaultNamedGenerators.add(xMLTableGenerator.getName());
        }
        for (XMLNamedQuery xMLNamedQuery : entityMappings.getNamedQuery()) {
            this.put(xMLNamedQuery);
            this.defaultNamedQueryNames.add(xMLNamedQuery.getName());
        }
        for (XMLNamedNativeQuery xMLNamedNativeQuery : entityMappings.getNamedNativeQuery()) {
            this.put(xMLNamedNativeQuery);
            this.defaultNamedNativeQueryNames.add(xMLNamedNativeQuery.getName());
        }
        for (XMLSqlResultSetMapping xMLSqlResultSetMapping : entityMappings.getSqlResultSetMapping()) {
            this.put(xMLSqlResultSetMapping);
            this.defaultSqlResultSetMappingNames.add(xMLSqlResultSetMapping.getName());
        }
    }

    void collectGlobalMappings(XMLEntity entity, EntityMappingsMocker.Default defaults) {
        XMLAttributes attributes;
        XMLTableGenerator tableGenerator;
        for (XMLNamedQuery namedQuery : entity.getNamedQuery()) {
            if (!this.defaultNamedQueryNames.contains(namedQuery.getName())) {
                this.put(namedQuery);
                continue;
            }
            LOG.warn("Named Query [" + namedQuery.getName() + "] duplicated.");
        }
        for (XMLNamedNativeQuery namedNativeQuery : entity.getNamedNativeQuery()) {
            if (!this.defaultNamedNativeQueryNames.contains(namedNativeQuery.getName())) {
                this.put(namedNativeQuery);
                continue;
            }
            LOG.warn("Named native Query [" + namedNativeQuery.getName() + "] duplicated.");
        }
        for (XMLSqlResultSetMapping sqlResultSetMapping : entity.getSqlResultSetMapping()) {
            if (this.defaultSqlResultSetMappingNames.contains(sqlResultSetMapping.getName())) continue;
            this.put(sqlResultSetMapping);
        }
        XMLSequenceGenerator sequenceGenerator = entity.getSequenceGenerator();
        if (sequenceGenerator != null && !this.defaultNamedGenerators.contains(sequenceGenerator.getName())) {
            this.put(sequenceGenerator, defaults);
        }
        if ((tableGenerator = entity.getTableGenerator()) != null && !this.defaultNamedGenerators.contains(tableGenerator.getName())) {
            this.put(tableGenerator, defaults);
        }
        if ((attributes = entity.getAttributes()) != null) {
            for (XMLId id : attributes.getId()) {
                sequenceGenerator = id.getSequenceGenerator();
                if (sequenceGenerator != null) {
                    this.put(sequenceGenerator, defaults);
                }
                if ((tableGenerator = id.getTableGenerator()) == null) continue;
                this.put(tableGenerator, defaults);
            }
        }
    }

    private static XMLSequenceGenerator overrideGenerator(XMLSequenceGenerator generator, EntityMappingsMocker.Default defaults) {
        if (StringHelper.isEmpty(generator.getSchema()) && defaults != null) {
            generator.setSchema(defaults.getSchema());
        }
        if (StringHelper.isEmpty(generator.getCatalog()) && defaults != null) {
            generator.setCatalog(defaults.getCatalog());
        }
        return generator;
    }

    private static XMLTableGenerator overrideGenerator(XMLTableGenerator generator, EntityMappingsMocker.Default defaults) {
        if (StringHelper.isEmpty(generator.getSchema()) && defaults != null) {
            generator.setSchema(defaults.getSchema());
        }
        if (StringHelper.isEmpty(generator.getCatalog()) && defaults != null) {
            generator.setCatalog(defaults.getCatalog());
        }
        return generator;
    }

    private void put(XMLNamedNativeQuery query) {
        if (query != null) {
            this.checkQueryName(query.getName());
            this.namedNativeQueryMap.put(query.getName(), query);
        }
    }

    private void checkQueryName(String name) {
        if (this.namedQueryMap.containsKey(name) || this.namedNativeQueryMap.containsKey(name)) {
            throw new MappingException("Duplicated query mapping " + name, null);
        }
    }

    private void put(XMLNamedQuery query) {
        if (query != null) {
            this.checkQueryName(query.getName());
            this.namedQueryMap.put(query.getName(), query);
        }
    }

    private void put(XMLSequenceGenerator generator, EntityMappingsMocker.Default defaults) {
        XMLSequenceGenerator old;
        if (generator != null && (old = this.sequenceGeneratorMap.put(generator.getName(), GlobalAnnotations.overrideGenerator(generator, defaults))) != null) {
            LOG.duplicateGeneratorName(generator.getName());
        }
    }

    private void put(XMLTableGenerator generator, EntityMappingsMocker.Default defaults) {
        XMLTableGenerator old;
        if (generator != null && (old = this.tableGeneratorMap.put(generator.getName(), GlobalAnnotations.overrideGenerator(generator, defaults))) != null) {
            LOG.duplicateGeneratorName(generator.getName());
        }
    }

    private void put(XMLSqlResultSetMapping mapping) {
        XMLSqlResultSetMapping old;
        if (mapping != null && (old = this.sqlResultSetMappingMap.put(mapping.getName(), mapping)) != null) {
            throw new MappingException("Duplicated SQL result set mapping " + mapping.getName(), null);
        }
    }
}

