/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.List;
import java.util.Map;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public abstract class MappedAttribute
implements Comparable<MappedAttribute> {
    private final Map<DotName, List<AnnotationInstance>> annotations;
    private final String name;
    private final Class<?> attributeType;
    private final String accessType;
    private final AnnotationBindingContext context;

    MappedAttribute(String name, Class<?> attributeType, String accessType, Map<DotName, List<AnnotationInstance>> annotations, AnnotationBindingContext context) {
        this.context = context;
        this.annotations = annotations;
        this.name = name;
        this.attributeType = attributeType;
        this.accessType = accessType;
    }

    public String getName() {
        return this.name;
    }

    public final Class<?> getAttributeType() {
        return this.attributeType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public AnnotationBindingContext getContext() {
        return this.context;
    }

    public Map<DotName, List<AnnotationInstance>> annotations() {
        return this.annotations;
    }

    @Override
    public int compareTo(MappedAttribute mappedProperty) {
        return this.name.compareTo(mappedProperty.getName());
    }

    public abstract AttributeTypeResolver getHibernateTypeResolver();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MappedAttribute");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

