/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.ColumnValuesSourceImpl;

public class ColumnSourceImpl
extends ColumnValuesSourceImpl {
    private final BasicAttribute attribute;
    private final String name;

    ColumnSourceImpl(BasicAttribute attribute, AttributeOverride attributeOverride) {
        super(attribute.getColumnValues());
        if (attributeOverride != null) {
            this.setOverrideColumnValues(attributeOverride.getColumnValues());
        }
        this.attribute = attribute;
        this.name = this.resolveColumnName();
    }

    protected String resolveColumnName() {
        if (StringHelper.isEmpty(super.getName())) {
            return this.attribute.getContext().getNamingStrategy().propertyToColumnName(this.attribute.getName());
        }
        return super.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReadFragment() {
        return this.attribute.getCustomReadFragment();
    }

    @Override
    public String getWriteFragment() {
        return this.attribute.getCustomWriteFragment();
    }

    @Override
    public String getCheckCondition() {
        return this.attribute.getCheckCondition();
    }
}

