/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.marshallers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.CookieParam;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.client.ClientURI;
import org.jboss.resteasy.client.core.marshallers.CookieParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.FormMarshaller;
import org.jboss.resteasy.client.core.marshallers.FormParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.HeaderParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.Marshaller;
import org.jboss.resteasy.client.core.marshallers.MatrixParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.MessageBodyParameterMarshaller;
import org.jboss.resteasy.client.core.marshallers.NOOPMarshaller;
import org.jboss.resteasy.client.core.marshallers.PathParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.QueryParamMarshaller;
import org.jboss.resteasy.client.core.marshallers.URIParamMarshaller;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ClientMarshallerFactory {
    public static Marshaller[] createMarshallers(Class declaringClass, Method method, ResteasyProviderFactory providerFactory) {
        Marshaller[] params = new Marshaller[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            Annotation[] annotations = method.getParameterAnnotations()[i];
            Type genericType = method.getGenericParameterTypes()[i];
            Method target = method;
            params[i] = ClientMarshallerFactory.createMarshaller(declaringClass, providerFactory, type, annotations, genericType, target, false);
        }
        return params;
    }

    public static Marshaller createMarshaller(Class<?> declaring, ResteasyProviderFactory providerFactory, Class<?> type, Annotation[] annotations, Type genericType, AccessibleObject target, boolean ignoreBody) {
        Marshaller marshaller = null;
        boolean isEncoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        QueryParam query = FindAnnotation.findAnnotation(annotations, QueryParam.class);
        if (query != null) {
            marshaller = new QueryParamMarshaller(query.value());
        } else {
            HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
            if (header != null) {
                marshaller = new HeaderParamMarshaller(header.value());
            } else {
                CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
                if (cookie != null) {
                    marshaller = new CookieParamMarshaller(cookie.value());
                } else {
                    PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
                    if (uriParam != null) {
                        marshaller = new PathParamMarshaller(uriParam.value(), isEncoded, providerFactory);
                    } else {
                        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
                        if (matrix != null) {
                            marshaller = new MatrixParamMarshaller(matrix.value());
                        } else {
                            FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
                            if (formParam != null) {
                                marshaller = new FormParamMarshaller(formParam.value());
                            } else if (FindAnnotation.findAnnotation(annotations, Form.class) != null) {
                                marshaller = new FormMarshaller(type, providerFactory);
                            } else if (FindAnnotation.findAnnotation(annotations, Context.class) != null) {
                                marshaller = new NOOPMarshaller();
                            } else if (type.equals(Cookie.class)) {
                                marshaller = new CookieParamMarshaller(null);
                            } else if (FindAnnotation.findAnnotation(annotations, ClientURI.class) != null) {
                                marshaller = new URIParamMarshaller();
                            } else if (!ignoreBody) {
                                MediaType mediaType = MediaTypeHelper.getConsumes(declaring, target);
                                if (mediaType == null) {
                                    throw new RuntimeException("You must define a @Consumes type on your client method or interface");
                                }
                                marshaller = new MessageBodyParameterMarshaller(mediaType, type, genericType, annotations);
                            }
                        }
                    }
                }
            }
        }
        return marshaller;
    }
}

