/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.asset.Asset;

public class ManifestBuilder
implements Asset {
    private static final Logger log = Logger.getLogger(ManifestBuilder.class);
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);
    private Manifest manifest;

    public static ManifestBuilder newInstance() {
        return new ManifestBuilder();
    }

    protected ManifestBuilder() {
        this.append(Attributes.Name.MANIFEST_VERSION + ": 1.0", true);
    }

    public ManifestBuilder addManifestHeader(String key, String value) {
        this.append(key + ": " + value, true);
        return this;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            String manifestString = this.sw.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)manifestString);
            }
            try {
                this.manifest = new Manifest(new ByteArrayInputStream(manifestString.getBytes()));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create manifest", ex);
            }
        }
        return this.manifest;
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot provide manifest InputStream", ex);
        }
    }

    protected void append(String line, boolean newline) {
        if (this.manifest != null) {
            throw new IllegalStateException("Cannot append to already existing manifest");
        }
        if (line != null) {
            this.pw.print(line);
        }
        if (newline) {
            this.pw.println();
        }
    }
}

