/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractEjbJarMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarNamespaceMapping;
import org.jboss.metadata.ejb.spec.EjbJar1xMetaData;
import org.jboss.metadata.ejb.spec.EjbJar20MetaData;
import org.jboss.metadata.ejb.spec.EjbJar21MetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar31MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class EjbJarMetaDataParser
extends AbstractEjbJarMetaDataParser<EjbJarMetaData> {
    @Override
    public EjbJarMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        throw new UnsupportedOperationException("org.jboss.metadata.ejb.parser.spec.EjbJarMetaDataParser.parse");
    }

    public static EjbJarMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        return new EjbJarMetaDataParser().parseDocument(reader, info);
    }

    public EjbJarMetaData parseDocument(XMLStreamReader reader, MetaDataElementParser.DTDInfo info) throws XMLStreamException {
        String schemaLocation;
        reader.require(7, null, null);
        EjbJarVersion ejbJarVersion = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = info.getSystemID()) == null) continue;
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(dtdLocation);
        }
        if (ejbJarVersion == null && (schemaLocation = EjbJarMetaDataParser.readSchemaLocation((XMLStreamReader)reader)) != null) {
            ejbJarVersion = EjbJarNamespaceMapping.getEjbJarVersion(schemaLocation);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = EjbJarMetaDataParser.readVersionAttribute(reader);
        }
        if (ejbJarVersion == null) {
            ejbJarVersion = EjbJarVersion.EJB_3_1;
        }
        EjbJarMetaData ejbJarMetaData = EjbJarMetaDataParser.getEjbJarMetaData(ejbJarVersion);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (EjbJarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            EjbJarAttribute ejbJarAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i));
            switch (ejbJarAttribute) {
                case ID: {
                    ejbJarMetaData.setId(value);
                    continue block6;
                }
                case VERSION: {
                    ejbJarMetaData.setVersion(value);
                    continue block6;
                }
                case METADATA_COMPLETE: {
                    if (ejbJarMetaData instanceof EjbJar3xMetaData) {
                        if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block6;
                        ((EjbJar3xMetaData)ejbJarMetaData).setMetadataComplete(true);
                        continue block6;
                    }
                    throw EjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
                default: {
                    throw EjbJarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        this.processElements(ejbJarMetaData, reader);
        return ejbJarMetaData;
    }

    private static EjbJarMetaData getEjbJarMetaData(EjbJarVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(EjbJarVersion.class.getSimpleName() + " is null. Cannot return " + EjbJarMetaData.class);
        }
        switch (version) {
            case EJB_1_1: {
                return new EjbJar1xMetaData();
            }
            case EJB_2_0: {
                return new EjbJar20MetaData();
            }
            case EJB_2_1: {
                return new EjbJar21MetaData();
            }
            case EJB_3_0: {
                return new EjbJar30MetaData();
            }
            case EJB_3_1: {
                return new EjbJar31MetaData();
            }
        }
        throw new IllegalArgumentException("Unknown ejb-jar version: " + version.name());
    }
}

