/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;

class RootLoggerRemove
extends AbstractRemoveStepHandler {
    static final RootLoggerRemove INSTANCE = new RootLoggerRemove();
    static final String OPERATION_NAME = "remove-root-logger";

    RootLoggerRemove() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) {
        context.readModelForUpdate(PathAddress.EMPTY_ADDRESS).get("root-logger").clear();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        context.removeService(LogServices.ROOT_LOGGER);
        if (model.get("root-logger").has("handlers")) {
            LogServices.uninstallLoggerHandlers(context, "", model.get(new String[]{"root-logger", "handlers"}));
        }
    }
}

