/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.as.logging.PeriodicRotatingFileHandlerService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class PeriodicRotatingFileHandlerAdd
extends AbstractAddStepHandler {
    static final PeriodicRotatingFileHandlerAdd INSTANCE = new PeriodicRotatingFileHandlerAdd();

    PeriodicRotatingFileHandlerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        LoggingValidators.validate(operation);
        if (operation.hasDefined("append")) {
            model.get("append").set(operation.get("append"));
        }
        model.get("autoflush").set(operation.get("autoflush"));
        model.get("encoding").set(operation.get("encoding"));
        model.get("formatter").set(operation.get("formatter"));
        model.get("level").set(operation.get("level"));
        if (operation.hasDefined("level")) {
            model.get("file").set(operation.get("file"));
        }
        model.get("suffix").set(operation.get("suffix"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        try {
            Boolean autoFlush;
            PeriodicRotatingFileHandlerService service = new PeriodicRotatingFileHandlerService();
            ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
            if (operation.hasDefined("append")) {
                service.setAppend(operation.get("append").asBoolean());
            }
            if (operation.hasDefined("file")) {
                HandlerFileService fileService = new HandlerFileService(operation.get(new String[]{"file", "path"}).asString());
                ServiceBuilder fileBuilder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)fileService);
                if (operation.get("file").hasDefined("relative-to")) {
                    fileBuilder.addDependency(AbstractPathService.pathNameOf((String)operation.get(new String[]{"file", "relative-to"}).asString()), String.class, fileService.getRelativeToInjector());
                }
                fileBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                serviceBuilder.addDependency(LogServices.handlerFileName(name), String.class, service.getFileNameInjector());
            }
            if (operation.hasDefined("level")) {
                service.setLevel(Level.parse(operation.get("level").asString()));
            }
            if ((autoFlush = Boolean.valueOf(operation.get("autoflush").asBoolean())) != null) {
                service.setAutoflush(autoFlush);
            }
            if (operation.hasDefined("suffix")) {
                service.setSuffix(operation.get("suffix").asString());
            }
            if (operation.hasDefined("encoding")) {
                service.setEncoding(operation.get("encoding").asString());
            }
            service.setFormatterSpec(AbstractFormatterSpec.Factory.create(operation));
            serviceBuilder.addListener((ServiceListener)verificationHandler);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            newControllers.add(serviceBuilder.install());
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }
}

