/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.server.deployment.scanner.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentSubsystemDescriptions {
    static final String RESOURCE_NAME = DeploymentSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    static final ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode subsystem = new ModelNode();
        subsystem.get("description").set(bundle.getString("deployment.scanner.subsystem"));
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.CURRENT.getUriString());
        subsystem.get("attributes").setEmptyObject();
        subsystem.get("operations");
        subsystem.get(new String[]{"children", "scanner", "description"}).set(bundle.getString("deployment.scanner.subsystem.scanners"));
        return subsystem;
    }

    static final ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("add");
        operation.get("description").set(bundle.getString("deployment.scanner.subsystem.add"));
        operation.get("request-properties").setEmptyObject();
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set(bundle.getString("deployment.scanner.subsystem.remove"));
        operation.get("request-properties").setEmptyObject();
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    static final ModelNode getScannerDescription(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("scanner"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("scanner.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "path", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "path", "description"}).set(bundle.getString("scanner.path"));
        root.get(new String[]{"attributes", "path", "required"}).set(true);
        root.get(new String[]{"attributes", "path", "min-length"}).set(1);
        root.get(new String[]{"attributes", "relative-to", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "relative-to", "description"}).set(bundle.getString("scanner.relative-to"));
        root.get(new String[]{"attributes", "relative-to", "required"}).set(false);
        root.get(new String[]{"attributes", "scan-enabled", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "scan-enabled", "description"}).set(bundle.getString("scanner.enabled"));
        root.get(new String[]{"attributes", "scan-enabled", "required"}).set(false);
        root.get(new String[]{"attributes", "scan-enabled", "default"}).set(true);
        root.get(new String[]{"attributes", "scan-interval", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "scan-interval", "description"}).set(bundle.getString("scanner.interval"));
        root.get(new String[]{"attributes", "scan-interval", "required"}).set(false);
        root.get(new String[]{"attributes", "scan-interval", "default"}).set(5000);
        root.get(new String[]{"attributes", "auto-deploy-zipped", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "auto-deploy-zipped", "description"}).set(bundle.getString("scanner.auto.deploy.zipped"));
        root.get(new String[]{"attributes", "auto-deploy-zipped", "required"}).set(false);
        root.get(new String[]{"attributes", "auto-deploy-zipped", "default"}).set(true);
        root.get(new String[]{"attributes", "auto-deploy-exploded", "type"}).set(ModelType.BOOLEAN);
        root.get(new String[]{"attributes", "auto-deploy-exploded", "description"}).set(bundle.getString("scanner.auto.deploy.exploded"));
        root.get(new String[]{"attributes", "auto-deploy-exploded", "required"}).set(false);
        root.get(new String[]{"attributes", "auto-deploy-exploded", "default"}).set(false);
        root.get(new String[]{"attributes", "deployment-timeout", "type"}).set(ModelType.LONG);
        root.get(new String[]{"attributes", "deployment-timeout", "description"}).set(bundle.getString("scanner.deployment.timeout"));
        root.get(new String[]{"attributes", "deployment-timeout", "required"}).set(false);
        root.get(new String[]{"attributes", "deployment-timeout", "default"}).set(60L);
        root.get("operations");
        root.get("children");
        return root;
    }

    static final ModelNode getScannerAdd(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("add");
        operation.get("description").set(bundle.getString("scanner.add"));
        operation.get(new String[]{"request-properties", "path", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "path", "description"}).set(bundle.getString("scanner.path"));
        operation.get(new String[]{"request-properties", "path", "required"}).set(true);
        operation.get(new String[]{"request-properties", "path", "min-length"}).set(1);
        operation.get(new String[]{"request-properties", "relative-to", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "relative-to", "description"}).set(bundle.getString("scanner.relative-to"));
        operation.get(new String[]{"request-properties", "relative-to", "required"}).set(false);
        operation.get(new String[]{"request-properties", "scan-enabled", "type"}).set(ModelType.BOOLEAN);
        operation.get(new String[]{"request-properties", "scan-enabled", "description"}).set(bundle.getString("scanner.enabled"));
        operation.get(new String[]{"request-properties", "scan-enabled", "required"}).set(false);
        operation.get(new String[]{"request-properties", "scan-enabled", "default"}).set(true);
        operation.get(new String[]{"request-properties", "scan-interval", "type"}).set(ModelType.INT);
        operation.get(new String[]{"request-properties", "scan-interval", "description"}).set(bundle.getString("scanner.interval"));
        operation.get(new String[]{"request-properties", "scan-interval", "required"}).set(false);
        operation.get(new String[]{"request-properties", "scan-interval", "default"}).set(5000);
        operation.get(new String[]{"request-properties", "auto-deploy-zipped", "type"}).set(ModelType.BOOLEAN);
        operation.get(new String[]{"request-properties", "auto-deploy-zipped", "description"}).set(bundle.getString("scanner.auto.deploy.zipped"));
        operation.get(new String[]{"request-properties", "auto-deploy-zipped", "required"}).set(false);
        operation.get(new String[]{"request-properties", "auto-deploy-zipped", "default"}).set(true);
        operation.get(new String[]{"request-properties", "auto-deploy-exploded", "type"}).set(ModelType.BOOLEAN);
        operation.get(new String[]{"request-properties", "auto-deploy-exploded", "description"}).set(bundle.getString("scanner.auto.deploy.exploded"));
        operation.get(new String[]{"request-properties", "auto-deploy-exploded", "required"}).set(false);
        operation.get(new String[]{"request-properties", "auto-deploy-exploded", "default"}).set(false);
        operation.get(new String[]{"request-properties", "deployment-timeout", "type"}).set(ModelType.LONG);
        operation.get(new String[]{"request-properties", "deployment-timeout", "description"}).set(bundle.getString("scanner.deployment.timeout"));
        operation.get(new String[]{"request-properties", "deployment-timeout", "required"}).set(false);
        operation.get(new String[]{"request-properties", "deployment-timeout", "default"}).set(60L);
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    static final ModelNode getScannerRemove(Locale locale) {
        ResourceBundle bundle = DeploymentSubsystemDescriptions.getResourceBundle(locale);
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set("remove");
        operation.get("description").set(bundle.getString("scanner.remove"));
        operation.get("request-properties").setEmptyObject();
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

